# -*- coding: utf-8 -*-
import os
import sys
import datetime
import threading
from itertools import product
from threading import Thread

import pandas as pd
from dateutil.relativedelta import relativedelta

from sqlalchemy import create_engine
import multiprocessing as mtp

reload(sys)
sys.setdefaultencoding('utf8')

'''
现金贷还款表
1、现金贷还款汇总
2、还款时间使用账单时间
3、特殊 新马上
'''

read_fund_sql = '''
select id fund_corp_id,name fund_name from new_transaction.funding_corp WHERE  id NOT  IN (340)
'''
read_repay_sql = '''
SELECT id,`approach_name` FROM new_transaction.`repay_channel`
'''

engine_new_transaction = engine_new_transaction = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/all_back_0630?charset=utf8',
    echo=True)

df_fund = pd.read_sql(read_fund_sql, con=engine_new_transaction)
df_approach = pd.read_sql(read_repay_sql, engine_new_transaction)
df_approach['id'] = df_approach['id'].astype(int)

path = './'

fundcodes = [
    1, 0, 3, 2, 5, 29, 4, 141, 50, 70, 80, 90, 100, 120, 110, 130, 150, 170, 180, 140, 190, 200, 210, 135, 230,
    240,
    250, 251, 260, 300, 290, 270, 330, 310, 320, 350, 340, 360, 363]

################################################
# 明细
read_detail_online_sql = '''
SELECT t1.id plan_id,t1.fund_code,t2.repay_channel,t1.real_loan_id loan_id,t3.contract_term,t1.term_no,
t6.bill_time repaid_at,t2.ref_amount,t2.principle-t2.mitigate_principle real_principle,t2.interest-t2.mitigate_interest real_interest,
t2.`service_fee`-t2.mitigate_service_fee real_service_fee,t2.`punish`-t2.mitigate_collection_relief real_punish,t2.remain_income, t6.order_id
FROM `xjd_repay_plan_repay_record_ref` t2
JOIN `user_repayment_plan` t1 ON t1.id=t2.plan_id
JOIN `loan_manifest` t3 ON t1.ref_id=t3.ref_id
JOIN repay_record_online t6 ON t2.record_id=t6.id AND t2.repay_channel < 13
WHERE  t3.loan_paid_at >= '%s'
AND t3.loan_paid_at < '%s'
AND t6.bill_time >= '%s' and t6.bill_time < '%s' AND t3.funding_code=%s
'''

read_detail_alipay_sql = '''
SELECT t1.id plan_id,t1.fund_code,t2.repay_channel,t1.real_loan_id loan_id,t3.contract_term,t1.term_no,
t6.transfer_time repaid_at,t2.ref_amount,t2.principle-t2.mitigate_principle real_principle,t2.interest-t2.mitigate_interest real_interest,
t2.`service_fee`-t2.mitigate_service_fee real_service_fee,t2.`punish`-t2.mitigate_collection_relief real_punish,t2.remain_income, t6.business_flow order_id
FROM `xjd_repay_plan_repay_record_ref` t2
JOIN `user_repayment_plan` t1 ON t1.id=t2.plan_id
JOIN `loan_manifest` t3 ON t1.ref_id=t3.ref_id
JOIN `offline_alipay_record` t6 ON t2.record_id=t6.id and t2.repay_channel = 13
WHERE  t3.loan_paid_at >= '%s'
AND t3.loan_paid_at < '%s'
AND t6.transfer_time >= '%s' AND  t6.transfer_time < '%s' AND t3.funding_code=%s
'''

read_detail_bank_sql = '''
SELECT t1.id plan_id,t1.fund_code,t2.repay_channel,t1.real_loan_id loan_id,t3.contract_term,t1.term_no,
t6.transfer_time repaid_at,t2.ref_amount,t2.principle-t2.mitigate_principle real_principle,t2.interest-t2.mitigate_interest real_interest,
t2.`service_fee`-t2.mitigate_service_fee real_service_fee,t2.`punish`-t2.mitigate_collection_relief real_punish,t2.remain_income,'' order_id
FROM `xjd_repay_plan_repay_record_ref` t2
JOIN `user_repayment_plan` t1 ON t1.id=t2.plan_id
JOIN `loan_manifest` t3 ON t1.ref_id=t3.ref_id
JOIN `offline_bank_repay_record` t6 ON t2.record_id=t6.id and t2.repay_channel in (14,15,16)
WHERE  t3.loan_paid_at >= '%s'
AND t3.loan_paid_at < '%s'
AND t6.transfer_time >=  '%s' AND  t6.transfer_time <  '%s' AND t3.funding_code=%s
'''


# 还款明细
def handle_hk(fund_code):
    start_time = datetime.datetime(2017, 1, 1, 0, 0, 0)
    end_time = datetime.datetime(2017, 7, 1, 0, 0, 0)
    start_loanPaid_time = datetime.datetime(2015, 1, 1, 0, 0, 0)
    end_loanPaid_time = datetime.datetime(2017, 1, 1, 0, 0, 0)
    df_online_detail = pd.read_sql(
        read_detail_online_sql % (start_loanPaid_time, end_loanPaid_time, start_time, end_time, fund_code),
        con=engine_new_transaction)
    print read_detail_online_sql % (start_loanPaid_time, end_loanPaid_time, start_time, end_time, fund_code)
    df_alipay_detail = pd.read_sql(
        read_detail_alipay_sql % (start_loanPaid_time, end_loanPaid_time, start_time, end_time, fund_code),
        con=engine_new_transaction)
    print read_detail_alipay_sql % (start_loanPaid_time, end_loanPaid_time, start_time, end_time, fund_code)
    df_bank_detail = pd.read_sql(
        read_detail_bank_sql % (start_loanPaid_time, end_loanPaid_time, start_time, end_time, fund_code),
        con=engine_new_transaction)
    df = pd.concat([df_online_detail, df_alipay_detail, df_bank_detail], axis=0)
    if len(df) > 0:
        df['repay_channel'] = df['repay_channel'].astype(int)
        df['fund_code'] = df['fund_code'].astype(int)
        df = pd.merge(df, df_approach, left_on=['repay_channel'], right_on=['id'], how='left')
        df = pd.merge(df, df_fund, left_on=['fund_code'], right_on=['fund_corp_id'], how='left')

        df.reset_index(inplace=True)
        df = df[['fund_name', 'loan_id', 'contract_term',
                 'term_no', 'repaid_at', 'ref_amount',
                 'real_principle', 'real_interest',
                 'real_service_fee', 'real_punish', 'remain_income', 'order_id', 'approach_name']]
        df.sort_values(by=['loan_id', 'term_no'], inplace=True)
        df.rename(
            columns={'fund_name': '资金方',
                     'loan_id': '放款id',
                     'contract_term': '放款期数',
                     'term_no': '期数',
                     'repaid_at': '实还款日',
                     'ref_amount': '实还金额',
                     'real_principle': '本金',
                     'real_interest': '利息',
                     'real_service_fee': '服务费',
                     'real_punish': '罚息',
                     'remain_income': '其他收益',
                     'order_id': '渠道流水号',
                     'approach_name': '收款账户'
                     }, inplace=True)
        df.to_excel(path + str(2017) + '_' + str(fund_code) + '.xlsx', columns=df.columns,
                    index=None, encoding='utf8')


if __name__ == '__main__':
    # 还款汇总--如果不需要可注释
    # hk_hz()
    # 还款明细
    # pool = mtp.Pool(processes=6)
    years = [2015, 2016]
    months = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
    for fundcode in fundcodes:
        handle_hk(fundcode)
        # pool.apply_async(handle_hk, (year, month))
        # pool.close()
        # pool.join()

print '======================main done==================================='
