# -*- encoding: utf8 -*-

"""
目标：
    收入确认表-以loan_id为维度比较风险金及客户实还服务费
数据库：

字段名：
    loan_id，资金方，风险等级，本金债权，放款日期，计提风险金比例，计提风险金，实还服务费（减免后，含一次性服务费），Asset余额，收入确认金额
注意：
    加入一次性服务费，计提风险金比例
    每个时间点用对应时间点的备份库，eg：17年4月30号之前的用430数据库，5月31号之前的用531库。。。
"""

import os

import datetime
import numpy as np
import pandas as pd

from db_con.db_connect import sql_engine

# ----------------------------------------------
step = 10000
max_limit = 900000
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)

file_path = u'E:/审计出表/现金贷/人工控制new'
file_name = u'收入确认表'
if not os.path.exists(file_path):
    os.makedirs(file_path)
mysql = sql_engine('audit', 'new_transaction', False).get_engine()

sql_loan_plan = """
SELECT
  lm.ref_id,
  lm.funding_code,
  fc.name                                          资金方,
  lm.loan_id,
  lc.class                                     风险等级,
  lm.contract_loan_amount                          本金债权,
  date(lm.loan_paid_at)                            放款日期,
  year(lm.loan_paid_at)                            年,
  month(lm.loan_paid_at)                           月,
  xrprrr.ref_amount                                实还总额,
  xrprrr.principle - xrprrr.mitigate_principle     实还本金,
  xrprrr.interest - xrprrr.mitigate_interest       实还利息,
  xrprrr.service_fee - xrprrr.mitigate_service_fee 实还服务费,
  date(rr.repaid_at)                               实还日期,
  rc.approach_name                                 还款账户,
  rr.repay_channel_flow_id                         流水号
FROM %s.xjd_repay_plan_repay_record_ref xrprrr
JOIN test_mzh.repay_record_amount rr
ON rr.record_id = xrprrr.record_id AND rr.repay_channel = xrprrr.repay_channel
AND rr.repaid_at >= '%s' AND rr.repaid_at < '%s'
JOIN new_transaction.repay_channel rc ON rc.id = xrprrr.repay_channel
JOIN %s.user_repayment_plan urp ON urp.id = xrprrr.plan_id
JOIN %s.loan_manifest lm ON lm.ref_id = urp.ref_id AND lm.funding_code <> 340
JOIN basic.funding_corp fc ON fc.funding_code = lm.funding_code
JOIN test_mzh.loan_class_contract lc ON lc.ref_id = lm.ref_id;
"""

sql_yghs = """
SELECT
  lm.ref_id,
  lm.funding_code,
  fc.name                 资金方,
  lm.loan_id,
  lc.class            风险等级,
  lm.contract_loan_amount 本金债权,
  date(lm.loan_paid_at)   放款日期,
  year(lm.loan_paid_at)   年,
  month(lm.loan_paid_at)  月,
  t.actual_repay_amount   实还总额,
  t.actual_principle      实还本金,
  t.actual_interest       实还利息,
  t.actual_qg_service_fee 实还服务费,
  date(t.repay_date)      实还日期,
  '阳光徽商'               还款账户,
  ''                      流水号
FROM new_transaction.yg_huishang_repay_term t
  JOIN audit.loan_manifest lm ON lm.ref_id = t.ref_id AND lm.funding_code = 340
                                 AND t.repay_date >= '%s' AND t.repay_date < '%s'
  JOIN basic.funding_corp fc ON fc.funding_code = lm.funding_code
  JOIN test_mzh.loan_class_contract lc ON lc.ref_id = lm.ref_id;
"""

sql_dunjiao = """
SELECT
  lm.ref_id,
  lm.funding_code,
  fc.name                  资金方,
  lm.loan_id,
  lc.class             风险等级,
  lm.contract_loan_amount  本金债权,
  date(lm.loan_paid_at)    放款日期,
  year(lm.loan_paid_at)    年,
  month(lm.loan_paid_at)   月,
  xdpr.ref_amount          实还总额,
  0                        实还本金,
  0                        实还利息,
  xdpr.ref_amount          实还服务费,
  date(rr.repaid_at)       实还日期,
  rc.approach_name         还款账户,
  rr.repay_channel_flow_id 流水号
FROM new_transaction.xjd_dunjiao_plan_ref xdpr
  JOIN new_transaction.xjd_dunjiao_plan xdp ON xdp.id = xdpr.plan_id
  JOIN test_mzh.repay_record_amount rr
    ON rr.record_id = xdpr.record_id AND rr.repay_channel = xdpr.repay_channel
       AND rr.repaid_at >= '%s' AND rr.repaid_at < '%s'
  JOIN new_transaction.repay_channel rc ON rc.id = xdpr.repay_channel
  JOIN audit.loan_manifest lm ON lm.ref_id = xdp.ref_id
  JOIN basic.funding_corp fc ON fc.funding_code = lm.funding_code
  JOIN test_mzh.loan_class_contract lc ON lc.ref_id = lm.ref_id;
"""
res_cols = [u'资金方', u'loan_id', u'风险等级', u'本金债权', u'放款日期', u'计提风险金比例', u'计提风险金', u'实还总额', u'实还本金', u'实还利息', u'实还服务费',
            u'实还日期', u'还款账户', u'流水号']

db_names1 = ['new_transaction', ]
db_names2 = ['audit', ]
start_dates = [datetime.date(2017, 4, 1), datetime.date(2017, 9, 1), datetime.date(2017, 9, 1), datetime.date(2017, 9, 1), ]
end_dates = [datetime.date(2017, 10, 1), ]
sql_ratio = """SELECT class 风险等级, year 年, month 月, bad_debt_ratio 计提风险金比例 FROM test_mzh.service_fee_ratio"""
df_ratio = pd.read_sql(sql=sql_ratio, con=mysql)
for i in range(0, len(db_names1)):
    db_name1 = db_names1[i]
    db_name2 = db_names2[i]
    start_date = start_dates[i]
    end_date = end_dates[i]
    print start_date
    # ----------------------------------------------
    df_gen = pd.read_sql(sql=sql_loan_plan % (db_name1, start_date, end_date, db_name1, db_name2), con=mysql,
                         chunksize=step)
    res = []
    for tmp in df_gen:
        res.append(tmp)
    df_loan = pd.concat(res)
    print '正常实还', df_loan[u'实还服务费'].sum()

    df_dunjiao = pd.read_sql(sql=sql_dunjiao % (start_date, end_date), con=mysql)
    if len(df_dunjiao) > 0:
        print '趸交', df_dunjiao[u'实还服务费'].sum()
        df_loan = df_loan.append(df_dunjiao)
    df_yghs = pd.read_sql(sql=sql_yghs % (start_date, end_date), con=mysql)
    if len(df_yghs) > 0:
        print '阳光徽商', df_yghs[u'实还服务费'].sum()
        df_loan = df_loan.append(df_yghs)

    df_loan_ratio = pd.merge(df_loan, df_ratio, on=[u'风险等级', u'年', u'月'], how='left')
    df_loan_ratio.loc[df_loan_ratio.funding_code.isin([270, 310, 320, 410]), u'计提风险金比例'] = 0
    df_loan_ratio[u'计提风险金'] = np.round(df_loan_ratio[u'本金债权'] * df_loan_ratio[u'计提风险金比例'], 2)
    print '全部', df_loan_ratio[u'实还服务费'].sum()

    df_loan_ratio.loc[df_loan_ratio['ref_id'].duplicated(), [u'本金债权', u'计提风险金']] = 0
    df_loan_ratio = df_loan_ratio[res_cols]
    df_loan_ratio.to_csv(
        os.path.join(file_path, '收入确认表流水号(%s-%02d)_%s.csv' % (start_date.year, start_date.month, db_name1)),
        encoding='utf8',
        index=None)

df_loan_ratio.to_excel(os.path.join(file_path, '收入确认表流水号(%s-%02d).xlsx' % (start_date.year, start_date.month)),
                       index=None)

if len(df_loan_ratio) > max_limit:
    for i in xrange(0, len(df_loan_ratio), max_limit):
        df_loan_ratio[i:i + max_limit].to_csv(
            os.path.join(file_path,
                         '收入确认表流水号(%s-%02d)-%d.csv' % (start_date.year, start_date.month, i / max_limit + 1)),
            encoding='utf8',
            index=None)

sql_chayi = """
SELECT
  lm.ref_id,
  lm.funding_code,
  fc.name                                          资金方,
  lm.loan_id,
  lc0912.class                                     风险等级,
  lm.contract_loan_amount                          本金债权,
  date(lm.loan_paid_at)                            放款日期,
  year(lm.loan_paid_at)                            年,
  month(lm.loan_paid_at)                           月,
  xrprrr.ref_amount                                实还总额,
  xrprrr.principle - xrprrr.mitigate_principle     实还本金,
  xrprrr.interest - xrprrr.mitigate_interest       实还利息,
  xrprrr.service_fee - xrprrr.mitigate_service_fee 实还服务费,
  date(rr.repaid_at)                               实还日期,
  rc.approach_name                                 还款账户,
  rr.repay_channel_flow_id                         流水号
FROM %s.xjd_repay_plan_repay_record_ref xrprrr
  JOIN test_mzh.repay_record_amount_1006 rr
    ON rr.record_id = xrprrr.record_id AND xrprrr.repay_channel = rr.repay_channel AND rr.repaid_at < '%s'
  LEFT JOIN %s.xjd_repay_plan_repay_record_ref t2 ON t2.id = xrprrr.id
  JOIN new_transaction.repay_channel rc ON rc.id = xrprrr.repay_channel
  JOIN %s.user_repayment_plan urp ON urp.id = xrprrr.plan_id
  JOIN %s.loan_manifest lm ON lm.ref_id = urp.ref_id AND lm.funding_code <> 340
  JOIN basic.funding_corp fc ON fc.funding_code = lm.funding_code
  JOIN test_mzh.loan_class_contract_1002 lc0912 ON lc0912.ref_id = lm.ref_id
WHERE t2.id IS NULL;
"""
# df_loan = pd.read_sql(
#     sql=sql_chayi % ('all_back_0731', '2017-07-01', 'all_back_0630', 'all_back_0731', 'all_back_0731'), con=mysql)
# df_loan_ratio = pd.merge(df_loan, df_ratio, on=[u'风险等级', u'年', u'月'], how='left')
# df_loan_ratio.loc[df_loan_ratio.funding_code.isin([270, 310, 320, 410]), u'计提风险金比例'] = 0
# df_loan_ratio[u'计提风险金'] = np.round(df_loan_ratio[u'本金债权'] * df_loan_ratio[u'计提风险金比例'], 2)
# print '全部', df_loan_ratio[u'实还服务费'].sum()
#
# df_loan_ratio.loc[df_loan_ratio['ref_id'].duplicated(), [u'本金债权', u'计提风险金']] = 0
# df_loan_ratio = df_loan_ratio[res_cols]
# df_loan_ratio.to_csv(
#     os.path.join(file_path, '支付宝7月确认之前表.csv'),
#     encoding='utf8',
#     index=None)

# df_loan = pd.read_sql(
#     sql=sql_chayi % ('all_back_0831', '2017-08-01', 'all_back_0731', 'all_back_0831', 'all_back_0831'), con=mysql)
# df_loan_ratio = pd.merge(df_loan, df_ratio, on=[u'风险等级', u'年', u'月'], how='left')
# df_loan_ratio.loc[df_loan_ratio.funding_code.isin([270, 310, 320, 410]), u'计提风险金比例'] = 0
# df_loan_ratio[u'计提风险金'] = np.round(df_loan_ratio[u'本金债权'] * df_loan_ratio[u'计提风险金比例'], 2)
# print '全部', df_loan_ratio[u'实还服务费'].sum()
#
# df_loan_ratio.loc[df_loan_ratio['ref_id'].duplicated(), [u'本金债权', u'计提风险金']] = 0
# df_loan_ratio = df_loan_ratio[res_cols]
# df_loan_ratio.to_csv(
#     os.path.join(file_path, '支付宝8月确认之前表.csv'),
#     encoding='utf8',
#     index=None)
df_loan = pd.read_sql(
    sql=sql_chayi % ('new_transaction', '2017-09-01', 'all_back_0831', 'new_transaction', 'audit'), con=mysql)
df_loan_ratio = pd.merge(df_loan, df_ratio, on=[u'风险等级', u'年', u'月'], how='left')
df_loan_ratio.loc[df_loan_ratio.funding_code.isin([270, 310, 320, 410]), u'计提风险金比例'] = 0
df_loan_ratio[u'计提风险金'] = np.round(df_loan_ratio[u'本金债权'] * df_loan_ratio[u'计提风险金比例'], 2)
print '全部', df_loan_ratio[u'实还服务费'].sum()

df_loan_ratio.loc[df_loan_ratio['ref_id'].duplicated(), [u'本金债权', u'计提风险金']] = 0
df_loan_ratio = df_loan_ratio[res_cols]
df_loan_ratio.to_csv(
    os.path.join(file_path, '支付宝9月确认之前表.csv'),
    encoding='utf8',
    index=None)