# -*- encoding: utf8 -*-

import pandas as pd
from sqlalchemy import create_engine
import numpy as np

pd.options.mode.chained_assignment = None

'''
'''

engine_audit = create_engine(
    'mysql+mysqldb://bo.wang:#mn89453YU9io80@172.16.3.201:3306/audit_temp?charset=utf8', echo=True)


# 检查不一致的xjd_ref记录
sql_check_diff_xjd_ref = """
SELECT
  t1.id,
  t1.plan_id,
	t1.principle,
	t2.principle,
	t1.interest,
	t2.interest,
	t1.service_fee,
	t2.service_fee,
	t1.punish,
	t2.punish,
	t1.red_package_fee,
	t2.red_package_fee,
	t1.ref_amount,
	t2.ref_amount,
	t1.collection_relief,
	t2.collection_relief,
	t1.mitigate_all,
	t2.mitigate_all,
	t1.mitigate_collection_relief,
	t2.mitigate_collection_relief,
	t1.mitigate_interest,
	t2.mitigate_interest,
	t1.mitigate_principle,
	t2.mitigate_principle,
	t1.remain_income,
	t2.remain_income
FROM
	xjd_repay_plan_repay_record_ref t1
JOIN all_back_0831.xjd_repay_plan_repay_record_ref t2 ON t1.id = t2.id
WHERE
	t1.principle != t2.principle
OR t1.interest != t2.interest
OR t1.punish != t2.punish
OR t1.service_fee != t2.service_fee
OR t1.red_package_fee != t2.red_package_fee
OR t1.ref_amount != t2.ref_amount
OR t1.collection_relief != t2.collection_relief
OR t1.mitigate_all != t2.mitigate_all
OR t1.mitigate_collection_relief != t2.mitigate_collection_relief
OR t1.mitigate_interest != t2.mitigate_interest
OR t1.mitigate_principle !=t2.mitigate_principle
OR t1.remain_income != t2.remain_income
"""

# 检查放款金额和本金之和是否相等
sql_check_loan_total_principal = """
SELECT
	temp_table.id,
 temp_table.principle,
 temp_table.interest,
 temp_table.repayment_plan_id,
 temp_table.total_principle,
 t3.contract_loan_amount,
 t3.ref_id
FROM
	audit.loan_manifest t3
JOIN (
	SELECT
		t1.ref_id,
    t2.id,
    t2.principle,
    t2.interest,
    t2.repayment_plan_id,
		sum(t2.principle) total_principle
	FROM
		audit.loan_manifest t1
	JOIN user_repayment_plan t2 ON t1.ref_id = t2.ref_id
	WHERE
		t1.is_active IN (1 ,- 2)
	AND t1.loan_paid_at >= "2017-10-01"
	AND t1.loan_paid_at < "2017-11-01"
	GROUP BY
		t1.ref_id
) AS temp_table  ON t3.ref_id = temp_table.ref_id AND abs(t3.contract_loan_amount-temp_table.total_principle)!=0
"""
# 检查是否有不合理的remain
sql_check_remain = """
SELECT
  t1.fund_code,
	t2.*
FROM
	user_repayment_plan t1
JOIN xjd_repay_plan_repay_record_ref t2 ON t1.id = t2.plan_id
WHERE
  (t1.fund_code!=300 AND t1.fund_code!=340)
AND	t1.xyqb_repaid_at >= "2017-10-01" AND t2.remain_income>0;
"""
sql_check_sql_ref_5 = """
SELECT * FROM xjd_repay_plan_repay_record_ref t1 JOIN repay_record_online t2 ON t1.record_id=t2.id AND t1.repay_channel=t2.pay_approach GROUP BY t1.record_id   HAVING ROUND(SUM(t1.ref_amount) - t2.amount,2) <> 0
"""
# 查询流水没有关联上的情况
sql_check_xjd_ref_repay_record = """
SELECT
	*
FROM
	repay_record_online t1
LEFT JOIN xjd_repay_plan_repay_record_ref t2 ON t1.id = t2.record_id AND t1.pay_approach = t2.repay_channel
WHERE
	t1.pay_approach IN (2, 4, 6, 8, 10, 11, 12,20,21)

AND t1.bill_time >= "2017-09-01"
AND t1.bill_time < "2017-10-01"
AND t2.id IS NULL
"""
sql_check_sql_ref_1 = """
SELECT plan_id  FROM `xjd_repay_plan_repay_record_ref` WHERE ref_amount>0 AND `ref_amount` <> `principle`+`interest`+`service_fee`+`punish`-`collection_relief`+`remain_income`
"""

sql_check_sql_ref_2 = """
SELECT plan_id FROM `xjd_repay_plan_repay_record_ref` WHERE `collection_relief` <> `mitigate_collection_relief`+`mitigate_service_fee`+`mitigate_interest`+`mitigate_principle`
"""

sql_check_sql_ref_3 = """
SELECT plan_id FROM `xjd_repay_plan_repay_record_ref` WHERE `collection_relief` <> `mitigate_all`+`red_package_fee`
"""

sql_check_sql_ref_4 = """
SELECT
	t1.id,
	t1.plan_id,
	t1.record_id,
	t1.ref_amount,
	(
		t1.principle - t1.mitigate_principle + t1.interest - t1.mitigate_interest + t1.punish - t1.mitigate_collection_relief + t1.service_fee - t1.mitigate_service_fee + t1.remain_income
	) total_amount
FROM
	xjd_repay_plan_repay_record_ref t1
JOIN new_transaction.offline_alipay_record t2 ON t1.record_id = t2.id
AND t1.repay_channel = 13
WHERE
	t1.ref_amount != (
		t1.principle - t1.mitigate_principle + t1.interest - t1.mitigate_interest + t1.punish - t1.mitigate_collection_relief + t1.service_fee - t1.mitigate_service_fee + t1.remain_income
	);
"""

sql_check_sql_plan_1 = """
SELECT t1.plan_id,SUM(t1.`red_package_fee`),t2.`red_package` FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t2 ON t1.plan_id = t2.id
GROUP BY t1.plan_id HAVING SUM(t1.red_package_fee) <> t2.red_package
"""

sql_check_sql_plan_2 = """
SELECT id plan_id FROM `user_repayment_plan` WHERE `current_repayment` <> `real_principle`+`real_interest`+`real_service_fee`+`real_punish`-`collection_relief`+`remain`
"""

sql_check_sql_plan_3 = """
SELECT id plan_id FROM `user_repayment_plan` WHERE `collection_relief` <> `mitigate_all`+`red_package`
"""

sql_check_sql_plan_4 = """
SELECT plan_id FROM `xjd_repay_plan_repay_record_ref` WHERE `red_package_fee` > 0 AND `remain_income` > 0
"""

sql_check_sql_plan_5 = """
SELECT t1.plan_id,SUM(t1.ref_amount),t2.current_repayment FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t2 ON t1.plan_id = t2.id
GROUP BY t1.plan_id HAVING SUM(t1.ref_amount) <> t2.current_repayment
"""

# collection_relief
sql_check_sql_plan_6 = """
SELECT t1.plan_id,SUM(t1.`collection_relief`),t2.collection_relief FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t2 ON t1.plan_id = t2.id AND  t1.ref_amount>0
GROUP BY t1.plan_id HAVING SUM(t1.collection_relief) <> t2.collection_relief
"""

sql_check_sql_plan_7 = """
SELECT t1.plan_id,SUM(t1.`principle`),t2.`real_principle` FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t2 ON t1.plan_id = t2.id AND t1.ref_amount>0
GROUP BY t1.plan_id HAVING ROUND(SUM(t1.principle) - t2.real_principle,2) <> 0
"""

sql_check_sql_plan_8 = """
SELECT t1.plan_id,SUM(t1.`service_fee`),t2.`real_service_fee` FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t2 ON t1.plan_id = t2.id AND t1.ref_amount>0
GROUP BY t1.plan_id HAVING SUM(t1.service_fee) <> t2.real_service_fee
"""

sql_check_sql_plan_9 = """
SELECT t1.plan_id,SUM(t1.`interest`),t2.`real_interest` FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t2 ON t1.plan_id = t2.id AND t1.ref_amount>0
GROUP BY t1.plan_id HAVING ROUND(SUM(t1.interest) - t2.real_interest,2) <> 0
"""

# plan_id	SUM(t1.`remain_income`)	remain
# 14062323	-0.020000	0.000000
sql_check_sql_plan_10 = """
SELECT t1.plan_id,SUM(t1.`remain_income`),t2.`remain` FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t2 ON t1.plan_id = t2.id
GROUP BY t1.plan_id HAVING ROUND(SUM(t1.remain_income) - t2.remain,2) <> 0
"""

sql_ref_list = [sql_check_sql_ref_1, sql_check_sql_ref_2, sql_check_sql_ref_3,sql_check_sql_ref_4,sql_check_sql_ref_5]
# sql_check_sql_plan_5,
sql_plan_list = [sql_check_sql_plan_1, sql_check_sql_plan_2, sql_check_sql_plan_3, sql_check_sql_plan_4,
                 sql_check_sql_plan_5,sql_check_sql_plan_6, sql_check_sql_plan_7, sql_check_sql_plan_8,
                 sql_check_sql_plan_9, sql_check_sql_plan_10]

for sql_check_ref in sql_ref_list:
    df_check_ref = pd.read_sql(sql=sql_check_ref, con=engine_audit)
    if len(df_check_ref) > 0:
        print str(tuple(df_check_ref.plan_id))
        print sql_check_ref

print "ref table is OK"

# for sql_check_plan in sql_plan_list:
#     df_check_plan = pd.read_sql(sql=sql_check_plan, con=engine_audit)
#     if len(df_check_plan) > 0:
#         print str(tuple(df_check_plan.plan_id))
#         print sql_check_plan
#
print "ref table is OK"
