# -*- coding: utf-8 -*-
from sqlalchemy import create_engine
import pandas as pd
import numpy as np
import sys
import datetime

reload(sys)
sys.setdefaultencoding('utf8')

'''
1、问财务要量化派同资金方之间的打款流水转账记录
2、根据提供的数据录入到audit.fund_to_bank_2017,fund_to_lkb,lkb_to_fund 表中
3、2017.5月所有资金方都是直投模式，无资金方打款给量化派
'''
engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/audit?charset=utf8',
                             echo=True)

'量化派打款给资金方'


def lkb_to_fund():
    filename = u'E:/xyqb/还资金方打款明细/lkb2fund.xlsx'
    df = pd.read_excel(filename, header=None,
                       names=['transfer_time',
                              'receipt_or_pay',
                              'repay_type',
                              'fund_corp',
                              'fee_type',
                              'remark',
                              'debtor',
                              'transfer_amount',
                              'balance'])
    df = df.ix[df['receipt_or_pay'] == u'付']
    df['transfer_time'] = pd.to_datetime(df.transfer_time).dt.date
    df = df.ix[(df.transfer_time >= datetime.date(2017, 9, 1))]
    df.transfer_time = pd.to_datetime(df.transfer_time).apply(lambda x: x.date())
    df = df[['transfer_time', 'fund_corp', 'transfer_amount', 'remark']]
    df['bank'] = u'平安银行'
    df.to_sql(name='lkb_to_fund', con=engine_audit, if_exists='append', index=None)


# lkb_to_fund()
file_path = u"E:/现金贷/交易流水号匹配/2017-09/"


def lkb2fund():
    df = pd.read_excel(file_path + u'众信利民9月现金贷一般户15000033023605银行流水.xls', sheetname='Sheet1',
                       converters={'flow_id': str})
    df.rename(columns={'ref_amount': 'transfer_amount'}, inplace=True)
    df['transfer_time'] = pd.to_datetime(df['transfer_time'], format='%Y%m%d').apply(lambda x: x.date())
    df = df.ix[(df.transfer_time >= datetime.date(2017, 9, 1))]
    df.transfer_time = pd.to_datetime(df.transfer_time).apply(lambda x: x.date())
    df['transfer_amount'] = df['transfer_amount'].apply(lambda x: np.round(x, 2))
    df = df[['fund_corp', 'bank', 'transfer_time', 'transfer_amount']]
    df.to_sql('lkb_to_fund', con=engine_audit, if_exists='append', index=None)

lkb2fund()