# coding: utf-8
import sys

stdout = sys.stdout
# 加入父级搜索路径，根据情况修改

import pandas as pd
import numpy as np
import datetime
import os
from sqlalchemy import create_engine

sys.stdout = stdout
# 引入数据库连接，并使修改生效
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
mysql_engine = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/audit?charset=utf8', echo=False)
path = u'E:/每日赔付/HongKong/'

sql_loan = """
SELECT
  date(lm.loan_paid_at)   放款时间,
  lc.class                风险等级,
  lm.loan_id,
  lm.contract_loan_amount 本金债权,
  lm.real_loan_amount     放款金额,
  lm.funding_code,
  lm.ref_id,
  lm.is_active
FROM all_back_0630.loan_manifest lm
JOIN temp.loan_class lc ON lc.ref_id = lm.ref_id 
WHERE date(lm.loan_paid_at) IN 
  ('2015-06-30', '2015-09-30', '2015-12-31',
  '2016-03-31', '2016-06-30', '2016-09-30', '2016-12-31') 
  AND lm.is_active IN (1, -2) 
  and lm.contract_term = 3;
"""
df_loan = pd.read_sql(sql=sql_loan, con=mysql_engine)

sql_plan = """
SELECT
  urp.ref_id,
  date(urp.deadline) deadline,
  urp.term_no,
  urp.principle      req_prin,
  urp.interest       req_inst,
  urp.fund_code,
  urp.id plan_id
FROM all_back_0630.user_repayment_plan urp
WHERE urp.ref_id IN %s;
"""
ref_ids = df_loan.ref_id.astype(str).tolist()
df_plan = pd.read_sql(sql=sql_plan % str(tuple(ref_ids)), con=mysql_engine)
df_plan['peifu_date'] = df_plan['deadline']
df_plan.loc[df_plan.fund_code == 150, 'peifu_date'] = \
    df_plan.loc[df_plan.fund_code == 150, 'peifu_date'] + datetime.timedelta(days=10)
df_plan.loc[df_plan.fund_code == 180, 'peifu_date'] = \
    df_plan.loc[df_plan.fund_code == 180, 'peifu_date'] + datetime.timedelta(days=1)

df_ms = df_loan.loc[df_loan.funding_code == 160]
df_other = df_loan.loc[df_loan.funding_code != 160]

sql_repay = """
SELECT
  urp.id                                            plan_id,
  urp.ref_id,
  urp.term_no,
  urp.principle                                     req_prin,
  urp.interest                                      req_inst,
  date(urp.deadline)                                deadline,
  xrprrr.principle - xrprrr.mitigate_principle      real_prin,
  xrprrr.interest - xrprrr.mitigate_interest        real_inst,
  xrprrr.punish - xrprrr.mitigate_collection_relief real_punish,
  date(xrprrrrd.repaid_at)                          repaid_at,
  urp.fund_code
FROM all_back_0630.xjd_repay_plan_repay_record_ref xrprrr
  JOIN temp.xjd_repay_plan_repay_record_ref_repay_date xrprrrrd ON xrprrr.id = xrprrrrd.xjd_ref_id
  JOIN all_back_0630.user_repayment_plan urp ON urp.id = xrprrr.plan_id AND urp.ref_id IN %s and xrprrrrd.repaid_at < '2017-07-01';
"""
ref_ids = df_other.ref_id.astype(str).tolist()
df_repay = pd.read_sql(sql=sql_repay % str(tuple(ref_ids)), con=mysql_engine)

len(df_repay)

sql_ms_repay = """
SELECT
  urp.id                               plan_id,
  urp.ref_id,
  urp.term_no,
  urp.principle                        req_prin,
  urp.interest                         req_inst,
  date(urp.deadline)                   deadline,
  nmtwtd.repay_principle               real_prin,
  nmtwtd.repay_intrest                 real_inst,
  nmtwtd.penalty_fee real_punish,
  date(nmtwtd.repaid_at)               repaid_at,
  urp.fund_code
FROM test_8_2.new_ms_transaction_with_term_details nmtwtd
  JOIN all_back_0630.user_repayment_plan urp ON urp.real_loan_id = nmtwtd.loan_id
                                                AND urp.term_no = nmtwtd.term_no
                                                AND urp.ref_id IN %s;
"""
ref_ids = df_ms.ref_id.astype(str).tolist()
df_ms_repay = pd.read_sql(sql=sql_ms_repay % str(tuple(ref_ids)), con=mysql_engine)

df_plan_repay = pd.concat([df_repay, df_ms_repay])
df_repay_good = df_plan_repay.loc[df_plan_repay.deadline >= df_plan_repay.repaid_at]
df_repay_bad = df_plan_repay.loc[df_plan_repay.deadline < df_plan_repay.repaid_at]

df_repay_good['real_prin_inst'] = df_repay_good.real_prin + df_repay_good.real_inst
groups = df_repay_good.groupby('plan_id')['real_prin_inst'].agg('sum').reset_index()
df_plan_good = df_plan.merge(groups, how='left')
df_plan_good.fillna(0, inplace=True)
df_plan_good['weiyue'] = np.round(df_plan_good.req_prin + df_plan_good.req_inst - df_plan_good.real_prin_inst, 2)

df_plan_good['req_date1'] = df_plan_good['term_no'].apply(lambda x: u'到期时间' + str(x))
df_plan_good['amount'] = df_plan_good['term_no'].apply(lambda x: u'违约金额' + str(x))
df_plan_good['req_date2'] = df_plan_good['term_no'].apply(lambda x: u'代偿时间' + str(x))

df_plan_good.sort_values(['ref_id', 'term_no'], inplace=True)
df_plan_good.head()

pivot1 = df_plan_good.pivot('ref_id', 'req_date1', 'deadline').reset_index()
pivot2 = df_plan_good.pivot('ref_id', 'amount', 'weiyue').reset_index()
pivot3 = df_plan_good.pivot('ref_id', 'req_date2', 'peifu_date').reset_index()
df_res = df_loan.merge(pivot1, how='left').merge(pivot2, 'left').merge(pivot3, 'left')
# cols = [u'放款时间', u'风险等级', u'loan_id', u'本金债权', u'放款金额', u'到期时间1', u'违约金额1', u'代偿时间1', u'到期时间2', u'违约金额2', u'代偿时间2', u'到期时间3', u'违约金额3', u'代偿时间3', 'ref_id']
# df_res = df_res[cols]
df_repay_bad['real_prin_inst'] = df_repay_bad['real_prin'] + df_repay_bad['real_inst']
df_repay_bad['real_prin_inst_pun'] = df_repay_bad['real_prin'] + df_repay_bad['real_inst'] + df_repay_bad['real_punish']
groups = pd.pivot_table(df_repay_bad, index='plan_id', values=['real_prin_inst', 'real_prin_inst_pun', 'repaid_at'],
                        aggfunc={'real_prin_inst': np.sum, 'real_prin_inst_pun': np.sum,
                                 'repaid_at': lambda x: list(x)[-1]}).reset_index()

df_plan_bad = df_plan.merge(groups, 'left')
df_plan_bad.fillna('', inplace=True)
df_plan_bad['repay_amt1'] = df_plan_bad['term_no'].apply(lambda x: u'催回金额（本息）' + str(x))
df_plan_bad['repay_amt2'] = df_plan_bad['term_no'].apply(lambda x: u'催回金额（本息罚）' + str(x))
df_plan_bad['repay_date'] = df_plan_bad['term_no'].apply(lambda x: u'催回时间' + str(x))
df_plan_bad.head()

pivot1 = df_plan_bad.pivot('ref_id', 'repay_amt1', 'real_prin_inst').reset_index()
pivot2 = df_plan_bad.pivot('ref_id', 'repay_amt2', 'real_prin_inst_pun').reset_index()
pivot3 = df_plan_bad.pivot('ref_id', 'repay_date', 'repaid_at').reset_index()
df_res = df_res.merge(pivot1, how='left').merge(pivot2, 'left').merge(pivot3, 'left')
cols = [u'放款时间', u'风险等级', u'loan_id', u'本金债权', u'放款金额', u'到期时间1', u'违约金额1', u'代偿时间1', u'到期时间2', u'违约金额2', u'代偿时间2',
        u'到期时间3', u'违约金额3', u'代偿时间3', u'催回金额（本息）1', u'催回金额（本息罚）1', u'催回时间1', u'催回金额（本息）2', u'催回金额（本息罚）2', u'催回时间2',
        u'催回金额（本息）3', u'催回金额（本息罚）3', u'催回时间3']
df_res = df_res[cols]

df_res.to_excel(path + 'res.xlsx', index=None)
# df_res.columns
# df_res.loc[df_res[u'放款时间'] == datetime.date(2016, 12, 31), u'放款金额'].sum()
# df_loan.groupby(u'放款时间')[[u'本金债权', u'放款金额']].agg(sum)
# df_res.groupby(u'放款时间')[u'本金债权', u'放款金额',].agg(sum)
