# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
from itertools import product
import os

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None
max_limit = 800000



#
# 表名称：
#	去哪儿-赔付明细
#表字段：
#	资金方	自然日，应还，提前还款可用，逾期还款，正常还款
# 数据库：
#	qunaer_new
# 注意事项：
#
#

file_path = u'E:/审计出表/去哪儿-赔付专区/'
engine_qunaer = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/qunaer_new?charset=utf8',
							  echo=False).connect()



# fund plan
sql_fund_plan='''
select fund_code,product_no,current_stage_no,principle,interest,fee_amount,due_amount,date(deadline) deadline
from qunaer_new.fund_repayment_plan 
'''

sql_del='''
select product_no from qunaer_new.fund_repay_detail where type  IN (5,7)
'''


sql_repay='''
select repay.product_no,pay.fund_code,current_stage_no,date(repay_time) repay_time,repay_principle,repay_fee_amount,repay_due_amount
from qunaer_new.repay_detail  repay
JOIN qunaer_new.pay_detail pay on repay.product_no = pay.product_no and pay.status = 1
where repay.fund_code !=1
'''

sql_refund='''
select product_no,-sum(refund_principle) repay_principle ,-sum(refund_fee_amount) repay_fee_amount ,date(refund_time) repay_time
from qunaer_new.refund_detail WHERE product_no in %s 
and fund_code != 1
GROUP BY 1
'''

# sql_refund = '''
# select product_no from qunaer_new.refund_detail where fund_code != 1
# '''


def qunaer_peifu(start_time,end_time):
	#year,month = 2017,9

	df_fund_plan=pd.read_sql(sql_fund_plan ,engine_qunaer)

	df_fund_plan.loc[df_fund_plan.deadline >= end_time,'principle']=0
	df_fund_plan.loc[df_fund_plan.deadline < start_time, 'principle'] = 0

	df_fund_plan.loc[df_fund_plan.deadline >= end_time, 'fee_amount'] = 0
	df_fund_plan.loc[df_fund_plan.deadline < start_time, 'fee_amount'] = 0

	df_del = pd.read_sql(sql_del,engine_qunaer)

	df_fund_plan = df_fund_plan.loc[~df_fund_plan.product_no.isin(df_del.product_no)]

	df_repay=pd.read_sql(sql_repay,engine_qunaer)
	df_repay = df_repay.loc[~df_repay.product_no.isin(df_del.product_no)]

	df_fund_plan['product_no'] = df_fund_plan['product_no'].astype(str)
	df_repay['product_no'] = df_repay['product_no'].astype(str)

	df_repay=pd.merge(df_repay,df_fund_plan[['product_no', 'current_stage_no', 'deadline']],how='left')
	df_repay.loc[df_repay.repay_time >=end_time,'repay_principle'] = 0
	df_repay.loc[df_repay.repay_time >= end_time, 'repay_fee_amount'] = 0
	df_repay.loc[df_repay.deadline < start_time,'repay_principle'] = 0
	df_repay.loc[df_repay.deadline < start_time, 'repay_fee_amount'] = 0
	df_repay.loc[df_repay.deadline >= end_time, 'repay_principle'] = 0
	df_repay.loc[df_repay.deadline >= end_time, 'repay_fee_amount'] = 0
	df_repay.loc[(df_repay.repay_time < start_time) & (df_repay.deadline < start_time),'repay_principle'] = 0
	df_repay.loc[(df_repay.repay_time < start_time) & (df_repay.deadline < start_time), 'repay_fee_amount'] = 0

	df_result = pd.merge(df_repay[['product_no', 'current_stage_no', 'repay_time', 'repay_principle','repay_fee_amount']],
						df_fund_plan[['fund_code','product_no', 'current_stage_no', 'deadline', 'principle','fee_amount']],
						on=['product_no', 'current_stage_no'], how='outer')

	df_result = df_result.fillna(0)
	df_result.loc[df_result[['product_no', 'current_stage_no']].duplicated(),'principle'] = 0
	df_result.loc[df_result[['product_no', 'current_stage_no']].duplicated(), 'fee_amount'] = 0
	df_result.deadline=pd.to_datetime(df_result.deadline).dt.date
	df_result=df_result.loc[df_result.deadline < end_time]

	df_result_gp=df_result[~df_result['product_no'].duplicated()]

	df_refund=pd.read_sql(sql_refund % str(tuple(df_result_gp['product_no'].astype(str).tolist())),engine_qunaer)

	df_refund = pd.merge(df_refund,df_fund_plan[['product_no','deadline','fund_code']],on='product_no',how='left')

	df_result = pd.concat([df_refund, df_result], axis=0,ignore_index=True)
	df_result_benjin = df_result.groupby(['deadline','fund_code'])[['principle','fee_amount']].sum().reset_index()

	df_result_pay = df_result[~(df_result['repay_time'] == 0)]
	df_result_pay.repay_time = pd.to_datetime(df_result_pay.repay_time).dt.date

	df_result_pay['tq'] = df_result_pay.loc[df_result_pay['repay_time'] < df_result_pay['deadline'],'repay_principle']
	df_result_pay['zc'] = df_result_pay.loc[df_result_pay['repay_time'] == df_result_pay['deadline'],'repay_principle']
	df_result_pay['yq'] = df_result_pay.loc[df_result_pay['repay_time'] > df_result_pay['deadline'],'repay_principle']

	df_result_sum = pd.merge(df_result_benjin,df_result_pay.groupby(['deadline','fund_code'])['tq','zc','yq'].sum().reset_index(),on=['deadline','fund_code'],how='left')

	df_result_sum.loc[df_result_sum.fund_code == 2,'fund_code'] = u'惠金所'
	df_result_sum.loc[df_result_sum.fund_code == 3, 'fund_code'] = u'笑脸'
	df_result_sum.rename(columns = {'deadline':u'自然日','fund_code':u'资金方','principle':u'应还本金','fee_amount':u'应还利息','tq':u'提前还款可用','zc':u'正常还款','yq':u'逾期还款'},inplace=True)
	df_result_sum.fillna(0,inplace=True)

	df_result_sum.to_excel(file_path+u'去哪儿每日赔付_%s.xlsx'%(start_time),index=None)

if __name__ == '__main__':

	print '____main__start'
	start_time = datetime.date(2017, 9, 1)
	end_time = datetime.date(2017, 10, 1)
	qunaer_peifu(start_time,end_time)
	print '____main__end'
