# -*- coding: utf-8 -*-
import sys
import os
import pandas as pd
import datetime
from sqlalchemy import create_engine

reload(sys)
sys.setdefaultencoding('utf8')
import numpy as np

engine_engine_financial = create_engine(
    'mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/all_back_0531?charset=utf8',
    echo=True)

path = './'
start_time_loanPaidAt = '2016-01-01 00:00:00'
end_time_loanPaidAt = '2017-01-01 00:00:00'

start_repay_time = '2015-01-01 00:00:00'
start_time_repay_huarong_settle = '2017-05-01 00:00:00'
end_repay_time = '2017-06-01 00:00:00'

start_time_deadline = '2017-01-01 00:00:00'

end_time_deadline = '2017-06-01 00:00:00'

sql_fund_corp = '''
select id fund_code,name fund_name from funding_corp
'''
df_fund = pd.read_sql(sql_fund_corp, con=engine_engine_financial)
df_fund.fund_code = df_fund.fund_code.astype(int)

sql_fund_ACD = '''
SELECT DATE(transfer_time) day_hk,
CASE fund_corp
 WHEN '曾思成' THEN 130
  WHEN '李然' THEN 80
  WHEN  '张初阳' THEN 50
  END as fund_code
,sum(transfer_amount) plan_all
FROM lkb_to_fund
WHERE  fund_corp in ('曾思成','李然','张初阳')
GROUP BY 1,2
'''
sql_plan = '''
select DATE(deadline) day_hk,t1.fund_code,SUM(principle+interest) plan_all
from user_repayment_plan t1 JOIN loan_manifest t2 ON  t1.loanid = t2.loanid WHERE
 t2.loan_paid_at >='%s' and t2.loan_paid_at<'%s'
AND t1.deadline >= '%s' AND t1.deadline<'%s' and t1.fund_code  in (270, 310, 320, 210)
GROUP BY 1,2
'''
sql_fund = '''
SELECT DATE(deadline) day_hk,t1.funding_code fund_code,SUM(principle+interest) plan_all
FROM `funding_repayment_record` t1 JOIN loan_manifest t2 ON t1.loan_id = t2.loan_id WHERE
t2.loan_paid_at >='%s' and t2.loan_paid_at<'%s' AND t1.is_active = 1
and t1.deadline >= '%s' AND  t1.deadline <'%s' and t1.funding_code not in (160,50,80,130,270, 310, 320, 210)
GROUP BY 1,2
'''

sql_fund_huarong_5 = '''
SELECT DATE(t1.repaid_at) day_hk,t1.funding_code fund_code, SUM(t1.`principle`+t1.`interest`) plan_all
FROM `funding_repayment_record` t1 JOIN loan_manifest t2 ON t1.loan_id=t2.loan_id JOIN loan_class t3 ON t2.loanid=t3.loanid  WHERE
  t1.is_active = 1  AND t1.funding_code=150
AND t2.is_active in (1,-2) AND  t2.loan_paid_at >='%s' and t2.loan_paid_at<'%s'
and t1.repaid_at >= '%s' AND t1.repaid_at < '%s'
GROUP BY DATE(t1.repaid_at)
'''

sql_hk_online_zc = '''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) zc_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t1.repay_channel < 13 AND t4.is_active in (1,-2) and t3.fund_code not in (160,150)  AND DATE(t3.xyqb_repaid_at) = DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''
sql_hk_online_yq = '''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) yq_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t1.repay_channel < 13 AND t4.is_active in (1,-2) and t3.fund_code not in (160,150) and DATE(t3.xyqb_repaid_at) > DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''
sql_hk_online_tq = '''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t1.repay_channel < 13 AND t4.is_active in (1,-2) and t3.fund_code not in (290,330,160,200,150) and DATE(t3.xyqb_repaid_at) < DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''

sql_hk_ali_zc = '''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) zc_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
join offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t3.fund_code not in (160,150) AND t4.is_active in (1,-2) and DATE(t2.transfer_time) = DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''

sql_hk_ali_yq = '''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) yq_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
join offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t3.fund_code not in (160,150) AND t4.is_active in (1,-2) and DATE(t2.transfer_time) > DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''

sql_hk_ali_tq = '''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
join offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t3.fund_code not in (160,200,150,290,330) AND t4.is_active in (1,-2) and DATE(t2.transfer_time) < DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''

sql_hk_bank_zc = '''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) zc_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
join offline_bank_repay_record t2 on t1.record_id = t2.id and t1.repay_channel in (14,15,16)
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t3.fund_code not in (160,150) AND t4.is_active in (1,-2) and DATE(t2.transfer_time) = DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''

sql_hk_bank_yq = '''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) yq_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
join offline_bank_repay_record t2 on t1.record_id = t2.id and t1.repay_channel in (14,15,16)
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t3.fund_code not in (160,150) AND t4.is_active in (1,-2) and DATE(t2.transfer_time) > DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''

sql_hk_bank_tq = '''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
join offline_bank_repay_record t2 on t1.record_id = t2.id and t1.repay_channel in (14,15,16)
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t3.fund_code not in (160,200,150,290,330) AND t4.is_active in (1,-2) and DATE(t2.transfer_time) < DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''

sql_ky_online_tq = '''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t1.repay_channel < 13 and t3.fund_code in( 200,290,330) AND t4.is_active in (1,-2) and DATE(t3.xyqb_repaid_at) < DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''

sql_ky_ali_tq = '''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid=t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t3.fund_code in( 200,290,330) AND t4.is_active in (1,-2) and DATE(t2.transfer_time) < DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
 AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''

sql_query_advance_settle_plan_id = """
SELECT
	t3.id plan_id
FROM
	`xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN loan_manifest t5 ON t3.loanid = t5.loanid
JOIN loan_class t6 ON t5.loanid = t6.loanid
WHERE
 t3.fund_code = 150 AND t5.is_active in (1,-2)
AND t6.class = '%s'
 AND  t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s'
AND t3.xyqb_repaid_at < '%s'
AND DATE(t3.xyqb_repaid_at) < DATE(t3.deadline) AND t3.deadline>='%s'
AND t3.loanid IN (
	SELECT
		t3.loanid
	FROM
		`xjd_repay_plan_repay_record_ref` t1
	JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
	JOIN loan_manifest t5 ON t3.loanid = t5.loanid
	AND t3.term_no = t5.contract_term
	WHERE
		t3.fund_code = 150
	AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
	AND t3.xyqb_repaid_at < '%s'
	AND DATE(t3.xyqb_repaid_at) < DATE(t3.deadline)
);
"""

sql_query_advance_settle = """
SELECT
	t3.id plan_id,
	t3.loanid,
	DATE(t3.xyqb_repaid_at) repaid_at,
	DATE(t4.deadline) deadline,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(
	  t1.`principle` - t1.`mitigate_principle` + t1.`interest` - t1.`mitigate_interest`
	) tq_real_all
FROM
	`xjd_repay_plan_repay_record_ref` t1
JOIN `repay_record_online` t2 ON t1.repay_channel < 13
AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  funding_repayment_record t4 ON t4.loanid = t3.loanid
AND t4.term_no = t3.term_no
JOIN  loan_manifest t5 ON t3.loanid = t5.loanid
JOIN loan_class t6 ON t5.loanid = t6.loanid
WHERE
    t3.fund_code = 150  AND t5.is_active in (1,-2) AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s' AND  t3.id IN %s
"""

sql_hr_online_zc = '''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) zc_real_all
FROM xjd_repay_plan_repay_record_ref t1
JOIN user_repayment_plan t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code = 150
JOIN funding_repayment_record t4 ON t4.loanid = t3.loanid AND t4.term_no = t3.term_no
JOIN  loan_manifest t5 ON t3.loanid=t5.loanid
JOIN  loan_class t6 ON t5.loanid = t6.loanid
WHERE  DATE(t3.xyqb_repaid_at) = DATE(t4.deadline) AND t5.is_active in (1,-2)
AND t6.class = '%s'
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''
sql_hr_online_yq = '''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) yq_real_all
FROM xjd_repay_plan_repay_record_ref t1
JOIN user_repayment_plan t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code = 150
JOIN funding_repayment_record t4 ON t4.loanid = t3.loanid AND t4.term_no = t3.term_no
JOIN  loan_manifest t5 ON t3.loanid=t5.loanid
JOIN  loan_class t6 ON t5.loanid = t6.loanid
WHERE DATE(t3.xyqb_repaid_at) > DATE(t4.deadline) AND t5.is_active in (1,-2)
AND t6.class = '%s'
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''

sql_hr_online_tq = '''
SELECT DATE(t4.deadline) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) tq_real_all
FROM xjd_repay_plan_repay_record_ref t1
JOIN user_repayment_plan t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code = 150
JOIN funding_repayment_record t4 ON t4.loanid = t3.loanid AND t4.term_no = t3.term_no
JOIN  loan_manifest t5 ON t3.loanid=t5.loanid
JOIN  loan_class t6 ON t5.loanid = t6.loanid
WHERE DATE(t3.xyqb_repaid_at) < DATE(t4.deadline) AND t5.is_active in (1,-2)
AND t6.class = '%s'
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''

sql_hr_advance_hr = """
(SELECT
   t3.id plan_id,
   t3.loanid,
	DATE(t3.xyqb_repaid_at) repaid_at,
	DATE(t4.deadline) deadline,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(t1.`principle` - t1.`mitigate_principle`+t1.`interest` - t1.`mitigate_interest`) tq_real_all
FROM
	`xjd_repay_plan_repay_record_ref` t1
JOIN `repay_record_online` t2 ON t1.repay_channel < 13
AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN funding_repayment_record t4 ON t4.loanid = t3.loanid
AND t4.term_no = t3.term_no
JOIN loan_manifest t5 ON t3.loanid = t5.loanid
JOIN loan_class t6 ON t5.loanid = t6.loanid
WHERE
     t3.fund_code = 150
     AND t6.class = '%s'
     AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
	 AND t4.deadline>='%s'
	 AND t4.deadline<'%s'
AND t3.xyqb_repaid_at < '%s' AND t3.xyqb_repaid_at<t4.deadline)
UNION ALL
(SELECT
    t3.id plan_id,
    t3.loanid,
	DATE(t2.transfer_time) repaid_at,
	DATE(t4.deadline) deadline,
	t3.term_no current_term,
	t5.contract_term,
	t3.fund_code,
	(t1.`principle` - t1.`mitigate_principle`+t1.`interest` - t1.`mitigate_interest`) tq_real_all
FROM
	`xjd_repay_plan_repay_record_ref` t1
JOIN `offline_alipay_record` t2 ON t1.repay_channel = 13
AND t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN funding_repayment_record t4 ON t4.loanid = t3.loanid
AND t4.term_no = t3.term_no
JOIN loan_manifest t5 ON t3.loanid = t5.loanid
JOIN loan_class t6 ON t5.loanid = t6.loanid
WHERE
     t3.fund_code = 150
     AND t6.class = '%s'
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
	 AND t4.deadline>='%s'
	 AND t4.deadline<'%s'
AND t2.transfer_time < '%s' AND t2.transfer_time<t4.deadline
)
"""

sql_hr_ali_zc = '''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) zc_real_all
FROM xjd_repay_plan_repay_record_ref t1
join offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13
JOIN user_repayment_plan t3 ON t1.plan_id = t3.id  and t3.fund_code = 150
JOIN funding_repayment_record t4 ON t4.loanid = t3.loanid AND t4.term_no = t3.term_no
JOIN  loan_manifest t5 ON t3.loanid=t5.loanid
JOIN  loan_class t6 ON t5.loanid = t6.loanid
WHERE DATE(t2.transfer_time) = DATE(t4.deadline) AND t5.is_active in (1,-2)
AND t6.class = '%s'
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''

sql_hr_ali_yq = '''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) yq_real_all
FROM xjd_repay_plan_repay_record_ref t1
join offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13
JOIN user_repayment_plan t3 ON t1.plan_id = t3.id  and t3.fund_code = 150
JOIN funding_repayment_record t4 ON t4.loanid = t3.loanid AND t4.term_no = t3.term_no
JOIN  loan_manifest t5 ON t3.loanid=t5.loanid
JOIN  loan_class t6 ON t5.loanid = t6.loanid
WHERE DATE(t2.transfer_time) > DATE(t4.deadline) AND t5.is_active in (1,-2)
AND t6.class = '%s'
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''
sql_hr_ali_tq = '''
SELECT DATE(t4.deadline) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) tq_real_all
FROM xjd_repay_plan_repay_record_ref t1
join offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13
JOIN user_repayment_plan t3 ON t1.plan_id = t3.id  and t3.fund_code = 150
JOIN funding_repayment_record t4 ON t4.loanid = t3.loanid AND t4.term_no = t3.term_no
JOIN  loan_manifest t5 ON t3.loanid=t5.loanid
JOIN  loan_class t6 ON t5.loanid = t6.loanid
WHERE DATE(t2.transfer_time) < DATE(t4.deadline) AND t5.is_active in (1,-2)
AND t6.class = '%s'
AND t5.loan_paid_at>='%s' AND t5.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''

sql_ky_online_tq_plan = '''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) ky_tq_plan_all
FROM `xjd_repay_plan_repay_record_ref` t1
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid = t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t1.repay_channel < 13 and t3.fund_code in(200,290,330) and DATE(t3.xyqb_repaid_at) < DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t3.xyqb_repaid_at >= '%s' AND t3.xyqb_repaid_at < '%s'
GROUP by 1,2
'''
sql_ky_ali_tq_plan = '''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) ky_tq_plan_all
FROM `xjd_repay_plan_repay_record_ref` t1
join offline_alipay_record t2 on t1.record_id = t2.id
JOIN `user_repayment_plan` t3 ON t1.plan_id = t3.id
JOIN  loan_manifest t4 ON t3.loanid = t4.loanid
JOIN  loan_class t5 ON t4.loanid = t5.loanid
WHERE t3.fund_code in(200,290,330) and t1.repay_channel = 13 and DATE(t2.transfer_time) < DATE(t3.deadline)
AND t5.class = '%s'
AND t4.loan_paid_at>='%s' AND t4.loan_paid_at<'%s'
AND t2.transfer_time >= '%s' AND t2.transfer_time < '%s'
GROUP by 1,2
'''


def funding_(loan_class):
    df_fund_ACD = pd.read_sql(sql_fund_ACD, engine_engine_financial)
    df_plan = pd.read_sql(
        sql_plan % (start_time_loanPaidAt, end_time_loanPaidAt, start_time_deadline, end_time_deadline),
        engine_engine_financial)
    df_fund_plan = pd.read_sql(
        sql_fund % (start_time_loanPaidAt, end_time_loanPaidAt, start_time_deadline, end_time_deadline),
        engine_engine_financial)

    df_fund_plan['day_hk'] = pd.to_datetime(df_fund_plan['day_hk']).apply(lambda x: x.date())
    df_fund_plan = df_fund_plan.ix[
        ~ ((df_fund_plan['fund_code'] == 150) & (df_fund_plan.day_hk >= datetime.date(2017, 5, 1)))]
    df_fund_plan_huarong_5 = pd.read_sql(
        sql_fund_huarong_5 % (
            start_time_loanPaidAt, end_time_loanPaidAt, start_time_repay_huarong_settle, end_time_deadline),
        engine_engine_financial)

    df_fund_all = pd.concat([df_fund_ACD, df_plan, df_fund_plan, df_fund_plan_huarong_5], ignore_index=True, axis=0)
    df_fund_all = df_fund_all.groupby(['day_hk', 'fund_code'])['plan_all'].sum().reset_index()

    df_online_zc = pd.read_sql(
        sql_hk_online_zc % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_bank_zc = pd.read_sql(
        sql_hk_bank_zc % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_ali_zc = pd.read_sql(
        sql_hk_ali_zc % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_hr_online_zc = pd.read_sql(
        sql_hr_online_zc % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_hr_ali_zc = pd.read_sql(
        sql_hr_ali_zc % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_zc = pd.concat([df_online_zc, df_bank_zc, df_ali_zc, df_hr_online_zc, df_hr_ali_zc], ignore_index=True, axis=0)
    df_zc = df_zc.groupby(['day_hk', 'fund_code'])['zc_real_all'].sum().reset_index()

    df_online_yq = pd.read_sql(
        sql_hk_online_yq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_bank_yq = pd.read_sql(
        sql_hk_bank_yq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_ali_yq = pd.read_sql(
        sql_hk_ali_yq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_hr_online_yq = pd.read_sql(
        sql_hr_online_yq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_hr_ali_yq = pd.read_sql(
        sql_hr_ali_yq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)

    df_yq = pd.concat([df_online_yq, df_bank_yq, df_ali_yq, df_hr_online_yq, df_hr_ali_yq], ignore_index=True, axis=0)
    df_yq = df_yq.groupby(['day_hk', 'fund_code'])['yq_real_all'].sum().reset_index()

    df_online_tq = pd.read_sql(
        sql_hk_online_tq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_bank_tq = pd.read_sql(
        sql_hk_bank_tq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_ali_tq = pd.read_sql(
        sql_hk_ali_tq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)

    df_ky_online_tq = pd.read_sql(
        sql_ky_online_tq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_ky_ali_tq = pd.read_sql(
        sql_ky_ali_tq % (loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)

    df_hr_tq = pd.read_sql(
        sql_hr_advance_hr % (loan_class,
                             start_time_loanPaidAt, end_time_loanPaidAt, start_time_deadline, end_time_deadline,
                             end_repay_time,
                             loan_class,
                             start_time_loanPaidAt, end_time_loanPaidAt, start_time_deadline, end_time_deadline,
                             end_repay_time),
        engine_engine_financial)

    df_tq_huarong_5 = df_hr_tq.ix[df_hr_tq.repaid_at >= datetime.date(2017, 5, 1)]
    df_tq_huarong = df_hr_tq.ix[df_hr_tq.repaid_at < datetime.date(2017, 5, 1)]
    df_advance_plan_id = pd.read_sql(
        sql_query_advance_settle_plan_id % (
        loan_class, start_time_loanPaidAt, end_time_loanPaidAt, start_time_repay_huarong_settle,
        end_repay_time,
        start_time_deadline, start_time_loanPaidAt, end_time_loanPaidAt,
        end_repay_time),
        con=engine_engine_financial)
    advance_planid_list = df_advance_plan_id['plan_id'].tolist()
    advance_planid_set = set(advance_planid_list)

    advance_planid_list = map(int, advance_planid_list)
    df_tq_settle = pd.read_sql(sql_query_advance_settle % (start_time_loanPaidAt, end_time_loanPaidAt,
                                                           str(tuple(advance_planid_list))), con=engine_engine_financial)
    df_tq_settle_max_deadline = df_tq_settle.groupby(by=['loanid'])['repaid_at'].agg(['max']).reset_index().rename(
        columns={'max': 'max_repaid_at'})
    df_tq_settle_max_deadline.reset_index(inplace=True)
    df_tq_settle_max_deadline['max_repaid_at'] = pd.to_datetime(df_tq_settle_max_deadline['max_repaid_at']).apply(
        lambda x: x.date())

    df_tq_settle = pd.merge(df_tq_settle, df_tq_settle_max_deadline, how='left', on=['loanid'])
    df_tq_settle_leak = df_tq_settle.ix[df_tq_settle.max_repaid_at < datetime.date(2017, 5, 1)]
    df_tq_settle_leak.drop(['max_repaid_at'], inplace=True, axis=1)

    df_tq_settle = df_tq_settle.ix[df_tq_settle.max_repaid_at >= datetime.date(2017, 5, 1)]
    df_tq_settle.drop(['repaid_at'], inplace=True, axis=1)
    df_tq_settle.rename(columns={'deadline': 'repaid_at'}, inplace=True)
    df_tq_settle.rename(columns={'max_repaid_at': 'deadline'}, inplace=True)

    df_tq_no_settle = df_tq_huarong_5[~df_tq_huarong_5.plan_id.isin(advance_planid_set)]
    df_tq_huarong = pd.concat([df_tq_no_settle, df_tq_settle, df_tq_settle_leak, df_tq_huarong], ignore_index=True)
    df_tq_huarong = df_tq_huarong.groupby(by=['deadline'])['tq_real_all'].sum()
    df_tq_huarong = df_tq_huarong.to_frame()
    df_tq_huarong.reset_index(inplace=True)
    df_tq_huarong['deadline'] = pd.to_datetime(df_tq_huarong['deadline']).apply(lambda x: x.date())
    df_tq_huarong.rename(columns={'deadline': 'day_hk'}, inplace=True)
    df_tq_huarong['fund_code'] = 150
    df_tq_huarong = df_tq_huarong[['day_hk', 'fund_code', 'tq_real_all']]

    df_tq = pd.concat(
        [df_online_tq, df_bank_tq, df_ali_tq, df_ky_online_tq, df_ky_ali_tq, df_tq_huarong],
        ignore_index=True, axis=0)

    df_tq = df_tq.groupby(['day_hk', 'fund_code'])['tq_real_all'].sum().reset_index()

    df_ky_tq_online_plan = pd.read_sql(
        sql_ky_online_tq_plan % (loan_class,start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_ky_tq_ali_plan = pd.read_sql(
        sql_ky_ali_tq_plan % (loan_class,start_time_loanPaidAt, end_time_loanPaidAt, start_repay_time, end_repay_time),
        engine_engine_financial)
    df_ky_tq_plan = pd.concat([df_ky_tq_online_plan, df_ky_tq_ali_plan], ignore_index=True, axis=0)
    df_ky_tq_plan = df_ky_tq_plan.groupby(['day_hk', 'fund_code'])['ky_tq_plan_all'].sum().reset_index()

    df_fund_all.day_hk = pd.to_datetime(df_fund_all.day_hk).dt.date
    df_fund_all.fund_code = df_fund_all.fund_code.astype(int)

    df_zc.day_hk = pd.to_datetime(df_zc.day_hk).dt.date
    df_zc.fund_code = df_zc.fund_code.astype(int)

    df_yq.day_hk = pd.to_datetime(df_yq.day_hk).dt.date
    df_yq.fund_code = df_yq.fund_code.astype(int)

    df_tq.day_hk = pd.to_datetime(df_tq.day_hk).dt.date
    df_tq.fund_code = df_tq.fund_code.astype(int)

    df_ky_tq_plan.day_hk = pd.to_datetime(df_ky_tq_plan.day_hk).dt.date
    df_ky_tq_plan.fund_code = df_ky_tq_plan.fund_code.astype(int)

    df = pd.merge(df_fund_all, df_ky_tq_plan, on=['day_hk', 'fund_code'], how='outer')
    df = pd.merge(df, df_zc, on=['day_hk', 'fund_code'], how='outer')
    df = pd.merge(df, df_yq, on=['day_hk', 'fund_code'], how='outer')
    df = pd.merge(df, df_tq, on=['day_hk', 'fund_code'], how='outer')
    df.fillna(0, inplace=True)
    df['real_all'] = np.round(df['tq_real_all'] + df['zc_real_all'] + df['yq_real_all'], 2)
    df.drop(['fund_code'], inplace=True, axis=1)
    df['loan_class'] = loan_class
    df.rename(columns={'plan_all': '资金方应还本息', 'real_all': '客户实还总额',
                       'tq_real_all': '提前还款', 'zc_real_all': '正常还款', 'yq_real_all': '逾期还款',
                       'ky_tq_plan_all': '科易提前应还', 'loan_class': '客户等级'}, inplace=True)

    df.fund_code = df.fund_code.astype(int)
    df = pd.merge(df, df_fund, on='fund_code', how='left')
    df.to_excel(path+'loan_paid_class_'+loan_class+'.xlsx', index=None, columns=df.columns, encoding='utf8')


if __name__ == '__main__':

    loan_class_list = ['A', 'B', 'C']
    for loan_class in loan_class_list:
        funding_(loan_class)

    print '-----------------all fund done---------------------'
    excel_out = pd.ExcelWriter(path + 'all.xlsx')
    df_out = pd.DataFrame()
    for file in os.listdir(path):
        tmp_file = file.replace('.xlsx', '')
        if tmp_file == 'all':
            continue
        else:
            df_out = df_out.append(pd.read_excel(path + file))
    df_out.to_excel(excel_out, sheet_name='sheet1', columns=df_out.columns, index=None, encoding='utf8')
    excel_out.save()
