# coding: utf-8
# Author: Perry_Zhu
"""
说明：由于白条现金支付不存在在贷所以在做白条在贷的时候可以忽略白条现金支付
本代码用于出截止2017-09-30和截止2017-10-31的在贷
"""
import datetime
import sys

import pandas as pd
import pyexcelerate as pe
from sqlalchemy import create_engine

reload(sys)
sys.setdefaultencoding('utf8')
engine_new_transaction = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/baitiao_audit?charset=utf8', echo=True)
end_point = '2017-11-01'
watch_point = datetime.date(2017, 10, 31)
out_file_path = u'E:/数据汇总/白条/在贷/'
query_loan = """
    SELECT 
        tt.order_no,tt.term_no,
        min(tt.deadline)deadline,SUM(tt.principle)principle
    FROM(
    SELECT
        plan.order_no,
        plan.term_no,
        date(plan.deadline)deadline,
        sum(plan.principle)principle
    FROM baitiao_order bo
    JOIN new_transaction.user_bt_repayment_plan plan ON bo.ref_id=plan.ref_id
    WHERE
        bo.loan_paid_at >= '2015-01-01'
    AND bo.loan_paid_at < '%s'
    AND bo.is_active =1
    and bo.baitiao_type=0
    AND bo.funding_corp_id = 1
    GROUP BY 1,2
    
    UNION ALL
        SELECT
            plan.order_no,
            plan.term_no,
            date(plan.deadline)deadline,
            sum(plan.principle)principle
        FROM
            baitiao_order bo
        JOIN new_transaction.user_bt_repayment_plan plan ON bo.ref_id=plan.ref_id and bo.baitiao_type=0
        WHERE
            bo.train_cancel_at >= '2015-01-01'
        AND bo.train_cancel_at < '%s'
        AND bo.is_active =- 2
        AND bo.funding_corp_id = 1
        GROUP BY 1,2
    )tt
    GROUP BY 1,2

"""
loan_info = """
    SELECT tt.order_no,SUM(tt.real_loan_amount) 订单金额,max(tt.contract_term)合同期数,
          tt.merchant_name 商户,min(tt.loan_paid_at)放款时间 
    FROM(
    SELECT
        o.order_no,
        SUM(o.real_loan_amount) real_loan_amount,
        o.contract_term,
        m.merchant_name,
        date(o.loan_paid_at) loan_paid_at
    FROM
        baitiao_order o
    JOIN merchant m ON o.merchantId = m.merchant_id AND o.is_active=1 AND o.funding_corp_id = 1 and o.baitiao_type=0
    GROUP BY 1
    
    UNION ALL
    
    SELECT
        o.order_no,
        SUM(o.train_cancel_at) real_loan_amount,
        o.contract_term,
        m.merchant_name,
        date(o.train_cancel_at) loan_paid_at
    FROM
        baitiao_order o
    JOIN merchant m ON o.merchantId = m.merchant_id AND o.is_active=1 AND o.funding_corp_id = -2 and o.baitiao_type=0
    GROUP BY 1
    )tt
    GROUP BY 1

"""

repay_online = """
    SELECT
        t2.order_no,
        t2.term_no,
        SUM(ifnull(t1.principle, 0) - IFNULL(t1.mitigate_principle, 0)) paid_principle
    FROM
        new_transaction.baitiao_repay_plan_repay_record_ref t1
    JOIN new_transaction.repay_record_online t3 ON t1.repay_channel in(1,2,3,4,5,6,7,8,9,10,11,12,22,23,24) AND t3.id = t1.record_id 
        AND t3.bill_time >= '2015-01-01' AND t3.bill_time < '%s'
        and t1.id not in(14164355,14164357,14164359,13818155,13818157,13818159,13533131,13996965,13996971,13996967,
                  13996957,13996959,13996961,13996963,13996973,13996975,13996977,16774675,14471253)
    JOIN new_transaction.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
    JOIN baitiao_order t5 ON t2.ref_id = t5.ref_id AND t5.funding_corp_id =1
    GROUP BY 1,2
"""
repay_ali = """
    SELECT
        t2.order_no,
        t2.term_no,
        SUM(ifnull(t1.principle,0)-ifnull(t1.mitigate_principle,0)) paid_principle
    FROM
        new_transaction.baitiao_repay_plan_repay_record_ref t1
    JOIN new_transaction.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
    JOIN new_transaction.offline_alipay_record t3 ON t1.repay_channel = 13 AND t3.id = t1.record_id  AND  t3.is_ref=1 
        AND t3.transfer_time>='2015-01-01' AND t3.transfer_time<'%s'
    JOIN baitiao_order t5 ON t2.ref_id = t5.ref_id  AND t5.funding_corp_id = 1
    GROUP BY 1,2
"""
repay_bank = """
    SELECT
        t2.order_no,
        t2.term_no,
        SUM(ifnull(t1.principle,0)-ifnull(t1.mitigate_principle,0)) paid_principle
    FROM
            new_transaction.baitiao_repay_plan_repay_record_ref t1
    JOIN new_transaction.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
    JOIN new_transaction.offline_bank_repay_record t3 ON t1.repay_channel IN (14, 15, 16) AND t3.id = t1.record_id 
        AND t3.transfer_time>='2015-01-01' AND t3.transfer_time<'%s'
    JOIN baitiao_order t5 ON t2.ref_id = t5.ref_id 
    GROUP BY 1,2
"""


df_info = pd.read_sql(loan_info, engine_new_transaction)
df_loan_all = pd.read_sql(query_loan % (end_point, end_point), engine_new_transaction)
df_online = pd.read_sql(repay_online % end_point, engine_new_transaction)
df_ali = pd.read_sql(repay_ali % end_point, engine_new_transaction)
df_bank = pd.read_sql(repay_bank % end_point, engine_new_transaction)
df_repay = pd.concat([df_online, df_ali, df_bank], axis=0, ignore_index=True)
df_repay.dropna(axis=0, inplace=True)
df_loan_all.order_no = df_loan_all.order_no.astype(str)
df_loan_all.term_no = df_loan_all.term_no.astype(int)
df_info.order_no = df_info.order_no.astype(str)
df_repay.order_no = df_repay.order_no.astype(str)
df_repay.term_no = df_repay.term_no.astype(int)
#去除无效放款
df_loan = df_loan_all.loc[df_loan_all['principle'] > 0]
df_repay = df_repay.groupby(['order_no', 'term_no'])['paid_principle'].agg(['sum']).reset_index().rename(columns={'sum': 'paid_principle'})
df_out = pd.merge(df_loan, df_repay, on=['order_no', 'term_no'], how='left')
df_out['deadline'] = pd.to_datetime(df_out.deadline)
df_out['flag'] = (watch_point-df_out['deadline']).dt.days
df_out.fillna(0, inplace=True)
df_out['zaidai'] = df_out['principle'] - df_out['paid_principle']
#用于将在贷为负值的置0，建议使用   df_out = df_out.loc[df_out['zaidai']>0]
df_out.loc[df_out['order_no'].isin(
    ['trainmall1483695024282', 'trainmall1484301600672', 'trainmall1486362269554', 'trainmall1487920296689',
     'trainmall1491536200793', 'trainmall1483695024282',
     'trainmall1484301600672', 'trainmall1486362269554', 'grabtrainmall1484650405321', 'trainmall1495785791995',
     'trainmall1499935282194', 'trainmall16008368458050561', 'trainmall16008408858634241',
     'trainmall16112348780571649', 'trainmall16112552463312897']), 'zaidai'] = 0
df_out = df_out.loc[df_out['zaidai']>0]
df_out.loc[(df_out['flag']<=0),'0'] = df_out['zaidai']
df_out.loc[(df_out['flag']>=1) &(df_out['flag']<=30),'01-30'] = df_out['zaidai']
df_out.loc[(df_out['flag']>=31) &(df_out['flag']<=60),'31-60'] = df_out['zaidai']
df_out.loc[(df_out['flag']>=61) &(df_out['flag']<=90),'61-90'] = df_out['zaidai']
df_out.loc[(df_out['flag']>=91) &(df_out['flag']<=120),'91-120'] = df_out['zaidai']
df_out.loc[(df_out['flag']>=121) &(df_out['flag']<=150),'121-150'] = df_out['zaidai']
df_out.loc[(df_out['flag']>=151) &(df_out['flag']<=180),'151-180'] = df_out['zaidai']
df_out.loc[(df_out['flag']>=181) &(df_out['flag']<=360),'181-360'] = df_out['zaidai']
df_out.loc[(df_out['flag']>=361),'361+'] = df_out['zaidai']
#在贷按order_no展开明细
df = df_out.groupby(['order_no'])['0','01-30','31-60','61-90','91-120','121-150','151-180','181-360','361+'].sum().reset_index()
df.fillna(0,inplace=True)
df_loan.order_no = df_loan.order_no.astype(str)
df = pd.merge(df, df_info, on='order_no', how='left')
df.rename(columns={'order_no': u'订单号'}, inplace=True)
df = df[[u'商户', u'订单号', u'订单金额', u'合同期数', u'放款时间','0','01-30','31-60','61-90','91-120','121-150','151-180','181-360','361+']]
data_list = df.values.tolist()
data_list.insert(0, df.columns.tolist())
wb = pe.Workbook()
wb.new_sheet(u'明细', data=data_list)
wb.save(out_file_path + u'非去哪儿白条2017-10-31在贷明细.xlsx')
#按月汇总在贷
df = df_out.groupby(['order_no','deadline'])['0','01-30','31-60','61-90','91-120','121-150','151-180','181-360','361+'].sum().reset_index()
df.fillna(0,inplace=True)
df_loan.order_no = df_loan.order_no.astype(str)
df = pd.merge(df, df_info, on='order_no', how='left',copy=False)
df.rename(columns={'order_no': u'订单号','deadline':u'应还时间'}, inplace=True)
df[u'放款年'] = pd.to_datetime(df[u'放款时间']).dt.year
df[u'放款月'] = pd.to_datetime(df[u'放款时间']).dt.month
df[u'应还年'] = df[u'应还时间'].dt.year
df[u'应还月'] = df[u'应还时间'].dt.month
df_result = df.groupby([u'放款年',u'放款月',u'合同期数',u'应还年',u'应还月'])['0','01-30','31-60','61-90','91-120','121-150','151-180','181-360','361+'].sum().reset_index()
df_result.to_excel(out_file_path + u'白条在贷汇总_%s.xlsx' % end_point, index=None)

