# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
from itertools import product

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

#
# 表名称：
#	白条-非去哪儿-放款表（1-6月份）
# 表字段
#	资金方	产品编号	放款期数	当前期数	白条商家	实还金额	本金	利息	服务费	罚息	其他收益	收款账户	渠道流水号
# 数据库：
#	baitiao_repay_plan_repay_record_ref，user_bt_repayment_plan，baitiao_order，merchant，repay_channel
# 注意事项：
#	baitiao_order.is_active = 1
#其他：
#	数据分为三部分：支付宝还款（offline_alipay_record）、银行还款（offline_bank_repay_record）、线上还款（repay_record_online）
#	还款渠道的划分根据baitiao_repay_plan_repay_record_ref中repay_channel：
# 	13（支付宝线下）[14,15,16]（银行还款）小于13（线上还款）
#	（本、利、服、罚）需要：t1.principle-t1.mitigate_principle 本金
#

file_path = u'E:/审计出表/非去哪儿白条-客户实还表（1月份-6月份）/'
# 注意修改数据源

engine_new_transaction = create_engine(
	'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/?charset=utf8',
	echo=True)

read_merchant_sql = '''SELECT merchant_id,merchant_name FROM baitiao_audit.merchant'''
df_merchant = pd.read_sql(read_merchant_sql, con=engine_new_transaction)
df_merchant['merchant_id'] = df_merchant['merchant_id'].astype(int)
read_repay_sql = '''
SELECT id,`approach_name` FROM new_transaction.`repay_channel`
'''
df_approach = pd.read_sql(read_repay_sql, engine_new_transaction)
df_approach['id'] = df_approach['id'].astype(int)

read_fund_sql = '''
SELECT id,fund_name FROM baitiao_audit.`fund_corp`
'''
df_fund = pd.read_sql(read_fund_sql, engine_new_transaction)
df_fund['id'] = df_fund['id'].astype(int)


def hk_hz(year, month):
	# 支付宝还款
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)

	sql_alipay = """
	SELECT t5.funding_corp_id,t5.order_no 产品编号,t6.merchant_name,t5.contract_term 放款期数,t2.term_no 当前期数,
	t1.ref_amount 总额, t1.principle-t1.mitigate_principle 本金, t1.interest-t1.mitigate_interest 利息, t1.service_fee-t1.mitigate_service_fee 服务费,
	t1.red_package_fee 红包减免,
	t1.punish-t1.mitigate_collection_relief 逾期罚款收益,
	t1.remain_income 其他收益,
	t7.approach_name,
	t3.business_flow 流水号
	FROM new_transaction.baitiao_repay_plan_repay_record_ref t1
	JOIN new_transaction.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
	JOIN new_transaction.offline_alipay_record t3 ON t1.repay_channel =13 AND t3.id = t1.record_id 
	JOIN baitiao_audit.baitiao_order t5 ON t2.ref_id=t5.ref_id
	JOIN baitiao_audit.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
	JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
	where t3.transfer_time >='%s' and t3.transfer_time<'%s'
	""" % (start_time, end_time)
	df_alipay = pd.read_sql(sql=sql_alipay, con=engine_new_transaction)

	# 银行还款
	sql_bank = """
	SELECT t5.funding_corp_id,t5.order_no 产品编号,t6.merchant_name,t5.contract_term 放款期数, t2.term_no 当前期数,
	t1.ref_amount 总额, t1.principle-t1.mitigate_principle 本金, t1.interest-t1.mitigate_interest 利息, t1.service_fee-t1.mitigate_service_fee 服务费,
	t1.punish-t1.mitigate_collection_relief 逾期罚款收益, 
	t1.remain_income 其他收益,
	t7.approach_name,
	t3.serial_number 流水号
	FROM new_transaction.baitiao_repay_plan_repay_record_ref t1
	JOIN new_transaction.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
	JOIN new_transaction.offline_bank_repay_record t3 ON t1.repay_channel in (14,15,16) AND t3.id = t1.record_id
	JOIN baitiao_audit.baitiao_order t5 ON t2.ref_id=t5.ref_id
	JOIN baitiao_audit.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
	JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
	where t3.transfer_time>= '%s' and t3.transfer_time<'%s'
	""" % (start_time, end_time)
	df_bank = pd.read_sql(sql=sql_bank, con=engine_new_transaction)

	# 线上还款
	sql_online = """
	SELECT t5.funding_corp_id,t5.order_no 产品编号,t6.merchant_name,t5.contract_term 放款期数,t2.term_no 当前期数,
	t1.ref_amount 总额, t1.principle-t1.mitigate_principle 本金, t1.interest-t1.mitigate_interest 利息, t1.service_fee-t1.mitigate_service_fee 服务费,
	t1.punish-t1.mitigate_collection_relief 逾期罚款收益, 
	t1.remain_income 其他收益,
	t7.approach_name,
	t3.order_id 流水号
	FROM new_transaction.baitiao_repay_plan_repay_record_ref t1
	JOIN new_transaction.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
	JOIN new_transaction.repay_record_online t3 ON t1.repay_channel < 13 AND t3.id = t1.record_id
	JOIN baitiao_audit.baitiao_order t5 ON t2.ref_id=t5.ref_id
	JOIN baitiao_audit.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
	JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
	where t3.bill_time>='%s' and t3.bill_time<'%s'
	""" % (start_time, end_time)
	df_online = pd.read_sql(sql=sql_online, con=engine_new_transaction)

	sql_cash = '''
	SELECT
		'内保' AS 资金方,
		t3.order_no 产品编号,
		t5.merchant_name,
		t4.`contract_term` 放款期数,
		'' 当前期数,
		t1.ref_amount 总额,
		t1.ref_amount 本金,
		0 AS '利息',
		0 服务费,
		0 逾期罚款收益,
		0 其他收益,
		t7.approach_name,
		t2.order_id 流水号
	FROM
		new_transaction.`baitiao_cash_record_ref` t1
	JOIN new_transaction.`baitiao_cash_repay` t3 ON t1.repay_id = t3.id
	JOIN baitiao_audit.`baitiao_order` t4 ON t4.ref_id = t3.ref_id
	JOIN baitiao_audit.`merchant` t5 ON t4.`merchantId` = t5.`merchant_id`
	JOIN new_transaction.`repay_record_online` t2 ON t1.record_id = t2.id
	join new_transaction.repay_channel t7 on t7.id = t1.repay_channel
	AND t1.repay_channel != 13
	WHERE
		t2.bill_time >= '%s'
	AND t2.bill_time < '%s'
	''' % (start_time, end_time)
	df_cash = pd.read_sql(sql_cash,con=engine_new_transaction)

	df = pd.concat([df_alipay, df_bank, df_online,df_cash], ignore_index=True)
	# df.sort_values(['r_year', 'r_month', 'merchant_name', 'approach_name',  u'总额', u'本金', u'利息', u'服务费',  u'逾期罚款收益', u'其他收益',u'总减免',u'红包减免', u'减免本金', u'减免利息', u'减免服务费', u'减免罚息'], inplace=True)
	df = df[
		[ u'产品编号', u'放款期数', 'merchant_name', 'approach_name', u'总额', u'本金', u'利息', u'服务费', u'逾期罚款收益',
		 u'其他收益', u'流水号']]
	df.rename(columns={'merchant_name': '商户', 'approach_name': '收款账户'}, inplace=True)
	# columns = ['年', '月', '商户', '收款账户', '总额', '本金', '利息', '服务费', '红包减免金额', '逾期罚款收益', '其他收益']
	print(sum(df[u'总额']))

	df.to_excel(file_path+u'白条还款明细表-__%s_%s.xlsx' %(year,month), index=None)

	# df.to_csv(file_path + u'白条还款明细表-2222__%s_%s.csv' %(year,month), index=None, encoding='gb18030')

if __name__ == '__main__':

	# 还款明细
	years = [2017]
	months = range(7, 10, 1)
	for year, month in product(years, months):
		print('-----%s--%s') % (year, month)
		hk_hz(year, month)

print '-----------------------main done---------------------------------------'
