# -*- encoding: utf8 -*-

"""
白条非去哪儿收入确认表
"""
from __future__ import unicode_literals
import os

import datetime
import numpy as np
import pandas as pd
import copy

from db_con.db_connect import sql_engine

pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
mysql = sql_engine('audit', 'audit').get_engine()
file_path = 'E:/审计出表/白条/收入确认表'
if not os.path.exists(file_path):
    os.makedirs(file_path)
sql_plan = """SELECT
  rp2017.product_no       产品编号,
  rp2017.current_stage_no 当前期数,
  rp2017.deadline         应还款日,
  rp2017.principle        应还本金,
  rp2017.fee_amount       应还服务费
FROM
  qunaer_new.repayment_plan_2017 rp2017
WHERE rp2017.product_no IN {};
"""

df_loan = pd.read_csv(os.path.join(file_path, '白条去哪儿收入确认表_2017_09.csv'), encoding='gbk')
df_loan.drop(['实还本金', '实还服务费', '退款本金', 'assets', '收入'], inplace=True, axis=1)

step = 5000
ref_ids = tuple(df_loan['产品编号'].astype(str).unique())
res = []
for i in xrange(0, len(ref_ids), step):
    tmp = pd.read_sql(sql=sql_plan.format(str(ref_ids[i:i + step]).replace(',)', ')')), con=mysql)
    res.append(tmp)
df_plan = pd.concat(res)
df_loan_plan = pd.merge(df_loan, df_plan, on='产品编号')
print('查询还款计划: {}, {}'.format(len(ref_ids), df_loan_plan['产品编号'].nunique()))

col_names = list(df_loan_plan.columns)
col_names.extend(['assets', 'assets_remain'])
need_process_list = df_loan_plan.values.tolist()
processed_list = []

item = need_process_list[0]
ref_id = item[0]
loan_amount = item[2]
fee = item[12]
remain = item[8]
all_remain = remain

for i in range(1, len(need_process_list)):
    if need_process_list[i][0] == ref_id:
        # 处理前一条记录
        fee = need_process_list[i][12]
        item.append(min(remain, fee) if loan_amount > 0 else max(remain, fee))
        item.append(0)
        processed_list.append(copy.copy(item))
        item = need_process_list[i]
        remain = max(0, remain - fee) if loan_amount > 0 else min(0, remain - fee)
    else:
        # 处理remain，获取新记录
        item.append(min(remain, fee) if loan_amount > 0 else max(remain, fee))
        remain = max(0, remain - fee) if loan_amount > 0 else min(0, remain - fee)
        item.append(remain)
        processed_list.append(copy.copy(item))

        item = need_process_list[i]
        ref_id = item[0]
        loan_amount = item[2]
        fee = item[12]
        remain = item[8]
        all_remain += remain
item.append(min(remain, fee) if loan_amount > 0 else max(remain, fee))
remain = max(0, remain - fee) if loan_amount > 0 else min(0, remain - fee)
item.append(remain)
processed_list.append(copy.copy(item))
df_res = pd.DataFrame(processed_list, columns=col_names)
print(df_res[['assets', 'assets_remain']].sum())
print('{} - {} - {} = {}'.format(all_remain, df_res['assets'].sum(), df_res['assets_remain'].sum(),
                                 all_remain - df_res['assets'].sum() - df_res['assets_remain'].sum()))

df_res['应还款日'] = df_res['应还款日'].dt.date
df_res['放款时间'] = pd.to_datetime(df_res['放款时间']).dt.date

view_day = datetime.date(2017, 9, 30)


def cal_debt_age(x):
    date_end = max(x['应还款日'], view_day)
    date_start = x['放款时间']
    return (date_end.year - date_start.year) * 12 + (date_end.month - date_start.month)


df_res['账龄'] = df_res[['放款时间', '应还款日']].apply(lambda x: cal_debt_age(x), axis=1)

asset_remain = df_res.loc[df_res.assets_remain != 0]
asset_remain[['产品编号', '风险等级', '放款时间', '应还服务费', 'assets_remain']].to_excel(
    os.path.join(file_path, '去哪儿asset_remain.xlsx'),
    index=None)
df_res['应还年月'] = df_res['应还款日'].apply(lambda x: x.strftime('%Y-%m'))
gp1 = df_res.groupby(['当前期数', '应还年月', '风险等级'])['assets'].agg('sum').reset_index()
gp1.to_excel(os.path.join(file_path, '去哪儿汇总（期数-应还年月-风险等级）.xlsx'), index=None)

gp2 = df_res.groupby(['账龄', '应还年月', '风险等级'])['assets'].agg('sum').reset_index()
gp2.to_excel(os.path.join(file_path, '去哪儿汇总（账龄-应还年月-风险等级）.xlsx'), index=None)

df_res.to_csv(os.path.join(file_path, '去哪儿assets减值-details.csv'), index=None, encoding='gbk')
#
# max_limit = 900000
# if len(df_res) > max_limit:
#     for i in xrange(0, len(df_res), max_limit):
#         df_res[i:i + max_limit].to_csv(os.path.join(file_path, '去哪儿assets减值-details_%d.csv' % (i / max_limit + 1)), index=None,
#                                        encoding='utf8')
df_res.loc[df_res['产品编号'].duplicated(), '放款金额'] = 0
print('{}'.format(df_res['放款金额'].sum()))
