# -*- encoding: utf8 -*-

"""
目标：
    现金贷放款表明细表，一条放款一行，还款计划横向展示
数据库：
    audit.loan_manifest, new_transaction.user_repayment_plan
字段名：
    资金方，loan_id，贷款合同号，放款日期，放款金额，本金（债权），一次性手续费（QG），一次性手续费（资金方），贷款总期数，
    第一期应还款日，第一期应还款金额，第二期……，放款账户，放款流水号，风险等级
注意：
    筛选条件 is_active
"""

import os

import pandas as pd

from db_con.db_connect import sql_engine
import multiprocessing as mtp

# ----------------------------------------------
pd.options.mode.chained_assignment = None
step = 10000
max_limit = 900000
file_path = u'E:/审计出表/现金贷'
file_name = u'现金贷放款表-明细表'
if not os.path.exists(file_path):
    os.makedirs(file_path)
mysql = sql_engine('audit', 'temp', False).get_engine()
sql_loan = """SELECT
  fc.name                         '资金方',
  lm.loan_id,
  la.accountName                  '放款账户',
  date(lm.loan_paid_at)           '放款日期',
  lm.real_loan_amount             '放款金额',
  lm.contract_loan_amount         '本金（债权）',
  lm.qg_one_time_service_fee      '一次性手续费（QG）',
  lm.funding_one_time_service_fee '一次性手续费（资金方）',
  lm.contract_term                '贷款总期数',
  lm.batch_no                     '放款流水号',
  lct.class                       '风险等级',
  lc.contract_no                  '贷款合同号',
  xdp.qg_one_time_service_fee     '应扣趸收服务费',
  lm.ref_id
FROM audit.loan_manifest lm
  JOIN basic.loan_class_test lct ON lct.ref_id = lm.ref_id
  JOIN basic.loan_contract lc ON lc.ref_id = lm.ref_id
  JOIN audit.funding_corp fc ON fc.funding_code = lm.funding_code
  JOIN audit.loan_account la ON la.id = lm.loan_account_id
  LEFT JOIN new_transaction.xjd_dunjiao_plan xdp ON xdp.ref_id = lm.ref_id
WHERE lm.is_active IN (1, -2) AND lm.loan_paid_at >= '%s' AND lm.loan_paid_at < '%s';
"""
sql_plan = """
SELECT
  urp.ref_id,
  urp.term_no,
  date(urp.deadline)                 deadline,
  urp.required_repayment,
  concat('第', urp.term_no, '期应还款日')  title_deadline,
  concat('第', urp.term_no, '期应还款金额') title_amount
FROM new_transaction.user_repayment_plan urp
WHERE ref_id IN %s;
"""
base_columns = [u'资金方', u'loan_id', u'贷款合同号', u'放款日期', u'放款金额', u'本金（债权）',
                u'一次性手续费（QG）', u'一次性手续费（资金方）', u'贷款总期数', u'放款账户', u'放款流水号',
                u'风险等级', u'应扣趸收服务费']


# ----------------------------------------------

def process_loan(start, end):
    df = pd.read_sql(sql=sql_loan % (start, end), con=mysql, chunksize=step)
    df_loan = pd.DataFrame()
    for tmp in df:
        df_loan = df_loan.append(tmp)
    if len(df_loan) > 0:
        max_terms = df_loan[u'贷款总期数'].max()
        out_columns = []
        out_columns.extend(base_columns)
        for i in xrange(0, max_terms):
            out_columns.append(u'第%d期应还款日' % (i + 1))
            out_columns.append(u'第%d期应还款金额' % (i + 1))
        ref_ids = df_loan.ref_id.astype(str).tolist()
        res = []
        for i in xrange(0, len(ref_ids), step):
            plan = pd.read_sql(sql=sql_plan % str(tuple(ref_ids[i:i + step])).replace(',)', ')'), con=mysql)
            res.append(plan)
        df_plan = pd.concat(res)
        plan1 = df_plan.pivot('ref_id', 'title_deadline', 'deadline').reset_index()
        plan2 = df_plan.pivot('ref_id', 'title_amount', 'required_repayment').reset_index()
        plan_all = pd.merge(plan1, plan2)
        df_loan_plan = pd.merge(df_loan, plan_all)
        df_loan_plan = df_loan_plan[out_columns]
        if len(df_loan_plan) > max_limit:
            excel_file = pd.ExcelWriter(
                os.path.join(file_path, '%s(%d-%02d).xlsx' % (file_name, start.year, start.month)))
            for i in xrange(0, len(df_loan_plan), max_limit):
                df_loan_plan[i:i + max_limit].to_csv(os.path.join(file_path, '%s(%d-%02d)-%d.csv' % (
                    file_name, start.year, start.month, i / max_limit + 1)), index=None, encoding='utf8')
                df_loan_plan[i:i + max_limit].to_excel(excel_file, str(i / max_limit + 1), index=None)
        else:
            df_loan_plan.to_csv(os.path.join(file_path, '%s(%d-%02d).csv' % (
                file_name, start.year, start.month)), index=None, encoding='utf8')
            df_loan_plan.to_excel(os.path.join(file_path, '%s(%d-%02d).xlsx' % (file_name, start.year, start.month)),
                                  index=None)
        print('%s-%s\t放款金额\t%s\t本金债权\t%s' % (
        start.year, start.month, df_loan_plan[u'放款金额'].sum(), df_loan_plan[u'本金（债权）'].sum()))


if __name__ == '__main__':
    date_range = pd.date_range(start='2015-08', end='2015-09', freq='MS')
    # start = date_range[4]
    # end = date_range[5]
    # process_loan(start=start, end=end)
    pool = mtp.Pool(processes=6)
    for i in range(0, len(date_range) - 1):
        start = date_range[i]
        end = date_range[i + 1]
        pool.apply_async(process_loan, (start, end))
    pool.close()
    pool.join()
    print('--------------------all done---------------------')
