# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
import multiprocessing as mtp
from itertools import product

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

#
# 表名称：
#	白条-去哪儿-核算-放款表：分多种类型，转让保理后的放款表，资金方的放款表，针对用户角度的放款表
#
#


file_path =  u'E:/审计出表/去哪儿/'
file_name = u'核算放款表_%s_%s.xlsx'
engine_qunaer = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/qunaer_new?charset=utf8',
							  echo=False).connect()
# 债权转让后的保理放款表
def baoli_pay(year, month,plan_table='baoli_repayment_plan'):
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)
	sql_pay = '''
	select '保理' AS '资金方',
		pay.product_no '产品编号',
		date(pay.trans_time) '贷款时间',
		pay.loan_amount '合同放款金额',
		pay.new_stages AS '分期数',
		'FALSE' AS '退款与否',
		'FALSE' AS  '是否转分期后订单号'
	from qunaer_new.baoli_pay_detail pay
	where trans_time >='%s' and trans_time < '%s'
	''' % (start_time, end_time)

	# 读取sql语句，2分钟左右
	df_pay = pd.read_sql(sql_pay, engine_qunaer)
	return df_pay[[u'资金方',u'产品编号',u'贷款时间',u'合同放款金额',u'分期数',u'退款与否',u'是否转分期后订单号']]

# 资金方放款表
def fund_pay(year,month):
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)
	# 资金方的放款表
	sql_pay = '''
    	select fc.fund_name '资金方',
    		pay.product_no '产品编号',
    		date(pay.trans_time) '贷款时间',
    		pay.loan_amount '合同放款金额',
    		pay.stages '分期数',
    		'FALSE' AS '退款与否',
    		'FALSE' AS '是否转分期后订单号'
    	from qunaer_new.fund_pay_detail pay
    	join qunaer_new.fund_corp fc on pay.fund_code = fc.fund_code
    	where trans_time >='%s' and trans_time < '%s'
    ''' % (start_time, end_time)

	# 读取sql语句，2分钟左右
	df_pay = pd.read_sql(sql_pay, engine_qunaer)
	return df_pay[[u'资金方',u'产品编号',u'贷款时间',u'合同放款金额',u'分期数',u'退款与否',u'是否转分期后订单号']]

#保理的放款表，注意，非债权转让后的放款表
def user_pay(year,month,plan_table='repayment_plan_2017'):
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)
	# 用户的放款表
	sql_pay = '''
        select '保理' AS '资金方',
        	pay.product_no '产品编号',
        	date(pay.trans_time) '贷款时间',
        	pay.loan_amount '合同放款金额',
        	pay.stages '分期数',
        	'FALSE' AS '退款与否',
        	if(pay.is_ptf = 0,'FALSE','TRUE') '是否转分期后订单号'
        from qunaer_new.pay_detail pay
        where pay.fund_code = 1 and trans_time >='%s' and trans_time < '%s'
    ''' % (start_time, end_time)

	# 属于保理的退款
	sql_refund = '''
        select '保理' AS '资金方',
        refund.product_no '产品编号',
        date(pay.trans_time) '贷款时间',
        refund.refund_amount '合同放款金额',
        pay.stages '分期数',
        'TRUE' AS '退款与否',
        date(refund.refund_time) '退款时间',
        MONTH(refund.refund_time) '退款月份',
        refund.refund_principle '退款本金',
        refund.refund_fee_amount '退款服务费',
        refund.refund_due_amount '退款罚息',
        if(pay.is_ptf = 0,'FALSE','TRUE') '是否转分期后订单号'
        from qunaer_new.refund_detail refund
        JOIN qunaer_new.pay_detail pay on refund.product_no = pay.product_no and refund.fund_code = pay.fund_code
        WHERE pay.fund_code = 1 and refund_time >='%s' and refund_time < '%s' AND refund.flow_id is NULL 
    ''' % (start_time, end_time)
	# 读取sql语句，2分钟左右
	df_pay = pd.read_sql(sql_pay, engine_qunaer)
	# 含有 flow_id 的退款，在还款表中体现。
	df_refund = pd.read_sql(sql_refund, engine_qunaer)
	# 合并退款记录和放款记录
	print(len(df_refund))
	df = pd.concat([df_pay, df_refund], ignore_index=True)
	df = df.fillna(0)
	return df[[u'资金方',u'产品编号',u'贷款时间',u'合同放款金额',u'分期数',u'退款与否',u'退款时间',u'退款月份',u'退款本金',u'退款服务费',u'退款罚息',u'是否转分期后订单号']]


if __name__ == '__main__':
	years = [2017]
	months = range(7,10)
	for year, month in product(years, months):
		df_baoli=baoli_pay(year,month)
		df_fund=fund_pay(year,month)
		df_user=user_pay(year,month)
		writer=pd.ExcelWriter(file_path+file_name%(year,month))
		# 后续就没有内保了，只有债转后的内保。
		if len(df_user) > 0:
			df_user.to_excel(writer,sheet_name=u'保理放款表',encoding='UTF-8',index=None)
		df_fund.to_excel(writer,sheet_name=u'资金方放款表',encoding='UTF-8',index=None)
		df_baoli.to_excel(writer, sheet_name=u'债转后的保理放款表', encoding='UTF-8', index=None)
		writer.save()
		writer.close()


print '-----------------------main done---------------------------------------'