# -*- coding: utf-8 -*-
import datetime
import sys
import multiprocessing as mtp
import numpy as np
import pandas as pd
from sqlalchemy import create_engine
reload(sys)
sys.setdefaultencoding('utf8')


'''
目标：统计 指定在时间段的放款 & 在指定时间段的还款 的 已还本金
表头：订单号  放款时间  已还本金=（扣除减免后的本金） remark=(在 {还款时间} 还 {金额})
注意：订单为成功订单的放款还款
'''

#---------------------配置变量开始-----------------------
#TODO 文件输出路劲
path='E:/'
#输出文件名
file_name=u'已还本金_2016.csv'
#未还本金文件名
un_repay_file_name=path+u'未还本金_2016.csv'
#TODO 还款时间开始 --- 还款时间结束
start_time = '2017-01-01 00:00:00'
end_time = '2017-07-01 00:00:00'
#TODO  放款时间开始 --- 放款时间结束
fk_start_time='2015-01-01 00:00:00'
fk_end_time='2017-01-01 00:00:00'
#TODO 数据源
engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/new_transaction?charset=utf8',
    echo=True)
#---------------------配置变量结束-----------------------


sql_online='''
select t1.principle-t1.mitigate_principle real_principle,t4.real_loan_amount,t4.contract_term,t4.loan_paid_at,t4.merchantId,t4.funding_corp_id,t3.ref_id,t3.order_no,t2.bill_time repaid_at,concat(DATE(t2.bill_time),'还款',t1.principle-t1.mitigate_principle) remark from baitiao_repay_plan_repay_record_ref t1
join repay_record_online t2 on t1.record_id = t2.id and t1.repay_channel < 13
join user_bt_repayment_plan t3 on t1.plan_id = t3.id
join baitiao_audit.baitiao_order t4 on t3.ref_id = t4.ref_id and t4.is_active = 1
where t4.loan_paid_at >= '%s' and t4.loan_paid_at < '%s' and t2.bill_time >= '%s' and t2.bill_time < '%s'
''' % (fk_start_time,fk_end_time,start_time,end_time)

sql_ali='''
select t1.principle-t1.mitigate_principle real_principle,t4.real_loan_amount,t4.contract_term,t4.loan_paid_at,t4.merchantId,t4.funding_corp_id,t3.ref_id,t3.order_no,t2.transfer_time repaid_at,concat(DATE(t2.transfer_time),'还款',t1.principle-t1.mitigate_principle) remark from baitiao_repay_plan_repay_record_ref t1
join offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13
join user_bt_repayment_plan t3 on t1.plan_id = t3.id
join baitiao_audit.baitiao_order t4 on t3.ref_id = t4.ref_id and t4.is_active = 1
where t4.loan_paid_at >= '%s' and t4.loan_paid_at < '%s' and t2.transfer_time >= '%s' and t2.transfer_time < '%s'
''' % (fk_start_time,fk_end_time,start_time,end_time)

sql_bank='''
select t1.principle-t1.mitigate_principle real_principle,t4.real_loan_amount,t4.contract_term,t4.loan_paid_at,t4.merchantId,t4.funding_corp_id,t3.ref_id,t3.order_no,t2.transfer_time repaid_at,concat(DATE(t2.transfer_time),'还款',t1.principle-t1.mitigate_principle) remark from baitiao_repay_plan_repay_record_ref t1
join offline_bank_repay_record t2 on t1.record_id = t2.id and t1.repay_channel in (14,15,16)
join user_bt_repayment_plan t3 on t1.plan_id = t3.id
join baitiao_audit.baitiao_order t4 on t3.ref_id = t4.ref_id and t4.is_active = 1
where t4.loan_paid_at >= '%s' and t4.loan_paid_at < '%s' and t2.transfer_time >= '%s' and t2.transfer_time < '%s'
''' % (fk_start_time,fk_end_time,start_time,end_time)

sql_merchant='''
select merchant_id merchantId,merchant_name from baitiao_audit.merchant
'''
sql_fund='''
select id funding_corp_id,fund_name from baitiao_audit.fund_corp
'''

if __name__ == '__main__':
    df_online = pd.read_sql(sql_online, engine_new_transaction)
    df_ali = pd.read_sql(sql_ali, engine_new_transaction)
    df_bank = pd.DataFrame()
    if start_time < '2017-01-01 00:00:00':
        df_bank = pd.read_sql(sql_bank, engine_new_transaction)
    # 所有的还款
    df = pd.concat([df_online, df_ali,df_bank], ignore_index=True, axis=0)
    df_ = pd.pivot_table(df, index=['ref_id'], values=['real_principle', 'remark'],
                         aggfunc={'real_principle': np.sum,
                                  'remark': lambda x: ';'.join(x.tolist())}).reset_index().rename(
        columns={'real_principle': 'sum_principle', 'remark': 'sum_remark'})
    df_ = df.merge(df_)
    df_.drop_duplicates('ref_id', inplace=True)
    df_.fillna(0,inplace=True)
    df_=df_.ix[df_['sum_principle'] != 0]
    df_merchant=pd.read_sql(sql_merchant,engine_new_transaction)
    df_fund = pd.read_sql(sql_fund,engine_new_transaction)
    df_=pd.merge(df_,df_merchant,on='merchantId',how='left')
    df_ = pd.merge(df_, df_fund, on='funding_corp_id', how='left')
    df_[['fund_name','merchant_name','order_no', 'repaid_at', 'sum_principle', 'sum_remark','real_loan_amount','contract_term','loan_paid_at']].to_csv(path + 'repay.csv')
    # df_=pd.read_csv(path + 'repay.csv')
    df_.order_no=df_.order_no.astype(str)

    # 未还本金文件读取
    df_un_repay = pd.read_csv(un_repay_file_name,encoding='utf8')
    df_new = pd.merge(df_, df_un_repay, left_on='order_no',right_on=u'订单号', how='outer')
    #如果有实还本金，但是 未还本金没有，那么 未还本金==0 的被过滤掉了。
    df_new.ix[df_new[u'订单号'].isnull(),u'订单金额']=df_new[df_new[u'订单号'].isnull()]['real_loan_amount']
    df_new.ix[df_new[u'订单号'].isnull(), u'合同期数'] = df_new[df_new[u'订单号'].isnull()]['contract_term']
    df_new.ix[df_new[u'订单号'].isnull(), u'放款时间'] = df_new[df_new[u'订单号'].isnull()]['loan_paid_at']
    df_new.ix[df_new[u'订单号'].isnull(), u'商户'] = df_new[df_new[u'订单号'].isnull()]['merchant_name']
    df_new.ix[df_new[u'订单号'].isnull(), u'资金方'] = df_new[df_new[u'订单号'].isnull()]['fund_name']
    df_new.ix[df_new[u'订单号'].isnull(), u'订单号'] = df_new[df_new[u'订单号'].isnull()]['order_no']
    df_new=df_new[[u'资金方',u'商户',u'订单号',u'订单金额',u'合同期数',u'放款时间',u'未还本金','sum_principle','sum_remark']]
    df_new.fillna(0,inplace=True)
    df_new[u'未还本金']=df_new[u'未还本金'].astype(float)
    df_new['diff'] = np.round(df_new[u'未还本金']-df_new['sum_principle'],2)
    df_new.to_csv(path+'principle_chayi.csv',encoding='utf8')






