# encoding: utf8
import pandas as pd
import multiprocessing as mtp
from sqlalchemy import create_engine
import datetime
import numpy as np

pd.options.mode.chained_assignment = None

engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/temp?charset=utf8', echo=True)
file_path = u'E:/数据汇总/现金贷/服务费/'
year = 2016


step = 10000
columns = [u'应收贷前服务费', u'实还贷前服务费', u'应收贷后服务费', u'实还贷后服务费', u'F', u'服务费减免金额', u'no_repay_fee']

sql_plan = """
SELECT 
  t2.ref_id,
   t2.loan_id,
  t1.id plan_id,
  t1.term_no,
  t1.fund_code,
  t1.service_fee2 应收贷后服务费,
  t2.service_fee1 / t2.contract_term 应收贷前服务费,
  t1.deadline,
  t2.loan_paid_at
FROM
  user_repayment_plan t1 
  JOIN loan_manifest t2 
    ON t1.ref_id = t2.ref_id 
AND t2.is_active IN (1, -2) AND t2.loan_paid_at < '%s';
"""

sql_ref = """
SELECT t1.plan_id, t2.repaid_at, t1.service_fee1 实还贷前服务费, 
t1.service_fee2 实还贷后服务费, t1.mitigate_service_fee 服务费减免金额
FROM xjd_repay_plan_repay_record_ref t1 JOIN xjd_repay_plan_repay_record_ref_repay_date t2 ON t2.xjd_ref_id = t1.id 
"""

sql_new_ms = """
 SELECT 
  t3.loan_id, t2.term_no,
  t2.repaid_at,
  t2.qg_service_fee,
  0 服务费减免金额 
FROM
  new_ms_transaction_with_term_copy t2 
  JOIN loan_manifest t3 
    ON t3.funding_code = 160 
    AND t3.loan_id = t2.loan_id 
    AND t2.repaid_at < '%s' 
    AND t3.is_active IN (1, - 2) 
  JOIN user_repayment_plan t1 ON t1.ref_id = t3.ref_id AND t1.term_no = t2.term_no;
"""

sql_user_class = """
SELECT loan_id, class FROM nk_loan_lxf_0619
"""




# 应收账款汇总表
def collect_service():
    select_loan = """
        SELECT year(loan_paid_at) statistics_year,month(loan_paid_at) statistics_month,SUM(service_fee1)应收贷前服务费 
        FROM loan_manifest 
        WHERE is_active in (1,-2)
        AND YEAR(loan_paid_at) in(2015,2016)
        GROUP BY 1,2 
    """
    df_loan = pd.read_sql(select_loan, engine_audit)
    df_loan.statistics_year = df_loan.statistics_year.astype(int)
    df_loan.statistics_month = df_loan.statistics_month.astype(int)
    select_plan = """
       SELECT year(t1.deadline) statistics_year,month(t1.deadline) statistics_month,SUM(t1.service_fee2) 应收贷后服务费
        FROM user_repayment_plan t1
        JOIN loan_manifest t2 ON t1.ref_id=t2.ref_id
        WHERE year(t1.deadline)  in(2015,2016)
		  AND t2.is_active in(1,-2)
        GROUP BY 1,2
    """
    df_plan = pd.read_sql(select_plan, engine_audit)
    df_plan.statistics_year = df_plan.statistics_year.astype(int)
    df_plan.statistics_month = df_plan.statistics_month.astype(int)
    select_ref = """
        SELECT year(t2.repaid_at) statistics_year,month(t2.repaid_at) statistics_month,
          SUM(t1.service_fee1) 实还贷前服务费,SUM(t1.service_fee2) 实还贷后服务费,SUM(t1.mitigate_service_fee)服务费减免金额
        FROM xjd_repay_plan_repay_record_ref t1
		JOIN xjd_repay_plan_repay_record_ref_repay_date t2  ON t1.id = t2.xjd_ref_id
		JOIN user_repayment_plan t3 ON t3.id=t1.plan_id
		JOIN loan_manifest t4 ON t4.ref_id=t3.ref_id
        WHERE year(t2.repaid_at) in(2015,2016)
         AND t3.fund_code<>160
          AND t4.is_active in(1,-2)
        GROUP BY 1,2
    """
    df_ref = pd.read_sql(select_ref, engine_audit)
    df_ref.statistics_year = df_ref.statistics_year.astype(int)
    df_ref.statistics_month = df_ref.statistics_month.astype(int)
    # 新马上
    select_ms = """
            SELECT year(t1.repay_date) statistics_year,month(t1.repay_date) statistics_month,
              SUM(t1.service_fee1) 实还贷前服务费,SUM(t1.service_fee2) 实还贷后服务费,0 服务费减免金额
            FROM new_ms_transaction t1
            JOIN  loan_manifest t2 ON t1.loan_id=t2.loan_id
            WHERE year(t1.repay_date) in(2015,2016)
            AND t2.is_active in(1,-2)
              AND t2.funding_code=160
            GROUP BY 1,2
        """
    # 按照new_ms_transaction_with_term表的期数统计已经正确拆分的新马上服务费
    # select_ms = """
    #     SELECT
    #         YEAR (t2.repaid_at) statistics_year,
    #         MONTH (t2.repaid_at) statistics_month,
    #          SUM(t2.service_fee1) 实还贷前服务费,SUM(t2.service_fee2) 实还贷后服务费,0 服务费减免金额
    #     FROM
    #          new_ms_transaction_with_term t2
    #     JOIN user_repayment_plan t3 ON t3.real_loan_id=t2.loan_id AND t2.term_no=t3.term_no
    #     JOIN  loan_manifest t4 ON t4.ref_id=t3.ref_id
    #     WHERE
    #       year(t2.repaid_at) in(2015,2016)
    #        AND t4.is_active in(1,-2)
    #        AND t4.funding_code=160
    #     GROUP BY
    #         1,
    #         2
    # """
    df_ms = pd.read_sql(select_ms, engine_audit)
    df_ms.statistics_year = df_ms.statistics_year.astype(int)
    df_ms.statistics_month = df_ms.statistics_month.astype(int)
    df_ref = df_ref.append(df_ms)

    gps1 = df_ref.groupby(['statistics_year', 'statistics_month'])[u'实还贷前服务费'].agg(['sum']).reset_index().rename(
        columns={'sum': 'service_fee1_sum'})
    df_ref = df_ref.merge(gps1)
    gps2 = df_ref.groupby(['statistics_year', 'statistics_month'])[u'实还贷后服务费'].agg(['sum']).reset_index().rename(
        columns={'sum': 'service_fee2_sum'})
    df_ref = df_ref.merge(gps2)
    gps3 = df_ref.groupby(['statistics_year', 'statistics_month'])[u'服务费减免金额'].agg(['sum']).reset_index().rename(
        columns={'sum': 'push_sum'})
    df_ref = df_ref.merge(gps3)
    df_ref = df_ref[['statistics_year', 'statistics_month', 'service_fee1_sum', 'service_fee2_sum', 'push_sum']]
    df_ref = df_ref.drop_duplicates(
        ['statistics_year', 'statistics_month', 'service_fee1_sum', 'service_fee2_sum', 'push_sum'])
    df_ref.rename(columns={'service_fee1_sum': u'实还贷前服务费', 'service_fee2_sum': u'实还贷后服务费', 'push_sum': u'服务费减免金额'},
                  inplace=True)
    df_1 = pd.merge(df_loan, df_plan, how='outer', on=['statistics_year', 'statistics_month'])
    df_2 = pd.merge(df_1, df_ref, how='outer', on=['statistics_year', 'statistics_month'])

   ########################财务所需最后两列的相关代码  begin#####################################
    # years = [2015,2016, 2017,]
    # months = range(1, 13)
    # import itertools
    # con = itertools.product(years, months)
    # df_dif = pd.DataFrame()
    # for (year, month) in con:
    #     if (year == 2015 and month < 5):
    #         continue
    #     elif (year == 2017 and month > 5):
    #         continue
    #     # 取出该月的应还贷后明细
    #     select_diff = """
    #         SELECT t1.id plan_id,year(t1.deadline) statistics_year,month(t1.deadline) statistics_month,
    #           t1.service_fee2 ,fund_code
    #         FROM user_repayment_plan t1
    #         JOIN loan_manifest t2 ON t1.ref_id=t2.ref_id
    #         WHERE year(deadline)=%s
    #         AND month(deadline)=%s
    #         AND t2.is_active in(1,-2)
    #
    #     """
    #     df_p = pd.read_sql(select_diff % (year, month,), engine_audit)
    #     if len(df_p) > 0:
    #         df_p.plan_id = df_p.plan_id.astype(int)
    #         p1_ids = df_p.ix[df_p.fund_code!=160]['plan_id'].tolist()
    #         # 除新马上外，根据应还plan_id取出对应的应还贷后及实还的年月
    #         select_r = """
    #                     SELECT t1.plan_id,year(t2.repaid_at) statistics_year,month(t2.repaid_at) statistics_month,
    #                       SUM(service_fee2) real_service_fee2
    #                     FROM xjd_repay_plan_repay_record_ref t1
    #                     JOIN xjd_repay_plan_repay_record_ref_repay_date t2 ON t1.id=t2.xjd_ref_id
    #                     WHERE t1.plan_id in %s
    #                     GROUP BY 1,2,3
    #                 """
    #         df_f = pd.read_sql(select_r % str(tuple(p1_ids)).replace(',)', ')'), engine_audit)
    #         df_f.plan_id = df_f.plan_id.astype(int)
    #         df_f = df_f.ix[df_f.statistics_year.notnull()]
    #         # 新马上特殊处理  开始
    #         if ((year == 2016 and month > 4) or (year == 2017)):
    #             # 根据新马上应还plan_id取出对应的应还贷后及实还的年月
    #             select_ms = """
    #                 SELECT
    #                     t3.id plan_id,
    #                     YEAR (t2.repaid_at) statistics_year,
    #                     MONTH (t2.repaid_at) statistics_month,
    #                     SUM(t2.service_fee2) real_service_fee2
    #                 FROM
    #                      new_ms_transaction_with_term t2
    #                 JOIN user_repayment_plan t3 ON t3.real_loan_id=t2.loan_id AND t2.term_no=t3.term_no
    #                 WHERE
    #                    t3.id IN % s
    #                 GROUP BY
    #                     1,
    #                     2,
    #                     3
    #             """
    #             p_ms_ids = df_p.ix[df_p.fund_code == 160]['plan_id'].tolist()
    #             if len(p_ms_ids)>0:
    #                 df_ms = pd.read_sql(select_ms % str(tuple(p_ms_ids)).replace(',)', ')'), engine_audit)
    #                 df_ms.plan_id = df_ms.plan_id.astype(int)
    #                 df_ms = df_ms.ix[df_ms.statistics_year.notnull()]
    #                 df_ms.statistics_year = df_ms.statistics_year.astype(int)
    #                 df_ms.statistics_month = df_ms.statistics_month.astype(int)
    #                 df_f = df_f.append(df_ms)
    #         # 应还的plan_id、应还年组成唯一约束，跟实还plan_id、实还年月组成的唯一约束进行outer合并
    #         df_t = pd.merge(df_p, df_f, how='outer', on=['plan_id', 'statistics_year', 'statistics_month'])
    #         df_t = df_t.fillna(0)
    #         df_dif = df_dif.append(df_t)
    # df_dif.service_fee2 = df_dif.service_fee2.astype(float)
    # df_dif.real_service_fee2 = df_dif.real_service_fee2.astype(float)
    # df_dif['E_1'] = 0
    # df_dif.ix[df_dif.service_fee2 >= df_dif.real_service_fee2, 'E_1'] = df_dif.ix[
    #                                                                         df_dif.service_fee2 >= df_dif.real_service_fee2, 'service_fee2'] - \
    #                                                                     df_dif.ix[
    #                                                                         df_dif.service_fee2 >= df_dif.real_service_fee2, 'real_service_fee2']
    # df_dif['F_1'] = 0
    # df_dif.ix[df_dif.service_fee2 < df_dif.real_service_fee2, 'F_1'] = df_dif.ix[
    #                                                                         df_dif.service_fee2 < df_dif.real_service_fee2, 'service_fee2'] - \
    #                                                                     df_dif.ix[
    #                                                                         df_dif.service_fee2 < df_dif.real_service_fee2, 'real_service_fee2']
    # df_dif.to_csv(file_path + u'服务费明细0623.csv', index=None)
    # gps1 = df_dif.groupby(['statistics_year', 'statistics_month'])['E_1'].agg(['sum']).reset_index().rename(
    #     columns={'sum': 'E'})
    #
    # gps2 = df_dif.groupby(['statistics_year', 'statistics_month'])['F_1'].agg(['sum']).reset_index().rename(
    #     columns={'sum': 'F'})
    # df_ff = gps1.merge(gps2)
    # ########################财务所需最后两列的相关代码  end#####################################
    #
    # df = pd.merge(df_2, df_ff, on=['statistics_year', 'statistics_month'])
    df = df_2
    df.fillna(0)
    # df = df[['statistics_year', 'statistics_month', u'应收贷前服务费', u'实还贷前服务费', u'应收贷后服务费'
    #     , u'实还贷后服务费', u'服务费减免金额', 'E', 'F']]
    # df.sort_values(['statistics_year', 'statistics_month'], inplace=True)
    # df.rename(columns={'statistics_year': u'年', 'statistics_month': u'月', 'E': u'应收贷后服务费-实还贷后服务费≥0',
    #                    'F': u'应收贷后服务费-实还贷后服务费<0'}, inplace=True)
    df = df[['statistics_year', 'statistics_month', u'应收贷前服务费', u'实还贷前服务费', u'应收贷后服务费'
        , u'实还贷后服务费', u'服务费减免金额']]
    df.sort_values(['statistics_year', 'statistics_month'], inplace=True)
    df.to_excel(file_path + u'服务费汇总表0630.xlsx', index=None)

    # 汇总
collect_service()


