# -*- coding: utf-8 -*-
import datetime
import multiprocessing as mtp
import sys
from itertools import product

import numpy as np
import pandas as pd
from dateutil.relativedelta import relativedelta
from sqlalchemy import create_engine

reload(sys)
sys.setdefaultencoding('utf8')

'''
1、代码包括了 白条还款汇总 + 白条还款明细
2、表头： 商户、订单号、放款期数、期数、实际还款日、实际还款金额、本金、利息、服务费、罚息、其他收益、流水号、收款账户
3、本金=减免后的本金；利息=减免后的利息；服务费=减免后的服务费；罚息=减免后的罚息
'''

# 文件生成路劲
output_path = 'E:/hk/bt/'

engine_new_transaction = engine_new_transaction = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/all_back_0430?charset=utf8',
    echo=True)

# 商户
read_merchant_sql = '''SELECT merchant_id,merchant_name FROM baitiao_audit.merchant'''
df_merchant = pd.read_sql(read_merchant_sql, con=engine_new_transaction)
df_merchant['merchant_id'] = df_merchant['merchant_id'].astype(int)

# 收款账户
read_repay_sql = '''
SELECT id,`approach_name` FROM new_transaction.`repay_channel`
'''
df_approach = pd.read_sql(read_repay_sql, engine_new_transaction)
df_approach['id'] = df_approach['id'].astype(int)

'''
白条还款汇总
'''


################################################
# 收客户还款汇总
def hk_hz():
    # 年月, 商户, 渠道 汇总
    sql_alipay = '''  
      SELECT
        YEAR(oar.transfer_time)                r_year,
        MONTH(oar.transfer_time)               r_month,
        mc.merchant_name,
        rc.approach_name,
        SUM(rp_rrr.ref_amount)                 总额,
        SUM(rp_rrr.principle)                  本金,
        SUM(rp_rrr.interest)                   利息,
        SUM(rp_rrr.service_fee)                服务费,
        SUM(rp_rrr.collection_relief)          总减免,
        SUM(rp_rrr.mitigate_principle)         减免本金,
        SUM(rp_rrr.mitigate_interest)          减免利息,
        SUM(rp_rrr.mitigate_service_fee)       减免服务费,
        SUM(rp_rrr.mitigate_collection_relief) 减免罚息,
        SUM(rp_rrr.red_package_fee)            红包减免,
        SUM(rp_rrr.punish)                     逾期罚款收益,
        SUM(rp_rrr.remain_income)              其他收益
      FROM baitiao_repay_plan_repay_record_ref rp_rrr
        JOIN user_bt_repayment_plan ubrp
          ON ubrp.id = rp_rrr.plan_id
        JOIN offline_alipay_record oar
          ON rp_rrr.repay_channel = 13 AND oar.id = rp_rrr.record_id AND oar.is_ref = 1 AND oar.enable = 1
        JOIN baitiao_order bt_r
          ON ubrp.ref_id = bt_r.ref_id
        JOIN baitiao_audit.merchant mc
          ON mc.`merchant_id` = bt_r.`merchantId`
        JOIN new_transaction.repay_channel rc
          ON rp_rrr.repay_channel = rc.id
      GROUP BY 1, 2, 3, 4
    '''

    sql_bank = '''
        SELECT
          YEAR(obrr.transfer_time)               r_year,
          MONTH(obrr.transfer_time)              r_month,
          m.merchant_name,
          rc.approach_name,
          SUM(rp_rrr.ref_amount)                 总额,
          SUM(rp_rrr.principle)                  本金,
          SUM(rp_rrr.interest)                   利息,
          SUM(rp_rrr.service_fee)                服务费,
          SUM(rp_rrr.collection_relief)          总减免,
          SUM(rp_rrr.mitigate_principle)         减免本金,
          SUM(rp_rrr.mitigate_interest)          减免利息,
          SUM(rp_rrr.mitigate_service_fee)       减免服务费,
          SUM(rp_rrr.mitigate_collection_relief) 减免罚息,
          SUM(rp_rrr.red_package_fee)            红包减免,
          SUM(rp_rrr.punish)                     逾期罚款收益,
          SUM(rp_rrr.remain_income)              其他收益
        FROM baitiao_repay_plan_repay_record_ref rp_rrr
          JOIN user_bt_repayment_plan ubrp
            ON ubrp.id = rp_rrr.plan_id
          JOIN offline_bank_repay_record obrr
            ON rp_rrr.repay_channel IN (14, 15, 16) AND obrr.id = rp_rrr.record_id
          JOIN baitiao_order bt_o
            ON ubrp.ref_id = bt_o.ref_id
          JOIN baitiao_audit.merchant m
            ON m.`merchant_id` = bt_o.`merchantId`
          JOIN new_transaction.repay_channel rc
            ON rp_rrr.repay_channel = rc.id
        GROUP BY 1, 2, 3, 4
    '''

    sql_online = '''
      SELECT
        YEAR(rro.bill_time)                       r_year,
        MONTH(rro.bill_time)                      r_month,
        m.merchant_name,
        rc.approach_name,
        SUM(bt_rp_rrr.ref_amount)                 总额,
        SUM(bt_rp_rrr.principle)                  本金,
        SUM(bt_rp_rrr.interest)                   利息,
        SUM(bt_rp_rrr.service_fee)                服务费,
        SUM(bt_rp_rrr.collection_relief)          总减免,
        SUM(bt_rp_rrr.mitigate_principle)         减免本金,
        SUM(bt_rp_rrr.mitigate_interest)          减免利息,
        SUM(bt_rp_rrr.mitigate_service_fee)       减免服务费,
        SUM(bt_rp_rrr.mitigate_collection_relief) 减免罚息,
        SUM(bt_rp_rrr.red_package_fee)            红包减免,
        SUM(bt_rp_rrr.punish)                     逾期罚款收益,
        SUM(bt_rp_rrr.remain_income)              其他收益
      FROM baitiao_repay_plan_repay_record_ref bt_rp_rrr
        JOIN user_bt_repayment_plan ubrp
          ON ubrp.id = bt_rp_rrr.plan_id
        JOIN repay_record_online rro
          ON bt_rp_rrr.repay_channel < 13 AND rro.id = bt_rp_rrr.record_id
        JOIN baitiao_order bt_o
          ON ubrp.ref_id = bt_o.ref_id
        JOIN baitiao_audit.merchant m
          ON m.`merchant_id` = bt_o.`merchantId`
        JOIN new_transaction.repay_channel rc
          ON bt_rp_rrr.repay_channel = rc.id
      GROUP BY 1, 2, 3, 4
    '''

    df_bank = pd.read_sql(sql=sql_bank, con=engine_new_transaction)
    df_alipay = pd.read_sql(sql=sql_alipay, con=engine_new_transaction)
    df_online = pd.read_sql(sql=sql_online, con=engine_new_transaction)

    df = pd.concat([df_alipay, df_bank, df_online], ignore_index=True)
    df.fillna(0, inplace=True)

    df = df[['r_year', 'r_month', 'merchant_name', 'approach_name',
             u'总额', u'本金', u'利息', u'服务费', u'逾期罚款收益', u'其他收益', u'总减免',
             u'红包减免', u'减免本金', u'减免利息', u'减免服务费', u'减免罚息']]

    df[u'本金'] = np.round(df[u'本金'] - df[u'减免本金'], 2)
    df[u'利息'] = np.round(df[u'利息'] - df[u'减免利息'], 2)
    df[u'服务费'] = np.round(df[u'服务费'] - df[u'减免服务费'], 2)
    df[u'逾期罚款收益'] = np.round(df[u'逾期罚款收益'] - df[u'减免罚息'], 2)

    df = df[['r_year', 'r_month', 'merchant_name', 'approach_name',
             u'总额', u'本金', u'利息', u'服务费', u'逾期罚款收益', u'其他收益']]

    # 提取 17年之前的数据
    df = df.ix[df.r_year < 2017]
    df.rename(columns={'r_year': '年', 'r_month': '月', 'merchant_name': '商户',
                       'approach_name': '收款账户'}, inplace=True)

    # columns = ['年', '月', '商户', '收款账户', '总额', '本金', '利息', '服务费', '红包减免金额', '逾期罚款收益', '其他收益']
    df.to_excel(output_path + u'白条还款汇总表.xlsx', index=None)


# ====明细
read_detail_online_sql = '''
  SELECT
    ubrp.id                           plan_id,
    bt_o.merchantId,
    bt_rp_rrr.repay_channel,
    ubrp.order_no,
    bt_o.contract_term,
    ubrp.term_no,
    rro.bill_time                    repaid_at,
    rro.order_id                     business_flow,
    bt_rp_rrr.ref_amount,
    bt_rp_rrr.principle                    real_principle,
    bt_rp_rrr.interest                     real_interest,
    bt_rp_rrr.`service_fee`                real_service_fee,
    bt_rp_rrr.`punish`                     real_punish,
    bt_rp_rrr.remain_income,
    bt_rp_rrr.`mitigate_principle`,
    bt_rp_rrr.`mitigate_interest`,
    bt_rp_rrr.`mitigate_service_fee`,
    bt_rp_rrr.`mitigate_collection_relief` mitigate_punish
  FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
    JOIN `user_bt_repayment_plan` ubrp
      ON ubrp.id = bt_rp_rrr.plan_id
    JOIN `baitiao_order` bt_o
      ON ubrp.ref_id = bt_o.ref_id
    JOIN repay_record_online rro
      ON bt_rp_rrr.record_id = rro.id AND bt_rp_rrr.repay_channel < 13
  WHERE rro.bill_time >= '%s' AND rro.bill_time < '%s'
'''

read_detail_alipay_sql = '''
  SELECT
    ubrp.id                           plan_id,
    bt_o.merchantId,
    bt_rp_rrr.repay_channel,
    ubrp.order_no,
    bt_o.contract_term,
    ubrp.term_no,
    oar.transfer_time                repaid_at,
    oar.business_flow,
    bt_rp_rrr.ref_amount,
    bt_rp_rrr.principle                    real_principle,
    bt_rp_rrr.interest                     real_interest,
    bt_rp_rrr.`service_fee`                real_service_fee,
    bt_rp_rrr.`punish`                     real_punish,
    bt_rp_rrr.remain_income,
    bt_rp_rrr.`mitigate_principle`,
    bt_rp_rrr.`mitigate_interest`,
    bt_rp_rrr.`mitigate_service_fee`,
    bt_rp_rrr.`mitigate_collection_relief` mitigate_punish
  FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
    JOIN `user_bt_repayment_plan` ubrp
      ON ubrp.id = bt_rp_rrr.plan_id
    JOIN `baitiao_order` bt_o
      ON ubrp.ref_id = bt_o.ref_id
    JOIN offline_alipay_record oar
      ON bt_rp_rrr.record_id = oar.id AND bt_rp_rrr.repay_channel = 13
  WHERE oar.transfer_time >= '%s' AND oar.transfer_time < '%s'
'''

read_detail_bank_sql = '''
  SELECT
    ubrp.id                                plan_id,
    bt_o.merchantId,
    bt_rp_rrr.repay_channel,
    ubrp.order_no,
    bt_o.contract_term,
    ubrp.term_no,
    obrr.transfer_time                     repaid_at,
    obrr.serial_number                     business_flow,
    bt_rp_rrr.ref_amount,
    bt_rp_rrr.principle                    real_principle,
    bt_rp_rrr.interest                     real_interest,
    bt_rp_rrr.`service_fee`                real_service_fee,
    bt_rp_rrr.`punish`                     real_punish,
    bt_rp_rrr.remain_income,
    bt_rp_rrr.`mitigate_principle`,
    bt_rp_rrr.`mitigate_interest`,
    bt_rp_rrr.`mitigate_service_fee`,
    bt_rp_rrr.`mitigate_collection_relief` mitigate_punish
  FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
    JOIN `user_bt_repayment_plan` ubrp
      ON ubrp.id = bt_rp_rrr.plan_id
    JOIN `baitiao_order` bt_o
      ON ubrp.ref_id = bt_o.ref_id
    JOIN offline_bank_repay_record obrr
      ON bt_rp_rrr.record_id = obrr.id AND bt_rp_rrr.repay_channel IN (14, 15, 16)
  WHERE obrr.transfer_time >= '%s' AND obrr.transfer_time < '%s'
'''


def handle_detail(year, month):
    start_time = datetime.datetime(year, month, 1, 0, 0, 0)
    end_time = start_time + relativedelta(months=+1)

    df_online_detail = pd.read_sql(read_detail_online_sql % (start_time, end_time), con=engine_new_transaction)
    df_alipay_detail = pd.read_sql(read_detail_alipay_sql % (start_time, end_time), con=engine_new_transaction)
    df_bank_detail = pd.read_sql(read_detail_bank_sql % (start_time, end_time), con=engine_new_transaction)

    df = pd.concat([df_online_detail, df_alipay_detail, df_bank_detail], axis=0, ignore_index=True)
    if len(df) == 0:
        return

    df['repay_channel'] = df['repay_channel'].astype(int)
    df = pd.merge(df, df_approach, left_on=['repay_channel'], right_on=['id'], how='left')
    df = pd.merge(df, df_merchant, left_on=['merchantId'], right_on=['merchant_id'], how='left')
    df.reset_index(inplace=True)
    df.fillna(0, inplace=True)
    df['real_principle'] = np.round(df['real_principle'] - df['mitigate_principle'], 2)
    df['real_interest'] = np.round(df['real_interest'] - df['mitigate_interest'], 2)
    df['real_service_fee'] = np.round(df['real_service_fee'] - df['mitigate_service_fee'], 2)
    df['real_punish'] = np.round(df['real_punish'] - df['mitigate_punish'], 2)
    df = df[['merchant_name', 'order_no', 'contract_term', 'term_no', 'repaid_at',
             'ref_amount', 'real_principle', 'real_interest', 'real_service_fee',
             'real_punish', 'remain_income', 'business_flow', 'approach_name'
             ]]
    df.rename(columns={'merchant_name': '商户', 'approach_name': '收款账户', 'order_no': '订单号',
                       'contract_term': '放款期数', 'term_no': '期数', 'repaid_at': '实还款日',
                       'ref_amount': '实还金额', 'real_principle': '实还本金', 'real_interest': '实还利息',
                       'real_service_fee': '实还服务费', 'real_punish': '实还罚息',
                       'remain_income': '其他收益', 'business_flow': '流水号'
                       }, inplace=True)
    df.to_excel(output_path + str(year) + '_' + str(month) + '.xlsx', columns=df.columns, index=None, encoding='utf8')


if __name__ == '__main__':
    pool = mtp.Pool(processes=3)
    # 还款汇总
    hk_hz()
    # 还款明细
    years = [2016, 2015]
    months = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
    for year, month in product(years, months):
        # handle_detail(year, month)
        print '---------------', year, month
        pool.apply_async(handle_detail, (year, month))
    pool.close()
    pool.join()
print '-----------------------main done---------------------------------------'
