# -*- coding: utf-8 -*-
import sys
import multiprocessing as mtp
import numpy as np
import pandas as pd
from sqlalchemy import create_engine
import os

reload(sys)
sys.setdefaultencoding('utf8')
pd.set_option('display.float_format', lambda x: '%.3f' % x)

'''
目标：
1、统计 现金贷 的 应收贷前，实收贷前，应收贷后 实收贷后数据-----
表头：应收贷前  实收贷前 应收贷后 实收贷后
应收贷前   === 按照放款时间进行统计
应收贷后   === 按照deadline进行统计
实收贷前 实收贷后  == 按照 账单时间 进行统计
注意：1、不要忘记新马上  2、实收还款都是成功订单的还款数据
'''

# ---------------------配置变量开始-----------------------
# TODO 文件输出路劲
path = u'E:/财务/tmp'
# 放款时间
fk_start_time = '2015-01-01 00:00:00'
fk_end_time = '2017-01-01 00:00:00'
# 还款时间
hk_start_time = '2015-01-01 00:00:00'
hk_end_time = '2017-01-01 00:00:00'
# deadline 时间
deadline_start_time = '2015-01-01 00:00:00'
deadline_end_time = '2017-01-01 00:00:00'
# TODO 数据源
engine_financial = create_engine(
    'mysql+mysqldb://mazhen:mazhen8uiplm091@172.20.4.13:3306/financial?charset=utf8',
    echo=True)
# ---------------------配置变量结束-----------------------

# 应收贷前服务费
sql_plan_dq = '''
select year(loan_paid_at) year_,month(loan_paid_at) month_,sum(service_fee1) plan_service_fee1
from loan_manifest
where is_active in (1, -2) and loan_paid_at >= '%s' and loan_paid_at < '%s'
group by 1,2
''' % (fk_start_time, fk_end_time)

# 应收贷后
sql_plan_dh = '''
select year(t1.deadline) year_,month(t1.deadline) month_,sum(t1.service_fee2) plan_service_fee2 from user_repayment_plan t1
join loan_manifest t2 on t1.ref_id = t2.ref_id and t2.is_active in (1, -2)
where t2.loan_paid_at >= '%s' AND t2.loan_paid_at <'%s' and t1.deadline >= '%s' and t1.deadline < '%s'
group by 1,2
''' % (fk_start_time, fk_end_time, deadline_start_time, deadline_end_time)


# 实收服务费
sql_real = '''
select year(t2.repaid_at) year_,month(t2.repaid_at) month_,sum(t1.service_fee1) real_service_fee1,sum(t5.mitigate_service_fee1) mitigate_service_fee1,
sum(t1.service_fee2) real_service_fee2,sum(t5.mitigate_service_fee2) mitigate_service_fee2
from xjd_repay_plan_repay_record_ref t1
left join xjd_repay_plan_repay_record_ref_mitigate_service_fee t5 on t1.id = t5.xjd_ref_id
join xjd_repay_plan_repay_record_ref_repay_date t2 on t1.id = t2.xjd_ref_id
join user_repayment_plan t3 on t1.plan_id = t3.id and t3.fund_code != 160
join loan_manifest t4 on t4.ref_id = t3.ref_id and t4.is_active in (1, -2)
where t4.loan_paid_at >= '%s'  and t4.loan_paid_at < '%s' and t2.repaid_at >= '%s' and t2.repaid_at < '%s'
group by 1,2
''' % (fk_start_time, fk_end_time, hk_start_time, hk_end_time)


# 新马上实收统计
sql_ms_real = '''
select year(t1.repaid_at) year_,month(t1.repaid_at) month_,sum(t1.service_fee1) real_service_fee1,'0' mitigate_service_fee1,
sum(t1.service_fee2) real_service_fee2,'0' mitigate_service_fee2
from new_ms_transaction_with_term_details t1
join loan_manifest t2 on t1.loan_id = t2.loan_id and t2.funding_code = 160
where t2.loan_paid_at >= '%s' and t2.loan_paid_at < '%s' and t1.repaid_at >= '%s' and t1.repaid_at  < '%s'
group by 1,2
''' % (fk_start_time, fk_end_time, hk_start_time, hk_end_time)


cols = {'plan_service_fee1': u'应还贷前服务费', 'plan_service_fee2': u'应还贷后服务费', 'real_service_fee1': u'实还贷前服务费',
        'real_service_fee2': u'实还贷后服务费', 'mitigate_service_fee1': u'减免贷前服务费', 'mitigate_service_fee2': u'减免贷后服务费'}


def tj():
    df_plan_dq = pd.read_sql(sql=sql_plan_dq, con=engine_financial)
    df_plan_dh = pd.read_sql(sql=sql_plan_dh, con=engine_financial)
    df_real = pd.read_sql(sql=sql_real, con=engine_financial)
    df_real_ms = pd.read_sql(sql=sql_ms_real, con=engine_financial)
    df_real_new = pd.concat([df_real, df_real_ms], axis=0, ignore_index=True)
    df_real_new.fillna(0, inplace=True)
    df_real_new['mitigate_service_fee1'] = df_real_new['mitigate_service_fee1'].astype(float)
    df_real_new['mitigate_service_fee2'] = df_real_new['mitigate_service_fee2'].astype(float)
    df_real_new = df_real_new.groupby(['year_', 'month_'])[
        'real_service_fee1', 'mitigate_service_fee1', 'real_service_fee2', 'mitigate_service_fee2'].sum().reset_index()
    df_real_new['year_'] = df_real_new['year_'].astype(int)
    df_real_new['month_'] = df_real_new['month_'].astype(int)
    df_plan_dq['year_'] = df_plan_dq['year_'].astype(int)
    df_plan_dq['month_'] = df_plan_dq['month_'].astype(int)
    df_plan_dh['year_'] = df_plan_dh['year_'].astype(int)
    df_plan_dh['month_'] = df_plan_dh['month_'].astype(int)
    df = pd.merge(df_plan_dq, df_plan_dh, on=['year_', 'month_'], how='outer')
    df = pd.merge(df, df_real_new, on=['year_', 'month_'], how='outer')
    df.fillna(0, inplace=True)
    df = df.ix[df.year_ > 0]
    df.mitigate_service_fee1 = df.mitigate_service_fee1.astype(float)
    df.mitigate_service_fee2 = df.mitigate_service_fee2.astype(float)
    df_ = pd.pivot_table(df, index=['year_', 'month_'],
                         values=['plan_service_fee1', 'plan_service_fee2', 'real_service_fee1', 'mitigate_service_fee1',
                                 'real_service_fee2', 'mitigate_service_fee2'],
                         aggfunc=np.sum).reset_index()
    df_.rename(columns=cols, inplace=True)
    df_.to_excel(os.path.join(path, 'service_fee_tj.xlsx'), index=False, encoding='utf8')


if __name__ == '__main__':
    tj()
