# 统计已还本金
# 明细
SELECT
  bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle         real_principle,
  bt_o.real_loan_amount,
  bt_o.contract_term,
  bt_o.loan_paid_at,
  bt_o.merchantId,
  bt_o.funding_corp_id,
  ubrp.ref_id,
  ubrp.order_no,
  rro.bill_time                                              repaid_at,
  concat(DATE(rro.bill_time), '还款',
         bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) remark
FROM baitiao_repay_plan_repay_record_ref bt_rp_rrr
  JOIN repay_record_online rro
    ON bt_rp_rrr.record_id = rro.id AND bt_rp_rrr.repay_channel < 13
  JOIN user_bt_repayment_plan ubrp
    ON bt_rp_rrr.plan_id = ubrp.id
  JOIN baitiao_audit.baitiao_order bt_o
    ON ubrp.ref_id = bt_o.ref_id AND bt_o.is_active = 1
WHERE bt_o.loan_paid_at >= '%s' AND bt_o.loan_paid_at < '%s'
      AND rro.bill_time >= '%s' AND rro.bill_time < '%s';


SELECT
  bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle         real_principle,
  bt_o.real_loan_amount,
  bt_o.contract_term,
  bt_o.loan_paid_at,
  bt_o.merchantId,
  bt_o.funding_corp_id,
  ubrp.ref_id,
  ubrp.order_no,
  oar.transfer_time                                          repaid_at,
  concat(DATE(oar.transfer_time), '还款',
         bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) remark
FROM baitiao_repay_plan_repay_record_ref bt_rp_rrr
  JOIN offline_alipay_record oar
    ON bt_rp_rrr.record_id = oar.id AND bt_rp_rrr.repay_channel = 13
  JOIN user_bt_repayment_plan ubrp
    ON bt_rp_rrr.plan_id = ubrp.id
  JOIN baitiao_audit.baitiao_order bt_o
    ON ubrp.ref_id = bt_o.ref_id AND bt_o.is_active = 1
WHERE bt_o.loan_paid_at >= '%s' AND bt_o.loan_paid_at < '%s'
      AND oar.transfer_time >= '%s' AND oar.transfer_time < '%s';


SELECT
  bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle         real_principle,
  bt_o.real_loan_amount,
  bt_o.contract_term,
  bt_o.loan_paid_at,
  bt_o.merchantId,
  bt_o.funding_corp_id,
  ubrp.ref_id,
  ubrp.order_no,
  obrr.transfer_time                                         repaid_at,
  concat(DATE(obrr.transfer_time), '还款',
         bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) remark
FROM baitiao_repay_plan_repay_record_ref bt_rp_rrr
  JOIN offline_bank_repay_record obrr
    ON bt_rp_rrr.record_id = obrr.id AND bt_rp_rrr.repay_channel IN (14, 15, 16)
  JOIN user_bt_repayment_plan ubrp
    ON bt_rp_rrr.plan_id = ubrp.id
  JOIN baitiao_audit.baitiao_order bt_o
    ON ubrp.ref_id = bt_o.ref_id AND bt_o.is_active = 1
WHERE
  bt_o.loan_paid_at >= '%s' AND bt_o.loan_paid_at < '%s'
  AND obrr.transfer_time >= '%s' AND obrr.transfer_time < '%s';


# 统计未还本金
# 明细
SELECT
  ubrp.ref_id,
  SUM(bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) real_principle
FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
  JOIN `offline_alipay_record` oar
    ON bt_rp_rrr.`record_id` = oar.id AND bt_rp_rrr.`repay_channel` = 13
  JOIN `user_bt_repayment_plan` ubrp
    ON bt_rp_rrr.plan_id = ubrp.id
  JOIN baitiao_audit.`baitiao_order` bt_o
    ON ubrp.ref_id = bt_o.ref_id AND bt_o.`is_active` = 1
WHERE oar.transfer_time >= '%s' AND oar.transfer_time < '%s'
GROUP BY ubrp.ref_id;

SELECT
  ubrp.ref_id,
  SUM(bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) real_principle
FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
  JOIN `repay_record_online` rro
    ON bt_rp_rrr.`record_id` = rro.id AND bt_rp_rrr.`repay_channel` < 13
  JOIN `user_bt_repayment_plan` ubrp
    ON bt_rp_rrr.plan_id = ubrp.id
  JOIN baitiao_audit.`baitiao_order` bt_o
    ON ubrp.ref_id = bt_o.ref_id AND bt_o.`is_active` = 1
WHERE rro.bill_time >= '%s' AND rro.bill_time < '%s'
GROUP BY ubrp.ref_id;

SELECT
  ubrp.ref_id,
  SUM(bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) real_principle
FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
  JOIN `offline_bank_repay_record` obrr
    ON bt_rp_rrr.`record_id` = obrr.id AND bt_rp_rrr.`repay_channel` IN (14, 15, 16)
  JOIN `user_bt_repayment_plan` ubrp
    ON bt_rp_rrr.plan_id = ubrp.id
  JOIN baitiao_audit.`baitiao_order` bt_o
    ON ubrp.ref_id = bt_o.ref_id AND bt_o.`is_active` = 1
WHERE obrr.transfer_time >= '%s' AND obrr.transfer_time < '%s'
GROUP BY ubrp.ref_id;

