# 应收贷前服务费
SELECT
  date_format(loan_paid_at, '%Y-%m') yearMonth,
  sum(service_fee1)                  plan_service_fee1
FROM temp.loan_manifest
WHERE is_active = 1 AND loan_paid_at < '2017-01-01 00:00:00'
GROUP BY 1;

# 应收贷前服务费--abc
SELECT
  date_format(lm.loan_paid_at, '%Y-%m') yearMonth,
  lc.class                              class_,
  sum(lm.service_fee1)                  plan_service_fee1
FROM temp.loan_manifest lm
  JOIN temp.loan_class lc
    ON lm.ref_id = lc.ref_id
WHERE lm.is_active = 1
      AND lm.loan_paid_at >= '%s' AND lm.loan_paid_at < '%s'
GROUP BY 1, 2;

#应收贷后
SELECT
  date_format(urp.deadline, '%Y-%m') yearMonth,
  sum(urp.service_fee2)              plan_service_fee2
FROM temp.user_repayment_plan urp
  JOIN temp.loan_manifest lm
    ON urp.ref_id = lm.ref_id AND lm.is_active = 1
WHERE lm.loan_paid_at >= '%s' AND lm.loan_paid_at < '%s'
      AND urp.deadline >= '%s' AND urp.deadline < '%s'
GROUP BY 1;

#应收贷后---abc
SELECT
  date_format(urp.deadline, '%Y-%m') yearMonth,
  LC.class                           class_,
  sum(urp.service_fee2)              plan_service_fee2
FROM temp.user_repayment_plan urp
  JOIN temp.loan_manifest lm
    ON urp.ref_id = lm.ref_id AND lm.is_active = 1
  JOIN temp.loan_class LC
    ON lm.ref_id = LC.ref_id
WHERE lm.loan_paid_at >= '%s' AND lm.loan_paid_at < '%s'
      AND urp.deadline >= '%s' AND urp.deadline < '%s'
GROUP BY 1, 2;

#实收服务费
SELECT
  date_format(rp_rrr_rd.repaid_at, '%Y-%m') yearMonth,
  sum(rp_rrr.service_fee1)                  real_service_fee1,
  sum(rp_rrr_msf.mitigate_service_fee1)     mitigate_service_fee1,
  sum(rp_rrr.service_fee2)                  real_service_fee2,
  sum(rp_rrr_msf.mitigate_service_fee2)     mitigate_service_fee2
FROM temp.xjd_repay_plan_repay_record_ref rp_rrr
  LEFT JOIN temp.xjd_repay_plan_repay_record_ref_mitigate_service_fee rp_rrr_msf
    ON rp_rrr.id = rp_rrr_msf.xjd_ref_id
  JOIN temp.xjd_repay_plan_repay_record_ref_repay_date rp_rrr_rd
    ON rp_rrr.id = rp_rrr_rd.xjd_ref_id
  JOIN temp.user_repayment_plan urp
    ON rp_rrr.plan_id = urp.id AND urp.fund_code != 160
  JOIN temp.loan_manifest lm
    ON lm.ref_id = urp.ref_id AND lm.is_active = 1
WHERE lm.loan_paid_at >= '%s' AND lm.loan_paid_at < '%s'
      AND rp_rrr_rd.repaid_at >= '%s' AND rp_rrr_rd.repaid_at < '%s'
GROUP BY 1;

#实收服务费---abc
SELECT
  date_format(rp_rrr_rd.repaid_at, '%Y-%m') yearMonth,
  lc.class                                  class_,
  sum(rp_rrr.service_fee1)                  real_service_fee1,
  sum(rp_rrr_msf.mitigate_service_fee1)     mitigate_service_fee1,
  sum(rp_rrr.service_fee2)                  real_service_fee2,
  sum(rp_rrr_msf.mitigate_service_fee2)     mitigate_service_fee2
FROM temp.xjd_repay_plan_repay_record_ref rp_rrr
  LEFT JOIN temp.xjd_repay_plan_repay_record_ref_mitigate_service_fee rp_rrr_msf
    ON rp_rrr.id = rp_rrr_msf.xjd_ref_id
  JOIN temp.xjd_repay_plan_repay_record_ref_repay_date rp_rrr_rd
    ON rp_rrr.id = rp_rrr_rd.xjd_ref_id
  JOIN temp.user_repayment_plan urp
    ON rp_rrr.plan_id = urp.id AND urp.fund_code != 160
  JOIN temp.loan_manifest lm
    ON lm.ref_id = urp.ref_id AND lm.is_active = 1
  JOIN temp.loan_class lc
    ON lm.ref_id = lc.ref_id
WHERE lm.loan_paid_at >= '%s' AND lm.loan_paid_at < '%s'
      AND rp_rrr_rd.repaid_at >= '%s' AND rp_rrr_rd.repaid_at < '%s'
GROUP BY 1, 2;

#新马上实收统计
SELECT
  date_format(nms_twt_c.repaid_at, '%Y-%m') yearMonth,
  sum(nms_twt_c.service_fee1)               real_service_fee1,
  '0'                                       mitigate_service_fee1,
  sum(nms_twt_c.service_fee2)               real_service_fee2,
  '0'                                       mitigate_service_fee2
FROM temp.new_ms_transaction_with_term_copy nms_twt_c
  JOIN temp.loan_manifest lm
    ON nms_twt_c.loan_id = lm.loan_id AND lm.funding_code = 160
WHERE lm.loan_paid_at >= '%s' AND lm.loan_paid_at < '%s'
      AND nms_twt_c.repaid_at >= '%s' AND nms_twt_c.repaid_at < '%s'
GROUP BY 1;

#新马上实收服务费 --- abc
SELECT
  date_format(nms_twt_c.repaid_at, '%Y-%m') yearMonth,
  lc.class                                  class_,
  sum(nms_twt_c.service_fee1)               real_service_fee1,
  '0'                                       mitigate_service_fee1,
  sum(nms_twt_c.service_fee2)               real_service_fee2,
  '0'                                       mitigate_service_fee2
FROM temp.new_ms_transaction_with_term_copy nms_twt_c
  JOIN temp.loan_manifest lm
    ON nms_twt_c.loan_id = lm.loan_id AND lm.funding_code = 160
  JOIN temp.loan_class lc
    ON lm.ref_id = lc.ref_id
WHERE lm.loan_paid_at >= '%s' AND lm.loan_paid_at < '%s'
      AND nms_twt_c.repaid_at >= '%s' AND nms_twt_c.repaid_at < '%s'
GROUP BY 1, 2;

