select
  lc.class,
  year(lm.loan_paid_at),
  month(lm.loan_paid_at),
  year(urp.deadline),
  month(urp.deadline),
  sum(urp.principle),
  sum(urp.interest)
from
  loan_manifest lm
  inner join user_repayment_plan urp
    on lm.ref_id = urp.ref_id
       and lm.is_active in (1, -2)
       and lm.loan_paid_at < '2017-01-01'
  inner join loan_class lc
    on lm.ref_id = lc.ref_id
group by lc.class,
  date_format(lm.loan_paid_at, '%Y-%m'),
  year(urp.deadline),
  month(urp.deadline);


select
  lc.class,
  date_format(lm.loan_paid_at, '%Y-%m') loan_paid_at,
  date_format(urp.deadline, '%Y-%m')    deadline,
  sum(urp.principle),
  sum(urp.interest)
from
  loan_manifest lm
  inner join user_repayment_plan urp
    on lm.ref_id = urp.ref_id
       and lm.is_active in (1, -2)
       and lm.loan_paid_at < '2017-01-01'
  inner join loan_class lc
    on lm.ref_id = lc.ref_id
group by 1, 2, 3;
