# 之后做法可以考虑，不写复杂的sql，先把基础数据从数据库导出来（csv文件），然后用程序来处理（过滤、转换、连接等），这样速度可能会快一点
# 要不然每次都查询一次全量数据，很费时，发现sql错了，又得重新导一下数据

# 放款还款计划表
SELECT
  lc.class,
  date_format(lm.loan_paid_at, '%Y-%m') loan_month,
  lm.loan_paid_at,
  lm.ref_id,
  lm.loan_id,
  lm.service_fee1                       total_req_service_fee1,
  lm.service_fee1 / lm.contract_term    loan_req_service_fee1,
  lm.is_active,
  lm.funding_code,
  date_format(urp.deadline, '%Y-%m')    plan_month,
  urp.deadline,
  urp.term_no,
  urp.id                                plan_id,
  urp.service_fee1                      plan_req_service_fee1,
  urp.service_fee2                      plan_req_service_fee2
FROM
  temp.user_repayment_plan urp
  JOIN temp.loan_manifest lm
    ON urp.ref_id = lm.ref_id
       AND lm.loan_paid_at < '2017-01-01 00:00:00'
  JOIN temp.loan_class lc
    ON lc.ref_id = lm.ref_id;


# 非新马上还款计划表
SELECT
  date_format(rp_rrr_rd.repaid_at, '%Y-%m') repay_month,
  rp_rrr_rd.repaid_at,
  rp_rrr.plan_id,
  rp_rrr.service_fee1                       real_service_fee1,
  rp_rrr.service_fee2                       real_service_fee2,
  rp_rrr.mitigate_service_fee
FROM
  temp.xjd_repay_plan_repay_record_ref rp_rrr
  JOIN temp.xjd_repay_plan_repay_record_ref_repay_date rp_rrr_rd
    ON rp_rrr.id = rp_rrr_rd.xjd_ref_id AND rp_rrr_rd.repaid_at < '2017-01-01 00:00:00'
  JOIN temp.user_repayment_plan urp
    ON urp.id = rp_rrr.plan_id AND urp.fund_code <> 160;


# 新马上
SELECT
  date_format(nms_twt_c.repaid_at, '%Y-%m') repay_month,
  nms_twt_c.repaid_at,
  urp.id                                    plan_id,
  nms_twt_c.service_fee1                    real_service_fee1,
  nms_twt_c.service_fee2                    real_service_fee2,
  0                                         mitigate_service_fee
FROM temp.new_ms_transaction_with_term_copy nms_twt_c
  JOIN temp.user_repayment_plan urp
    ON urp.real_loan_id = nms_twt_c.loan_id
       AND urp.term_no = nms_twt_c.term_no
       AND urp.fund_code = 160
       AND nms_twt_c.repaid_at < '2017-01-01 00:00:00';
