# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
import numpy as np
from itertools import product
from sqlalchemy import create_engine
import multiprocessing as mtp
from dateutil.relativedelta import relativedelta

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

'''
表1：去哪儿商户存值；存值时间，商户，金额，流水号
表2：放款明细：产品编号，贷款时间，合同放款金额，分期数，是否为转分期后订单号，去哪儿合同放款金额
表3：客户还款流水：实还时间，金额，流水号
'''

engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/all_back_0630?charset=utf8', echo=False).connect()
# writer = pd.ExcelWriter(u'E:/qunaer_人工核对.xlsx')
path = u'E:/数据汇总/白条/去哪儿/放款/'
formate_date = '%%Y-%%m-%%d'
formate_date2 = '%%Y%%m%%d'

sql_pay_t = '''
select t1.product_no ,t1.loan_amount
from qunaer_new.pay_detail t1
JOIN qunaer_new.repayment_plan_2016_201706 t2 ON t1.product_no=t2.product_no
WHERE
	t1.STATUS = 1
AND t2.`status`!=3
and  t1.trans_time >= '%s' and t1.trans_time < '%s'
GROUP BY 1
'''
sql_plan_t = '''
SELECT
	t2.product_no,
	sum(t2.principle) principle
from qunaer_new.repayment_plan_2016_201706 t2 
WHERE
t2.status!=3
AND t2.product_no in %s
	GROUP  BY 1
'''
sql_refund_t = '''
select t1.product_no,sum(t1.refund_amount) loan_amount
from qunaer_new.refund_detail t1 
where t1.refund_status = 1 and t1.product_no in %s
GROUP  BY  1
'''


def adjust_refund(start_time, end_time):
    df_pay = pd.read_sql(sql_pay_t % (start_time, end_time), engine_new_transaction)
    df_pay['product_no'] = df_pay['product_no'].astype(str)
    product_no_list = df_pay['product_no'].tolist()
    df_refund = pd.read_sql(sql_refund_t % str(tuple(product_no_list)).replace(',)', ')'), engine_new_transaction)
    df_out = pd.concat([df_pay, df_refund], axis=0, ignore_index=True)
    df_pay = df_out.groupby(['product_no'])['loan_amount'].agg(['sum']).reset_index().rename(
        columns={'sum': 'loan_amount_sum'})
    df_plan = pd.read_sql(sql_plan_t % str(tuple(product_no_list)).replace(',)', ')'), engine_new_transaction)
    df_plan['product_no'] = df_plan['product_no'].astype(str)
    df_t = pd.merge(df_pay, df_plan, on=['product_no'], how='left')
    df_t['diff'] = df_t['principle'] - df_t['loan_amount_sum']
    df_2 = df_t.ix[df_t['diff'] != 0]
    df_2['diff'] = df_2['diff'].apply(lambda x: np.round(x, 2))
    df_3 = df_2[['product_no', 'diff']]
    return df_3


# 放款计划
sql_pay = '''
select t1.product_no  '产品编号',date(t1.loan_time) '贷款时间' ,t1.loan_amount '合同放款金额',t1.stages '分期数' ,
case t1.is_ptf when 0 then 'FALSE' when 1 then 'TRUE' end as '是否为转分期后订单号',1 '当前期数'
from qunaer_new.pay_detail t1
WHERE
	t1.STATUS = 1
and  t1.trans_time >= '%s' and t1.trans_time < '%s'
AND t1.product_no in (
SELECT DISTINCT t11.product_no FROM qunaer_new.pay_detail t11
JOIN qunaer_new.repayment_plan_2016_201706 t12 on t12.product_no=t11.product_no
WHERE t12.`status`!=3
AND  t11.trans_time >= '%s' and t11.trans_time < '%s'
)
'''
sql_plan = '''
SELECT
	t2.product_no  '产品编号',
	t2.current_stage_no '当前期数',
	t2.deadline '当前应还款日',
	t2.principle '当前本金',
	 t2.repay_principle  '实还本金'
from qunaer_new.repayment_plan_2016_201706 t2 
WHERE
	t2.product_no in %s
'''
sql_refund = '''
select t1.product_no '产品编号',date(t1.refund_time) '贷款时间',t1.refund_amount '合同放款金额',t2.stages '分期数',
'FALSE' as '是否为转分期后订单号' 
from qunaer_new.refund_detail t1 
join qunaer_new.pay_detail  t2 on t1.product_no = t2.product_no
where t1.refund_status = 1 
and t1.product_no in %s
'''


def loan_info(year, month):
    start_time = datetime.date(year, month, 1)
    end_time = datetime.date(year, month, 1) + relativedelta(months=+1)
    df_pay = pd.read_sql(sql_pay % (start_time, end_time, start_time, end_time), engine_new_transaction)
    df_pay[u'当前期数'] = df_pay[u'当前期数'].astype(int)
    df_pay[u'产品编号'] = df_pay[u'产品编号'].astype(str)
    product_no_list = df_pay[u'产品编号'].tolist()
    df_plan = pd.read_sql(sql_plan % str(tuple(product_no_list)).replace(',)', ')'), engine_new_transaction)
    df_plan[u'当前期数'] = df_plan[u'当前期数'].astype(int)
    df_plan[u'产品编号'] = df_plan[u'产品编号'].astype(str)
    df_t = pd.merge(df_pay, df_plan, on=[u'产品编号', u'当前期数'], how='outer')
    df_refund = pd.read_sql(sql_refund % str(tuple(product_no_list)).replace(',)', ')'), engine_new_transaction)
    df_refund[u'产品编号'] = df_refund[u'产品编号'].astype(str)
    df_refund[u'合同放款金额'] = df_refund[u'合同放款金额'].apply(lambda x: np.round(x, 2))
    condition = df_refund.groupby([u'产品编号'])[u'合同放款金额'].agg(['min', 'count']).reset_index().rename(
        columns={'min': 'refund_max', 'count': 'f_count'})
    single = condition.ix[condition['f_count'] == 1]
    mulit_t = condition.ix[condition['f_count'] > 1]
    mulit = mulit_t.groupby([u'产品编号', 'refund_max'])['f_count'].agg(['count']).reset_index().rename(
        columns={'count': 's_count'})
    mulit_1 = mulit.ix[mulit['s_count'] == 1]
    mulit_n = mulit.ix[mulit['s_count'] > 1]
    mulit_n_t = mulit_n.drop_duplicates([u'产品编号'])
    if len(mulit_n_t) > 0:
        mulit_1 = pd.concat(mulit_1, mulit_n_t, ignore_index=True)
    df_single = df_refund.ix[df_refund[u'产品编号'].isin(single[u'产品编号'])]
    df_mulit_1 = df_refund.ix[df_refund[u'产品编号'].isin(mulit_1[u'产品编号'])]
    df_adjust = adjust_refund(start_time, end_time)
    df_refund_1 = df_single.merge(df_adjust, left_on=u'产品编号', right_on='product_no', how='left')
    df_refund_t = pd.merge(mulit_1, df_adjust, left_on=u'产品编号', right_on='product_no')
    df_refund_2 = df_mulit_1.merge(df_refund_t, left_on=[u'产品编号', u'合同放款金额'], right_on=[u'产品编号', 'refund_max'],
                                   how='left')
    df_refund_3 = mulit_n.merge(df_adjust, left_on=u'产品编号', right_on='product_no', how='left')
    df_refund = pd.concat([df_refund_1, df_refund_2, df_refund_3], ignore_index=True)
    df_refund = df_refund.drop_duplicates([u'产品编号', u'合同放款金额'])
    df_refund = df_refund[[u'产品编号', u'贷款时间', u'合同放款金额', u'分期数', u'是否为转分期后订单号','diff']]
    # df_refund = df_refund.merge(df_adjust, left_on=u'产品编号', right_on='product_no', how='left')
    df_refund['diff'].fillna(0, inplace=True)
    df_refund[u'合同放款金额'] = df_refund[u'合同放款金额'] + df_refund['diff']
    df_refund = df_refund.drop(['diff'], axis=1)
    df_refund = df_refund[[u'产品编号', u'贷款时间', u'合同放款金额', u'分期数', u'是否为转分期后订单号']]
    df_out = pd.concat([df_t, df_refund], ignore_index=True)
    df_out[u'去哪儿合同放款金额'] = df_out[u'合同放款金额']
    df_out = df_out[[u'产品编号', u'贷款时间', u'合同放款金额', u'分期数', u'当前期数', u'当前应还款日',
                     u'当前本金', u'实还本金', u'是否为转分期后订单号', u'去哪儿合同放款金额']]
    df_out.to_excel(path + u'去哪儿放款%s-%s计划.xlsx' % (year, month), index=None)


# 给商户存值---全部去哪儿---有可能缺少
sql_qg_to_merchant = '''
SELECT 
    date_format(t1.transfer_date,'%s') '存值时间',t1.merchant_name '商户',
    t1.transfer_amount '金额',t1.serial_number '流水号' 
FROM test_zyl.merchant_qg_serial_ref t1 
JOIN qg_to_merchant t2 ON t1.transfer_id = t2.id AND t1.transfer_type = 0 AND locate('去哪',t2.remark) > 0 
WHERE date_format(t1.transfer_date,'%s') >='%s' AND date_format(t1.transfer_date,'%s')< '%s'
'''


# .decode('utf8')


def qg2merchant(year, month):
    start_time = datetime.date(year, month, 1).strftime('%Y%m%d')
    end_time = (datetime.date(year, month, 1) + relativedelta(months=+1)).strftime('%Y%m%d')
    df_qg_to_merchant = pd.read_sql(
        sql_qg_to_merchant % (formate_date2, formate_date2, start_time, formate_date2, end_time),
        engine_new_transaction)
    df_qg_to_merchant[u'存值时间'] = df_qg_to_merchant[u'存值时间'].apply(lambda x: datetime.datetime.strptime(x, '%Y%m%d'))
    df_qg_to_merchant[u'存值时间'] = df_qg_to_merchant[u'存值时间'].apply(lambda x: x.strftime('%Y-%m-%d'))
    # df_qg_to_merchant.to_excel(writer, sheet_name='商户存值', index=False)
    if len(df_qg_to_merchant) > 0:
        df_qg_to_merchant.to_csv(path + u'%s-%s给用户充值.csv' % (year, month), index=None, encoding='gbk')


# merchant_to_qg----qunaer_new.bank_flow---全部去哪儿
# sql_merchant_to_qg = '''
# SELECT date_format(t1.transfer_date,'%%Y%%m%%d') '实还时间',t1.transfer_amount '金额',t1.serial_number '流水号'
# FROM test_zyl.merchant_qg_serial_ref t1
# JOIN merchant_to_qg t2 ON t1.transfer_id = t2.id AND t1.transfer_type = 1 AND AND locate('去哪',t2.remark) > 0
# WHERE t1.transfer_date>'%s' AND t1.transfer_date<= '%s'
# '''.decode('utf8')
sql_merchant_to_qg = """
SELECT date_format(trans_time,'%s') 实还时间,
trans_amount 金额,
flow_id 流水号
FROM qunaer_new.bank_flow 
WHERE 
trans_type =2
AND trans_time>'%s' 
AND trans_time<= '%s'
""".decode('utf8')


def merchant2qg(year, month):
    start_time = datetime.date(year, month, 1)
    end_time = datetime.date(year, month, 1) + relativedelta(months=+1)
    df_merchant_to_qg = pd.read_sql(sql_merchant_to_qg % (formate_date, start_time, end_time), engine_new_transaction)
    # df_merchant_to_qg[u'实还时间'] = df_merchant_to_qg[u'实还时间'].apply(lambda x: datetime.datetime.strptime(x, '%Y%m%d'))
    # df_merchant_to_qg[u'实还时间'] = df_merchant_to_qg[u'实还时间'].apply(lambda x: x.strftime('%Y-%m-%d'))
    # df_merchant_to_qg.to_excel(writer, sheet_name=u'商户还款', index=False)
    if len(df_merchant_to_qg) > 0:
        df_merchant_to_qg.to_csv(path + u'%s-%s商户给去哪儿充值.csv' % (year, month), index=None, encoding='gbk')


# 去哪儿还款---8-2017.6
# sql_repay='''
# select t1.product_no '产品编号',current_stage_no ,repay_time '实还时间',repay_amount '实还金额' , repay_principle '实还本金',repay_fee_amount '实还服务费',
# repay_due_amount '实还罚息',remain '其他收益',serial_num,t2.stages,t2.loan_amount
# from qunaer_new.repay_detail t1
# JOIN qunaer_new.pay_detail t2 on t1.product_no = t2.product_no
# where repay_status = 1 AND repay_type != 'REFUND_REPAY' and repay_time >= '2016-08-01' and repay_time < '2016-09-01'
# '''
# sql_serial='''
# select serial_number serial_num,transfer_amount '银行金额'
# from test_zyl.merchant_qg_serial_ref
# where serial_number in %s
# '''
# df_repay=pd.read_sql(sql_repay,engine_new_transaction)
# serial_nums=df_repay.serial_num.astype(str).tolist()
# df_serial=pd.read_sql(sql_serial % str(tuple(serial_nums)).replace(',)',')'),engine_new_transaction)
# df_repay=pd.merge(df_repay,df_serial,on='serial_num',how='left')
# #当期应还本金=== 按照订单金额/期数，最后一期用总金额-前几期之和这样来操作
# df_repay['avg']=np.round(df_repay['loan_amount'] / df_repay['stages'],2)
# df_repay.ix[df_repay.current_stage_no == df_repay.stages,'avg']=\
#     df_repay.ix[df_repay.current_stage_no ==df_repay.stages].apply(lambda x:np.round(x.loan_amount-x.avg*(x.stages-1),2),axis=1)
# df_repay.rename(columns={'avg':u'当期应还本金','current_stage_no':u'期数'},inplace=True)
# df_repay.drop(['stages','loan_amount'],axis=1,inplace=True)
# df_repay.to_excel(writer,sheet_name=u'客户还款',index=False)
# writer.save()


years = (2016,)
months = (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
loan_info(2016, 8)
# if __name__ == '__main__':
#     pool = mtp.Pool(processes=8)
#     for year, month in product(years, months):
#         print year, month
#         if year == 2016 and month < 8:
#             continue
#         elif year == 2017 and month > 6:
#             continue
#         else:
#             pool.apply_async(loan_info, (year, month))
#     pool.close()
#     pool.join()
