# encoding: utf8
import pandas as pd
from sqlalchemy import create_engine
from api import db_connect

engine_financial = con = db_connect.sql_engine('financial', False).get_engine()

loan_start = '2015-01-01 00:00:00'
loan_end = '2017-01-01 00:00:00'
date_format = '%y-%m'

sql = """
  select
    lc.class,
    year(t1.loan_paid_at),
    month(t1.loan_paid_at),
    year(urp.deadline),
    month(urp.deadline),
    sum(urp.principle),
    sum(urp.interest)
  from loan_manifest t1
    inner join user_repayment_plan urp
      on t1.loanid = urp.loanid 
         and t1.is_active in (1, -2) 
         and t1.loan_paid_at < '2017-01-01'
    inner join loan_class lc
      on t1.loanid = lc.loanid
  group by 1,2,3,4,5 
"""
# path_out = u'/root/finance/xjd/'
path_out = u'E:/财务/'

df = pd.read_sql(sql=sql, con=engine_financial)
df.to_excel(path_out + u'现金贷应收本金利息汇总.xlsx', index=None)
