# -*- coding: utf-8 -*-
import os
import sys
import datetime
import threading
from itertools import product
from threading import Thread

import pandas as pd
from dateutil.relativedelta import relativedelta

from sqlalchemy import create_engine
import multiprocessing as mtp

reload(sys)
sys.setdefaultencoding('utf8')

path = './'
start_time = "2017-04-01 00:00:00"
end_time = "2017-07-01 00:00:00"

read_fund_sql = '''
  select id fund_corp_id,name fund_name 
  from new_transaction.funding_corp 
  where id not in (40,60)
'''
read_repay_sql = '''
  SELECT id,`approach_name` 
  FROM new_transaction.`repay_channel`
'''

sql_query_dunjiao = """
  SELECT
    lm.funding_code,
    lm.loan_paid_at,
    lm.loan_id,
    lm.contract_term,
    rro.bill_time repaid_at,
    xjd_dpr.ref_amount,
    rro.order_id,
    xjd_dpr.repay_channel
  FROM
    loan_manifest lm
    JOIN xjd_dunjiao_plan xjd_dp
      ON lm.ref_id = xjd_dp.ref_id
    JOIN xjd_dunjiao_plan_ref xjd_dpr
      ON xjd_dp.id = xjd_dpr.plan_id
    JOIN repay_record_online rro
      ON xjd_dpr.record_id = rro.id
  WHERE bill_time >= "%s" AND bill_time < "%s"
"""

engine_new_transaction = engine_new_transaction = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/all_back_0630?charset=utf8',
    echo=True)

df_fund = pd.read_sql(read_fund_sql, con=engine_new_transaction)
df_approach = pd.read_sql(read_repay_sql, con=engine_new_transaction)

df_approach['id'] = df_approach['id'].astype(int)

df_dunjiao = pd.read_sql(sql_query_dunjiao % (start_time, end_time), con=engine_new_transaction)

df_dunjiao = pd.merge(df_dunjiao, df_fund, how='left', left_on=['funding_code'], right_on=['fund_corp_id'])
df_dunjiao = pd.merge(df_dunjiao, df_approach, how='left', left_on=['repay_channel'], right_on=['id'])

df_dunjiao = df_dunjiao[['fund_name', 'loan_paid_at', 'loan_id',
                         'contract_term', 'repaid_at', 'ref_amount',
                         'order_id', 'approach_name']]

df_dunjiao.sort_values(by=['repaid_at'], inplace=True)

df_dunjiao.rename(
    columns={'fund_name': '资金方',
             'loan_paid_at': '放款时间',
             'loan_id': '放款id',
             'contract_term': '放款期数',
             'repaid_at': '实还款日',
             'ref_amount': '实还金额',
             'order_id': '渠道流水号',
             'approach_name': '收款账户'
             }, inplace=True)

df_dunjiao.to_excel(path + 'dunjiao_' + str(2017) + '.xlsx', columns=df_dunjiao.columns, index=None, encoding='utf8')
