# -*- coding: utf-8 -*-
import os
import sys
import datetime
import threading
from itertools import product
from threading import Thread

import pandas as pd
from dateutil.relativedelta import relativedelta

from sqlalchemy import create_engine
import multiprocessing as mtp

reload(sys)
sys.setdefaultencoding('utf8')

'''
现金贷还款表
1、现金贷还款汇总
2、还款时间使用账单时间
3、特殊 新马上
'''

read_fund_sql = '''
select id fund_corp_id,name fund_name from new_transaction.funding_corp where id not in (40,60)
'''
read_repay_sql = '''
SELECT id,`approach_name` FROM new_transaction.`repay_channel`
'''

engine_new_transaction = engine_new_transaction = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/all_back_0630?charset=utf8',
    echo=True)

df_fund = pd.read_sql(read_fund_sql, con=engine_new_transaction)
df_approach = pd.read_sql(read_repay_sql, engine_new_transaction)
df_approach['id'] = df_approach['id'].astype(int)

path = './'

fundcodes = [
    1, 0, 3, 2, 5, 29, 4, 141, 50, 70, 80, 90, 100, 120, 110, 130, 150,
    170, 180, 140, 190, 200, 210, 135, 230, 240,
    250, 251, 260, 300, 290, 270, 330, 310, 320, 350, 340, 360, 363]


################################################
# 收客户还款汇总
def hk_hz():
    sql_alipay = """    
      select
        year(lm.loan_paid_at)           l_year,
        month(lm.loan_paid_at)          l_month,
        year(oar.transfer_time)          r_year,
        month(oar.transfer_time)         r_month,
        fc.name                         funding_name,
        rc.approach_name,
        sum(rp_rrr.ref_amount)          总额,
        sum(rp_rrr.principle)           本金,
        sum(rp_rrr.interest)            利息,
        sum(rp_rrr.service_fee)         服务费,
        sum(rp_rrr.collection_relief)   催收减免,
        -- sum(t1.red_package_fee) 实还红包减免,
        sum(rp_rrr.punish)              逾期罚款收益,
        sum(rp_rrr.remain_income)       其他收益,
        sum(mitigate_principle)         减免本金,
        sum(mitigate_interest)          减免利息,
        sum(mitigate_service_fee)       减免服务费,
        sum(mitigate_collection_relief) 减免罚息
      from xjd_repay_plan_repay_record_ref rp_rrr
        join user_repayment_plan urp
          on urp.id = rp_rrr.plan_id
        join new_transaction.funding_corp fc
          on urp.fund_code = fc.id
        join new_transaction.repay_channel rc
          on rp_rrr.repay_channel = rc.id
        join loan_manifest lm
          on lm.ref_id = urp.ref_id
        join offline_alipay_record oar
          on rp_rrr.repay_channel = 13 and oar.id = rp_rrr.record_id
      group by 1, 2, 3, 4, 5, 6
    """

    df_alipay = pd.read_sql(sql=sql_alipay, con=engine_new_transaction)
    sql_bank = """    
      select
        year(lm.loan_paid_at)           l_year,
        month(lm.loan_paid_at)          l_month,
        year(obrr.transfer_time)          r_year,
        month(obrr.transfer_time)         r_month,
        fc.name                         funding_name,
        rc.approach_name,
        sum(rp_rrr.ref_amount)          总额,
        sum(rp_rrr.principle)           本金,
        sum(rp_rrr.interest)            利息,
        sum(rp_rrr.service_fee)         服务费,
        sum(rp_rrr.collection_relief)   催收减免,
        -- sum(t1.red_package_fee) 实还红包减免,
        sum(rp_rrr.punish)              逾期罚款收益,
        sum(rp_rrr.remain_income)       其他收益,
        sum(mitigate_principle)         减免本金,
        sum(mitigate_interest)          减免利息,
        sum(mitigate_service_fee)       减免服务费,
        sum(mitigate_collection_relief) 减免罚息
      from xjd_repay_plan_repay_record_ref rp_rrr
        join user_repayment_plan urp
          on urp.id = rp_rrr.plan_id
        join new_transaction.funding_corp fc
          on urp.fund_code = fc.id
        join new_transaction.repay_channel rc
          on rp_rrr.repay_channel = rc.id
        join audit.loan_manifest lm
          on lm.ref_id = urp.ref_id
        join offline_bank_repay_record obrr
          on rp_rrr.repay_channel in (14, 15, 16) and obrr.id = rp_rrr.record_id
      group by 1, 2, 3, 4, 5, 6
    """
    df_bank = pd.read_sql(sql=sql_bank, con=engine_new_transaction)
    sql_online = """    
      select
        year(lm.loan_paid_at)           l_year,
        month(lm.loan_paid_at)          l_month,
        year(rro.bill_time)              r_year,
        month(rro.bill_time)             r_month,
        fc.name                         funding_name,
        rc.approach_name,
        sum(rp_rrr.ref_amount)          总额,
        sum(rp_rrr.principle)           本金,
        sum(rp_rrr.interest)            利息,
        sum(rp_rrr.service_fee)         服务费,
        sum(rp_rrr.collection_relief)   催收减免,
        -- sum(t1.red_package_fee) 实还红包减免,
        sum(rp_rrr.punish)              逾期罚款收益,
        sum(rp_rrr.remain_income)       其他收益,
        sum(mitigate_principle)         减免本金,
        sum(mitigate_interest)          减免利息,
        sum(mitigate_service_fee)       减免服务费,
        sum(mitigate_collection_relief) 减免罚息
      from xjd_repay_plan_repay_record_ref rp_rrr
        join user_repayment_plan urp
          on urp.id = rp_rrr.plan_id
        join new_transaction.funding_corp fc
          on urp.fund_code = fc.id
        join new_transaction.repay_channel rc
          on rp_rrr.repay_channel = rc.id
        join loan_manifest lm
          on lm.ref_id = urp.ref_id
        join repay_record_online rro
          on rp_rrr.repay_channel < 13 and rro.id = rp_rrr.record_id
      group by 1, 2, 3, 4, 5, 6
    """
    df_online = pd.read_sql(sql=sql_online, con=engine_new_transaction)

    sql_dunjiao_serivce_fee = """
      SELECT
        YEAR(lm.loan_paid_at)   l_year,
        MONTH(lm.loan_paid_at)  l_month,
        YEAR(rro.bill_time)     r_year,
        MONTH(rro.bill_time)    r_month,
        fc.name                 funding_name,
        rc.approach_name,
        sum(xjd_dpr.ref_amount) "实还趸收服务费"
      FROM new_transaction.xjd_dunjiao_plan_ref xjd_dpr
        JOIN new_transaction.xjd_dunjiao_plan xjd_dp
          ON xjd_dpr.plan_id = xjd_dp.id
        JOIN audit.loan_manifest lm
          ON xjd_dp.ref_id = lm.ref_id
        JOIN new_transaction.repay_record_online rro
          ON xjd_dpr.record_id = rro.id
        JOIN new_transaction.funding_corp fc
          ON fc.id = 150
        JOIN new_transaction.repay_channel rc
          ON rc.id = 2 AND rro.pay_approach = 2
      group by 1, 2, 3, 4, 5, 6
    """
    df_dunjiao = pd.read_sql(sql=sql_dunjiao_serivce_fee, con=engine_new_transaction)

    df = pd.concat([df_alipay, df_bank, df_online], ignore_index=True)
    df = pd.merge(df, df_dunjiao, how='left',
                  on=['l_year', 'l_month', 'r_year', 'r_month', 'funding_name', 'approach_name'])
    df[u'实还趸收服务费'].fillna(value=0, inplace=True)
    df[u'总额'] = df[u'总额'] + df[u'实还趸收服务费']
    df.sort_values(['l_year', 'l_month', 'r_year', 'r_month', 'funding_name', 'approach_name'], inplace=True)
    df.rename(columns={'l_year': '放款年', 'l_month': '放款月', 'r_year': '还款年', 'r_month': '还款月',
                       'funding_name': '资金方', 'approach_name': '收款账户'}, inplace=True)
    excel_file = pd.ExcelWriter(path + u'现金贷还款表汇总_430.xlsx')
    df.to_excel(excel_file, 'Sheet1',
                columns=['放款年', '放款月', '还款年', '还款月', '资金方', '收款账户', '总额', '本金', '利息',
                         '服务费', '催收减免', '逾期罚款收益', '其他收益', '减免本金', '减免利息', '减免服务费',
                         '减免罚息', '实还趸收服务费'], index=None)
    excel_file.save()


################################################
# 明细
read_detail_online_sql = '''
  SELECT
    urp.id                                              plan_id,
    urp.fund_code,
    rp_rrr.repay_channel,
    urp.real_loan_id                                    loan_id,
    lm.contract_term,
    urp.term_no,
    rro.bill_time                                       repaid_at,
    rp_rrr.ref_amount,
    rp_rrr.principle - rp_rrr.mitigate_principle        real_principle,
    rp_rrr.interest - rp_rrr.mitigate_interest          real_interest,
    rp_rrr.`service_fee` - rp_rrr.mitigate_service_fee  real_service_fee,
    rp_rrr.`punish` - rp_rrr.mitigate_collection_relief real_punish,
    rp_rrr.remain_income,
    rro.order_id
  FROM `xjd_repay_plan_repay_record_ref` rp_rrr
    JOIN `user_repayment_plan` urp
      ON urp.id = rp_rrr.plan_id
    JOIN audit.`loan_manifest` lm
      ON urp.ref_id = lm.ref_id
    JOIN repay_record_online rro
      ON rp_rrr.record_id = rro.id AND rp_rrr.repay_channel < 13
  WHERE rro.bill_time >= '%s' and rro.bill_time < '%s'
        AND lm.funding_code = %s
'''

read_detail_alipay_sql = '''
  SELECT
    urp.id                                              plan_id,
    urp.fund_code,
    rp_rrr.repay_channel,
    urp.real_loan_id                                    loan_id,
    lm.contract_term,
    urp.term_no,
    oar.transfer_time                                   repaid_at,
    rp_rrr.ref_amount,
    rp_rrr.principle - rp_rrr.mitigate_principle        real_principle,
    rp_rrr.interest - rp_rrr.mitigate_interest          real_interest,
    rp_rrr.`service_fee` - rp_rrr.mitigate_service_fee  real_service_fee,
    rp_rrr.`punish` - rp_rrr.mitigate_collection_relief real_punish,
    rp_rrr.remain_income,
    oar.business_flow                                   order_id
  FROM `xjd_repay_plan_repay_record_ref` rp_rrr
    JOIN `user_repayment_plan` urp
      ON urp.id = rp_rrr.plan_id
    JOIN audit.`loan_manifest` lm
      ON urp.ref_id = lm.ref_id
    JOIN `offline_alipay_record` oar
      ON rp_rrr.record_id = oar.id and rp_rrr.repay_channel = 13
  WHERE oar.transfer_time >= '%s' AND oar.transfer_time < '%s' 
        AND lm.funding_code = %s
'''

read_detail_bank_sql = '''
  SELECT
    urp.id                                              plan_id,
    urp.fund_code,
    rp_rrr.repay_channel,
    urp.real_loan_id                                    loan_id,
    lm.contract_term,
    urp.term_no,
    obrr.transfer_time                                  repaid_at,
    rp_rrr.ref_amount,
    rp_rrr.principle - rp_rrr.mitigate_principle        real_principle,
    rp_rrr.interest - rp_rrr.mitigate_interest          real_interest,
    rp_rrr.`service_fee` - rp_rrr.mitigate_service_fee  real_service_fee,
    rp_rrr.`punish` - rp_rrr.mitigate_collection_relief real_punish,
    rp_rrr.remain_income,
    ''                                                  order_id
  FROM `xjd_repay_plan_repay_record_ref` rp_rrr
    JOIN `user_repayment_plan` urp
      ON urp.id = rp_rrr.plan_id
    JOIN audit.`loan_manifest` lm
      ON urp.ref_id = lm.ref_id
    JOIN `offline_bank_repay_record` obrr
      ON rp_rrr.record_id = obrr.id and rp_rrr.repay_channel in (14, 15, 16)
  WHERE obrr.transfer_time >= '%s' AND obrr.transfer_time < '%s'
        AND lm.funding_code = %s
'''


# 还款明细
def handle_hk(fund_code):
    start_time = datetime.datetime(2017, 4, 1, 0, 0, 0)
    end_time = datetime.datetime(2017, 7, 1, 0, 0, 0)

    df_online_detail = pd.read_sql(
        read_detail_online_sql % (start_time, end_time, fund_code),
        con=engine_new_transaction)
    print read_detail_online_sql % (start_time, end_time, fund_code)

    df_alipay_detail = pd.read_sql(
        read_detail_alipay_sql % (start_time, end_time, fund_code),
        con=engine_new_transaction)
    print read_detail_alipay_sql % (start_time, end_time, fund_code)

    df_bank_detail = pd.read_sql(
        read_detail_bank_sql % (start_time, end_time, fund_code),
        con=engine_new_transaction)

    df = pd.concat([df_online_detail, df_alipay_detail, df_bank_detail], axis=0)
    if not len(df):
        return

    df['repay_channel'] = df['repay_channel'].astype(int)
    df['fund_code'] = df['fund_code'].astype(int)

    df = pd.merge(df, df_approach, left_on=['repay_channel'], right_on=['id'], how='left')
    df = pd.merge(df, df_fund, left_on=['fund_code'], right_on=['fund_corp_id'], how='left')

    df.reset_index(inplace=True)
    df = df[['fund_name', 'loan_id', 'contract_term', 'term_no',
             'repaid_at', 'ref_amount', 'real_principle', 'real_interest',
             'real_service_fee', 'real_punish', 'remain_income',
             'order_id', 'approach_name']]

    df.sort_values(by=['loan_id', 'term_no'], inplace=True)

    df.rename(columns={'fund_name': '资金方',
                       'loan_id': '放款id',
                       'contract_term': '放款期数',
                       'term_no': '期数',
                       'repaid_at': '实还款日',
                       'ref_amount': '实还金额',
                       'real_principle': '本金',
                       'real_interest': '利息',
                       'real_service_fee': '服务费',
                       'real_punish': '罚息',
                       'remain_income': '其他收益',
                       'order_id': '渠道流水号',
                       'approach_name': '收款账户'
                       },
              inplace=True)

    df.to_excel(path + str(2017) + '_' + str(fund_code) + '.xlsx',
                columns=df.columns,
                index=None, encoding='utf8')


if __name__ == '__main__':
    # 还款汇总--如果不需要可注释
    # hk_hz()
    # 还款明细
    # pool = mtp.Pool(processes=6)
    years = [2015, 2016]
    months = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
    for fundcode in fundcodes:
        handle_hk(fundcode)
        # pool.apply_async(handle_hk, (year, month))
        # pool.close()
        # pool.join()

print '======================main done==================================='
