# coding: utf-8

# In[4]:


import sys

# 加入父级搜索路径，根据情况修改
sys.path.insert(0, '../..')

# In[2]:


import pandas as pd
import numpy as np
import datetime
import os
from api import db_connect

reload(db_connect)
# 引入数据库连接，并使修改生效
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
engine_audit = db_connect.sql_engine(db_connect.audit, 'temp', False).get_engine()
engine_mzh = db_connect.sql_engine(db_connect.audit, 'test_mzh', False).get_engine()

# In[3]:


today = datetime.datetime.now()
date_str = today.strftime('%Y%m%d')
# 主程序代码所在的路径
base_path = os.getcwd()
# 输出文件路径
file_path = os.path.join(base_path, date_str)
# 临时文件路径
tmp_path = os.path.join(base_path, date_str, 'temp')
if not os.path.exists(file_path):
    os.makedirs(file_path)
if not os.path.exists(tmp_path):
    os.makedirs(tmp_path)

# In[5]:


sql_ref = """
select 
  xjd_ref.id xjd_ref_id,
  urp.ref_id,
  urp.real_loan_id loan_id,
  urp.term_no,
  xjd_ref.plan_id,
  xjd_ref.service_fee real_service_fee,
  xjd_ref.mitigate_service_fee 
from
  temp.xjd_repay_plan_repay_record_ref xjd_ref 
  join temp.user_repayment_plan urp 
    on urp.id = xjd_ref.plan_id ;
"""
sql_new_ms = """
select 
  t1.id ms_trans_id,
  t2.ref_id,
  t1.loan_id,
  t2.id plan_id,
  t1.term_no,
  t1.qg_service_fee 
from
  test_8_2.new_ms_transaction_with_term_details t1 
  join test_8_2.user_repayment_plan t2 
    on t2.real_loan_id = t1.loan_id 
    and t2.term_no = t1.term_no 
    and t2.fund_code = 160 
"""

# In[6]:


step = 10000
df_ref_gen = pd.read_sql(sql=sql_ref, con=engine_audit, chunksize=step)
df_ref = pd.DataFrame()
for tmp in df_ref_gen:
    df_ref = df_ref.append(tmp)
df_ref.to_csv(os.path.join(tmp_path, 'ref.csv'), index=None, encoding='utf8')

df_ms_gen = pd.read_sql(sql=sql_new_ms, con=engine_audit, chunksize=step)
df_ms = pd.DataFrame()
for tmp in df_ms_gen:
    df_ms = df_ms.append(tmp)
df_ms.to_csv(os.path.join(tmp_path, 'ms_trans.csv'), index=None, encoding='utf8')

# In[7]:


df_plan_service_fee = pd.read_csv(os.path.join(tmp_path, 'plan_service_fee.csv'), encoding='utf8')
df_ref = pd.merge(df_ref, df_plan_service_fee, on='plan_id', how='left')
df_ms = pd.merge(df_ms, df_plan_service_fee, on='plan_id', how='left')

# ### 处理ref表数据，区分1和多的情况

# In[8]:


df_ref.real_service_fee = df_ref.real_service_fee - df_ref.mitigate_service_fee
gp = df_ref.groupby(['plan_id'])['xjd_ref_id'].agg(['count']).reset_index()
df_ref_gp = pd.merge(df_ref, gp)
df_ref_gp.head()

# In[9]:


# 处理1
df_ref_1 = df_ref_gp.loc[df_ref_gp['count'] == 1]
df_ref_n = df_ref_gp.loc[df_ref_gp['count'] > 1]
df_ref_1['real_service_fee1'] = np.minimum(df_ref_1.service_fee1, df_ref_1.real_service_fee)
df_ref_1['mitigate_service_fee1'] = np.minimum(df_ref_1.mitigate_service_fee,
                                               (df_ref_1.service_fee1 - df_ref_1.real_service_fee1))
df_ref_1['real_service_fee2'] = df_ref_1['real_service_fee'] - df_ref_1['real_service_fee1']
df_ref_1['mitigate_service_fee2'] = df_ref_1['mitigate_service_fee'] - df_ref_1['mitigate_service_fee1']
df_ref_1.head()

# In[10]:


# 处理n
df_ref_n['real_service_fee1'] = 0
df_ref_n['mitigate_service_fee1'] = 0
df_ref_n['real_service_fee2'] = 0
df_ref_n['mitigate_service_fee2'] = 0
plan_ids = df_ref_n.plan_id.unique()
res = []
for plan_id in plan_ids:
    tmp = df_ref_n.loc[df_ref_n.plan_id == plan_id]
    left_fee1 = round(tmp.service_fee1.values[0], 2)
    for ix, row in tmp.iterrows():
        if left_fee1 > 0:
            row['real_service_fee1'] = round(min(left_fee1, row['real_service_fee']), 2)
            left_fee1 = round(left_fee1 - row['real_service_fee1'], 2)
        res.append(row.to_frame().T)
df_new_ref_n = pd.concat(res)
df_new_ref_n['real_service_fee2'] = df_new_ref_n['real_service_fee'] - df_new_ref_n['real_service_fee1']
res = []
for plan_id in plan_ids:
    tmp = df_new_ref_n.loc[df_new_ref_n.plan_id == plan_id]
    total_fee1 = round(tmp.real_service_fee1.sum(), 2)
    total_fee2 = round(tmp.real_service_fee2.sum(), 2)
    left_mitigate_fee = round(tmp.mitigate_service_fee.sum(), 2)
    for ix, row in tmp.iterrows():
        if round(row['mitigate_service_fee'], 2) == 0:
            res.append(row.to_frame().T)
            continue
        if left_mitigate_fee > 0:
            row['mitigate_service_fee1'] = round(
                min(left_mitigate_fee, row['mitigate_service_fee'], row['service_fee1'] - total_fee1), 2)
            left_mitigate_fee = round(left_mitigate_fee - row['mitigate_service_fee1'], 2)
            row['mitigate_service_fee2'] = round(row['mitigate_service_fee'] - row['mitigate_service_fee1'], 2)
        res.append(row.to_frame().T)
df_new_ref_n = pd.concat(res)
df_new_ref_n = df_new_ref_n[df_ref_n.columns]
df_new_ref_n.head()

# In[12]:


df_new_ref_n.loc[df_new_ref_n.real_service_fee < 0].T

# In[13]:


df_new_ref = pd.concat([df_ref_1, df_new_ref_n])
df_new_ref = df_new_ref[
    ['xjd_ref_id', 'ref_id', 'loan_id', 'term_no', 'plan_id', 'real_service_fee1', 'real_service_fee2',
     'mitigate_service_fee1', 'mitigate_service_fee2']]
df_new_ref.columns = ['xjd_ref_id', 'ref_id', 'loan_id', 'term_no', 'plan_id', 'service_fee1', 'service_fee2',
                      'mitigate_service_fee1', 'mitigate_service_fee2']

# In[14]:


df_new_ref.service_fee1 = np.round(df_new_ref.service_fee1.astype(float), 2)
df_new_ref.service_fee2 = np.round(df_new_ref.service_fee2.astype(float), 2)
df_new_ref.mitigate_service_fee1 = np.round(df_new_ref.mitigate_service_fee1.astype(float), 2)
df_new_ref.mitigate_service_fee2 = np.round(df_new_ref.mitigate_service_fee2.astype(float), 2)
df_new_ref.to_sql('xjd_repay_plan_repay_record_ref_service_fee_0722', con=engine_mzh, chunksize=step,
                  if_exists='append', index=None)

# ### 处理新马上

# In[15]:


df_ms_0 = df_ms.loc[df_ms.qg_service_fee == 0]
df_ms_0['count'] = 1

df_ms_1 = df_ms.loc[df_ms.qg_service_fee > 0]
gp = df_ms_1.groupby(['plan_id'])['ms_trans_id'].agg(['count']).reset_index()
df_ms_gp = pd.merge(df_ms_1, gp)
df_ms_gp.head()

# In[16]:


df_ms_gp_1 = df_ms_gp.loc[df_ms_gp['count'] == 1]
df_ms_gp_n = df_ms_gp.loc[df_ms_gp['count'] > 1]
len(df_ms_gp_1), len(df_ms_gp_n)

# In[17]:


df_ms_gp_1['real_service_fee1'] = np.minimum(df_ms_gp_1['service_fee1'], df_ms_gp_1['qg_service_fee'])
df_ms_gp_1['real_service_fee2'] = df_ms_gp_1['qg_service_fee'] - df_ms_gp_1['real_service_fee1']
df_ms_gp_1.head()

# In[18]:


df_ms_gp_n['real_service_fee1'] = 0
plan_ids = df_ms_gp_n.plan_id.unique()
res = []
for plan_id in plan_ids:
    tmp = df_ms_gp_n.loc[df_ms_gp_n.plan_id == plan_id]
    left_fee1 = tmp.service_fee1.values[0]
    for ix, row in tmp.iterrows():
        if left_fee1 > 0:
            row['real_service_fee1'] = min(left_fee1, row['qg_service_fee'])
            left_fee1 -= row['real_service_fee1']
        res.append(row.to_frame().T)
df_new_ms = pd.concat(res)
df_new_ms['real_service_fee2'] = df_new_ms['qg_service_fee'] - df_new_ms['real_service_fee1']
df_new_ms.head()

# In[19]:


df_ms_all = pd.concat([df_ms_0, df_ms_gp_1, df_new_ms])
df_ms_all.fillna(0, inplace=True)
df_ms_all = df_ms_all[
    ['loan_id', 'ms_trans_id', 'plan_id', 'real_service_fee1', 'real_service_fee2', 'ref_id', 'term_no']]
df_ms_all.columns = ['loan_id', 'ms_trans_id', 'plan_id', 'service_fee1', 'service_fee2', 'ref_id', 'term_no']
df_ms_all.service_fee1 = np.round(df_ms_all.service_fee1, 2)
df_ms_all.service_fee2 = np.round(df_ms_all.service_fee2, 2)
df_ms_all.mitigate_service_fee1 = 0
df_ms_all.mitigate_service_fee2 = 0
df_ms_all.to_sql('new_ms_transaction_with_term_details_service_fee_0722', con=engine_mzh, chunksize=step,
                 if_exists='append', index=None)


# In[ ]:
