# coding: utf-8

# In[1]:


import sys

# 加入父级搜索路径，根据情况修改
sys.path.insert(0, '../..')
import pandas as pd
import numpy as np
import datetime
import os
from api import db_connect
import itertools

reload(db_connect)
# 引入数据库连接，并使修改生效
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
engine_audit = db_connect.sql_engine(db_connect.audit, 'test_mzh', False).get_engine()

# In[2]:


years = [2015, 2016]
months = range(1, 13)
class_type = ['A', 'B', 'C']
combine = itertools.product(years, months, class_type)
res = [item for item in combine]

# In[3]:


df = pd.DataFrame(data=res, columns=['year', 'month', 'class'])
df = df.loc[~((df.year == 2015) & (df.month < 6))]

# In[5]:


# 15年
df.loc[(df.year == 2015) & (df['class'] == 'A'), 'bad_debt_ratio'] = 0.040370634124992
df.loc[(df.year == 2015) & (df['class'] == 'A'), 'service_fee1_ratio'] = 0.84
df.loc[(df.year == 2015) & (df['class'] == 'B'), 'bad_debt_ratio'] = 0.0621883753070925
df.loc[(df.year == 2015) & (df['class'] == 'B'), 'service_fee1_ratio'] = 0.84
df.loc[(df.year == 2015) & (df['class'] == 'C'), 'bad_debt_ratio'] = 0.103526974705417
df.loc[(df.year == 2015) & (df['class'] == 'C'), 'service_fee1_ratio'] = 0.84
# 16年分季度
df.loc[(df.year == 2016) & (df['class'] == 'A') & (df.month >= 0), 'bad_debt_ratio'] = 0.040370634124992
df.loc[(df.year == 2016) & (df['class'] == 'A') & (df.month >= 0), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'A') & (df.month >= 4), 'bad_debt_ratio'] = 0.037791838
df.loc[(df.year == 2016) & (df['class'] == 'A') & (df.month >= 4), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'A') & (df.month >= 7), 'bad_debt_ratio'] = 0.014660154
df.loc[(df.year == 2016) & (df['class'] == 'A') & (df.month >= 7), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'A') & (df.month >= 10), 'bad_debt_ratio'] = 0.01403
df.loc[(df.year == 2016) & (df['class'] == 'A') & (df.month >= 10), 'service_fee1_ratio'] = 0.96

df.loc[(df.year == 2016) & (df['class'] == 'B') & (df.month >= 0), 'bad_debt_ratio'] = 0.0621883753070925
df.loc[(df.year == 2016) & (df['class'] == 'B') & (df.month >= 0), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'B') & (df.month >= 4), 'bad_debt_ratio'] = 0.055696887
df.loc[(df.year == 2016) & (df['class'] == 'B') & (df.month >= 4), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'B') & (df.month >= 7), 'bad_debt_ratio'] = 0.035235262
df.loc[(df.year == 2016) & (df['class'] == 'B') & (df.month >= 7), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'B') & (df.month >= 10), 'bad_debt_ratio'] = 0.0366
df.loc[(df.year == 2016) & (df['class'] == 'B') & (df.month >= 10), 'service_fee1_ratio'] = 0.96

df.loc[(df.year == 2016) & (df['class'] == 'C') & (df.month >= 0), 'bad_debt_ratio'] = 0.103526974705417
df.loc[(df.year == 2016) & (df['class'] == 'C') & (df.month >= 0), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'C') & (df.month >= 4), 'bad_debt_ratio'] = 0.0947627
df.loc[(df.year == 2016) & (df['class'] == 'C') & (df.month >= 4), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'C') & (df.month >= 7), 'bad_debt_ratio'] = 0.06828842
df.loc[(df.year == 2016) & (df['class'] == 'C') & (df.month >= 7), 'service_fee1_ratio'] = 0.96
df.loc[(df.year == 2016) & (df['class'] == 'C') & (df.month >= 10), 'bad_debt_ratio'] = 0.06893
df.loc[(df.year == 2016) & (df['class'] == 'C') & (df.month >= 10), 'service_fee1_ratio'] = 0.96

# #####  复制表结构, `Generate and copy DDL`

# In[6]:


df.to_sql('service_fee_ratio_0722', con=engine_audit, if_exists='append', index=None)


# In[ ]:
