# coding: utf-8

# In[1]:


import sys

# 加入父级搜索路径，根据情况修改
sys.path.insert(0, '../..')
import pandas as pd
import numpy as np
import datetime
import os
from api import db_connect
import re

reload(db_connect)
# 引入数据库连接，并使修改生效
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
engine_audit = db_connect.sql_engine(db_connect.audit, 'test_mzh', False).get_engine()

# In[6]:


monthly_rates_df = pd.read_excel("./service_fee_rate.xlsx", 1)
monthly_rates_df['year'] = monthly_rates_df.apply(lambda aa: int(re.findall(r'\d+', aa[u'年月'])[0]), axis=1)
monthly_rates_df['month'] = monthly_rates_df.apply(lambda aa: int(re.findall(r'\d+', aa[u'年月'])[1]), axis=1)
monthly_rates_df

# In[7]:


bd_ratio = pd.pivot_table(monthly_rates_df[['year', 'month', u'A', u'B', u'C']], values=[u'A', u'B', u'C'],
                          index=['year', 'month'], columns=[]
                          ).sort_index(axis=1).stack()
bd_ratio = bd_ratio.to_frame().reset_index().rename(columns={u'level_2': 'class', 0: 'bad_debt_ratio'})
bd_ratio

# In[9]:


sf1_ratio = monthly_rates_df[['year', 'month', u'A.1', u'B.1', u'C.1']]
sf1_ratio = sf1_ratio.rename(columns={u'A.1': u'A', u'B.1': u'B', u'C.1': u'C'})
sf1_ratio = pd.pivot_table(sf1_ratio, values=[u'A', u'B', u'C'],
                           index=['year', 'month'], columns=[]
                           ).sort_index(axis=1).stack()
sf1_ratio = sf1_ratio.to_frame().reset_index().rename(
    columns={u'level_2': 'class', 0: 'service_fee1_ratio'})
sf1_ratio

# In[10]:


service_fee_ratio_df = pd.merge(bd_ratio, sf1_ratio)
service_fee_ratio_df

# #####  复制表结构, `Generate and copy DDL`

# In[11]:


service_fee_ratio_df.to_sql('service_fee_ratio_0721', con=engine_audit, if_exists='append', index=None)
