# -*- coding: utf-8 -*-
import datetime
import sys
import multiprocessing as mtp
from itertools import product
import numpy as np
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta

reload(sys)
sys.setdefaultencoding('utf8')

'''
目标：根据时间点，以 订单为维度，计算未还本金  即 放款本金 - 已还本金
@author linfang
脚本失败原因：如果你修改了数据源，可能是 sql 中涉及到的表不存在该数据源指定的库下，加上指定的库即可
脚本中放款+还款数据都是成功订单 即（is_active=1）,如果金额有差异，有可能是 失败订单有还款。。。。
注意：订单统一为成功订单（is_active = 1）
'''

# ----------------配置变量项开始--------------------------

# TODO 文件输出路劲
path = '/Users/xujiazhe/Desktop/data/'
# 输出文件名
file_name = u'未还本金_2016'
# TODO 还款时间开始 --- 还款时间结束
start_time = '2016-01-01 00:00:00'
end_time = '2017-01-01 00:00:00'

# TODO  放款时间开始 --- 放款时间结束
fk_start_time = '2016-01-01 00:00:00'
fk_end_time = '2017-01-01 00:00:00'

# TODO 数据源
engine_new_transaction = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/new_transaction?charset=utf8',
    echo=True)
# ----------------配置变量项结束--------------------------




read_merchant_sql = '''SELECT merchant_id,merchant_name FROM baitiao_audit.merchant'''
df_merchant = pd.read_sql(read_merchant_sql, con=engine_new_transaction)
df_merchant['merchant_id'] = df_merchant['merchant_id'].astype(int)
read_repay_sql = '''
  SELECT id,`approach_name` FROM new_transaction.`repay_channel`
'''
df_approach = pd.read_sql(read_repay_sql, engine_new_transaction)
df_approach['id'] = df_approach['id'].astype(int)

read_fund_sql = '''
  SELECT id,fund_name FROM baitiao_audit.`fund_corp`
'''
df_fund = pd.read_sql(read_fund_sql, engine_new_transaction)
df_fund['id'] = df_fund['id'].astype(int)


def fk(start_time, end_time):
    sql_1 = '''    
      SELECT
        bt_o.ref_id,
        bt_o.funding_corp_id,
        bt_o.`merchantId`,
        bt_o.`order_no`,
        bt_o.`real_loan_amount`,
        bt_o.`contract_term`,
        bt_o.`loan_paid_at`
      FROM baitiao_audit.`baitiao_order` bt_o
      WHERE bt_o.real_loan_amount > 0 AND bt_o.`is_active` = 1 AND bt_o.loan_paid_at >= '%s' and
            bt_o.loan_paid_at < '%s'
    ''' % (start_time, end_time)
    return pd.read_sql(sql_1, engine_new_transaction)


def hk(start_time, end_time):
    sql_2_1 = '''    
      SELECT
        ubrp.ref_id,
        SUM(bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) real_principle
      FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
        JOIN `offline_alipay_record` oar
          ON bt_rp_rrr.`record_id` = oar.id AND bt_rp_rrr.`repay_channel` = 13
        JOIN `user_bt_repayment_plan` ubrp
          ON bt_rp_rrr.plan_id = ubrp.id
        JOIN baitiao_audit.`baitiao_order` bt_o
          ON ubrp.ref_id = bt_o.ref_id AND bt_o.`is_active` = 1
      WHERE oar.transfer_time >= '%s' and oar.transfer_time < '%s'
      GROUP BY ubrp.ref_id
    ''' % (start_time, end_time)

    sql_2_2 = '''    
      SELECT
        ubrp.ref_id,
        SUM(bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) real_principle
      FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
        JOIN `repay_record_online` rro
          ON bt_rp_rrr.`record_id` = rro.id AND bt_rp_rrr.`repay_channel` < 13
        JOIN `user_bt_repayment_plan` ubrp
          ON bt_rp_rrr.plan_id = ubrp.id
        JOIN baitiao_audit.`baitiao_order` bt_o
          ON ubrp.ref_id = bt_o.ref_id AND bt_o.`is_active` = 1
      WHERE rro.bill_time >= '%s' and rro.bill_time < '%s'
      GROUP BY ubrp.ref_id
    ''' % (start_time, end_time)

    sql_2_3 = '''    
      SELECT
        ubrp.ref_id,
        SUM(bt_rp_rrr.principle - bt_rp_rrr.mitigate_principle) real_principle
      FROM `baitiao_repay_plan_repay_record_ref` bt_rp_rrr
        JOIN `offline_bank_repay_record` obrr
          ON bt_rp_rrr.`record_id` = obrr.id AND bt_rp_rrr.`repay_channel` in (14, 15, 16)
        JOIN `user_bt_repayment_plan` ubrp
          ON bt_rp_rrr.plan_id = ubrp.id
        JOIN baitiao_audit.`baitiao_order` bt_o
          ON ubrp.ref_id = bt_o.ref_id AND bt_o.`is_active` = 1
      WHERE obrr.transfer_time >= '%s' and obrr.transfer_time < '%s'
      GROUP BY ubrp.ref_id
    ''' % (start_time, end_time)

    df_2_1 = pd.read_sql(sql_2_1, engine_new_transaction)
    df_2_2 = pd.read_sql(sql_2_2, engine_new_transaction)
    df_2_3 = pd.read_sql(sql_2_3, engine_new_transaction)
    return pd.concat([df_2_1, df_2_2, df_2_3], axis=0, ignore_index=True)


def tj(df_fk, df_hk, filename):
    df_2 = df_hk.groupby(by='ref_id')['real_principle'].agg({'sum'}).reset_index().rename(
        columns={'sum': 'principle_sum'})
    df_2['ref_id'] = df_2['ref_id'].astype(int)
    df_fk['ref_id'] = df_fk['ref_id'].astype(int)
    df = pd.merge(df_fk, df_2, on='ref_id', how='left')
    df.fillna(0, inplace=True)
    df['diff'] = np.round(df['real_loan_amount'] - df['principle_sum'], 2)
    df = df.ix[df['diff'] != 0]
    df['merchantId'] = df['merchantId'].astype(int)
    df['funding_corp_id'] = df['funding_corp_id'].astype(int)
    df = pd.merge(df, df_merchant, left_on=['merchantId'], right_on='merchant_id', how='left')
    df = pd.merge(df, df_fund, left_on='funding_corp_id', right_on='id', how='left')
    df.rename(columns={'merchant_name': '商户', 'fund_name': '资金方', 'order_no': '订单号', 'real_loan_amount': '订单金额',
                       'contract_term': '合同期数',
                       'loan_paid_at': '放款时间', 'diff': '未还本金'}, inplace=True)
    df = df[['资金方', '商户', '订单号', '订单金额', '合同期数', '放款时间', '未还本金']]
    df.to_excel(path + filename + '.xlsx', columns=df.columns, index=None, encoding='utf8')


if __name__ == '__main__':
    pool = mtp.Pool(processes=2)
    df_fk = pool.apply_async(fk, (fk_start_time, fk_end_time))
    df_hk = pool.apply_async(hk, (start_time, end_time))
    pool.close()
    pool.join()
    tj(df_fk._value, df_hk._value, file_name)

print '======================main done==================================='
