# coding: utf-8
import sys
import pandas as pd
import numpy as np
from sqlalchemy import create_engine
import pyexcelerate
max_limit = 800000

stdout = sys.stdout

sys.stdout = stdout
# 引入数据库连接，并使修改生效
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
mysql_engine = create_engine(
	'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.4.60:3306/new_transaction?charset=utf8', echo=True)
# 获取当前时间，用于创建文件路径，分类存储文件

start_time = '2017-10-01'
end_time = '2017-11-01'
out_file_path = u'E:/审计出表/11月份开始使用表数据/11月份白条出表/'

sql_baoli = """
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(ubrp.deadline)                               应还日期,
  ubrp.principle                                    应还本金,
  0.0                                               应还利息
FROM baitiao_repay_plan_repay_record_ref brprrr
JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel AND rr.repaid_at >= '%s' AND rr.repaid_at < '%s'
JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id   AND bo.is_active IN(1,-2,0)
JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id AND bo.funding_corp_id=1
JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
"""
sql_zhitou = """
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(bfrp.deadline)                               应还日期,
  bfrp.principal                                    应还本金,
  bfrp.interest                                     应还利息
FROM baitiao_repay_plan_repay_record_ref brprrr
JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel AND rr.repaid_at >= '%s' AND rr.repaid_at < '%s'
JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
JOIN bt_funding_repayment_plan bfrp ON ubrp.repayment_plan_id =bfrp.repay_plan_id AND ubrp.sys_tag='XYQB_BILL_BT'
JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id AND bo.funding_corp_id=5   AND bo.is_active IN(1,-2)
JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
"""
sql_zhitou_tuikuan = """
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(ubrp.deadline)                               应还日期,
  ubrp.principle                                    应还本金,
  0.0                                               应还利息
FROM baitiao_repay_plan_repay_record_ref brprrr
JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel AND rr.repaid_at >= '%s' AND rr.repaid_at < '%s'
JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id   AND bo.is_active=-2
JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id AND bo.funding_corp_id=5
JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
"""

df_bl = pd.read_sql(sql_baoli % (start_time, end_time), con=mysql_engine)
df_zt = pd.read_sql(sql_zhitou % (start_time, end_time), con=mysql_engine)
# 直投白条线下退款
df_zt_tk = pd.read_sql(sql_zhitou_tuikuan % (start_time, end_time), con=mysql_engine)
df = pd.concat([df_bl, df_zt, df_zt_tk], ignore_index=True)
sql_cash_repay = """
SELECT
  bo.order_no 唯一编号,
  m.merchant_name           商户名称,
  bo.order_no               产品编号,
  fc.fund_name              资金方,
  bo.contract_term          放款期数,
  1                         当前期数,
  date(rra.repaid_at)       实还时间,
  bcrr.ref_amount           还款总额,
  bcrr.ref_amount           实还本金,
  0                         实还利息,
  0                         实还服务费,
  0                         实还罚息,
  0                         其他收益,
  rra.repay_channel_flow_id 流水号,
  rc.approach_name          还款账户,
  rra.amount                账单金额,
  ''                        应还日期,
  bo.real_loan_amount       应还本金,
  0.0                       应还利息
FROM new_transaction.baitiao_cash_repay bcr
  JOIN (SELECT repay_id,record_id,repay_channel,sum(ref_amount)ref_amount FROM new_transaction.baitiao_cash_record_ref GROUP BY 1,2) bcrr ON bcrr.repay_id = bcr.id
  JOIN test_mzh.repay_record_amount rra ON rra.record_id = bcrr.record_id AND rra.amount=bcrr.ref_amount AND  bcrr.repay_channel IN(18,24) AND rra.repaid_at >= '%s' AND rra.repaid_at < '%s'
  JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.is_active IN(1,-2)
  JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = bcrr.repay_channel;
"""
df_cash_repay = pd.read_sql(sql=sql_cash_repay % (start_time, end_time), con=mysql_engine)
tmp = df.append(df_cash_repay)
tmp.loc[tmp[u'唯一编号'].duplicated(), [u'应还本金', u'应还利息']] = 0
tmp.loc[tmp[[u'流水号', u'还款账户']].duplicated(), [u'账单金额']] = 0
tmp[u'应还本息-实还本息'] = np.round(tmp[u'应还本金'] - tmp[u'实还本金'] + tmp[u'应还利息'] - tmp[u'实还利息'], 2)
tmp[u'还款总额-账单金额'] = np.round(tmp[u'还款总额'] - tmp[u'账单金额'], 2)

date_range = pd.date_range(start=start_time, end=end_time, freq='MS')
cnt = 0
for i in xrange(0, len(date_range) - 1):
	tmp = df.loc[(df[u'实还时间'] >= date_range[i].date()) & (df[u'实还时间'] < date_range[i + 1].date())]
	cnt += len(tmp)
	cash_tmp = df_cash_repay.loc[
		(df_cash_repay[u'实还时间'] >= date_range[i].date()) & (df_cash_repay[u'实还时间'] < date_range[i + 1].date())]
	if len(cash_tmp) > 0:
		tmp = tmp.append(cash_tmp)
	print date_range[i].year, date_range[i].month, len(tmp), tmp[u'还款总额'].sum()
	tmp.loc[tmp[u'唯一编号'].duplicated(), [u'应还本金', u'应还利息']] = 0
	tmp.loc[tmp[[u'流水号', u'还款账户']].duplicated(), [u'账单金额']] = 0
	tmp[u'应还本息-实还本息'] = np.round(tmp[u'应还本金'] - tmp[u'实还本金'] + tmp[u'应还利息'] - tmp[u'实还利息'], 2)
	tmp[u'还款总额-账单金额'] = np.round(tmp[u'还款总额'] - tmp[u'账单金额'], 2)
	tmp = tmp[
		[u'唯一编号', u'商户名称', u'产品编号', u'资金方', u'放款期数', u'当前期数', u'实还时间', u'还款总额', u'实还本金', u'实还利息', u'实还服务费', u'实还罚息',
		 u'其他收益', u'流水号', u'还款账户', u'账单金额', u'应还日期', u'应还本金', u'应还利息', u'应还本息-实还本息', u'还款总额-账单金额']]

	tmp.to_csv(out_file_path + u'人工控制-普通白条-客户实还表(按还款时间)(%s-%02d).csv' % (date_range[i].year, date_range[i].month),
			   index=None, encoding='utf8')

	all_wb = pyexcelerate.Workbook()
	for i in xrange(0, len(tmp), max_limit):
		temp = tmp[i:i + max_limit]
		temp_list = temp.values.tolist()
		temp_list.insert(0, temp.columns.tolist())
		all_wb.new_sheet(str(int(i / max_limit + 1)), data=temp_list)
	all_wb.save(out_file_path + u'人工控制-普通白条-客户实还表(按还款时间)(%s-%02d).xlsx' % (date_range[i].year, date_range[i].month))

print cnt, len(df)

loan_baoli = """
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(ubrp.deadline)                               应还日期,
  ubrp.principle                                    应还本金,
  0.0                                               应还利息,
  date(bo.loan_paid_at)                             放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id AND bo.is_active=1 AND bo.funding_corp_id=1 AND bo.loan_paid_at >= '%s' AND bo.loan_paid_at < '%s'
  JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel

UNION ALL

SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0                                                 实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(ubrp.deadline)                               应还日期,
  ubrp.principle                                    应还本金,
  0                                                 应还利息,
  date(bo.train_cancel_at)                          放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id  AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id AND bo.is_active = -2 AND bo.funding_corp_id=1 AND bo.train_cancel_at >= '%s' AND bo.train_cancel_at < '%s'
  JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
"""
loan_zhitou = """
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0.0                                               实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(bfrp.deadline)                               应还日期,
  bfrp.principal                                    应还本金,
  bfrp.interest                                     应还利息,
  date(bo.loan_paid_at)                             放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr
    ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  JOIN bt_funding_repayment_plan bfrp ON ubrp.repayment_plan_id =bfrp.repay_plan_id AND ubrp.sys_tag='XYQB_BILL_BT'
  JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id AND bo.is_active=1 AND bo.funding_corp_id=5 AND bo.loan_paid_at >= '%s' AND bo.loan_paid_at < '%s'
  JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
  UNION ALL
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0                                                 实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(bfrp.deadline)                               应还日期,
  bfrp.principal                                    应还本金,
  bfrp.interest                                     应还利息,
  date(bo.train_cancel_at)                          放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  JOIN bt_funding_repayment_plan bfrp ON ubrp.repayment_plan_id =bfrp.repay_plan_id AND ubrp.sys_tag='XYQB_BILL_BT'
  JOIN baitiao_audit.baitiao_order bo  ON bo.ref_id = ubrp.ref_id AND bo.is_active = -2 AND bo.funding_corp_id=5 AND bo.train_cancel_at >= '%s' AND bo.train_cancel_at < '%s'
  JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
"""
#  直投线下退款
loan_zhitou_apli = """
SELECT
  concat(bo.order_no, ubrp.term_no)                 唯一编号,
  m.merchant_name                                   商户名称,
  bo.order_no                                       产品编号,
  fc.fund_name                                      资金方,
  bo.contract_term                                  放款期数,
  ubrp.term_no                                      当前期数,
  date(rr.repaid_at)                                实还时间,
  brprrr.ref_amount                                 还款总额,
  brprrr.principle - brprrr.mitigate_principle      实还本金,
  0                                                 实还利息,
  brprrr.interest - brprrr.mitigate_interest        实还服务费,
  brprrr.punish - brprrr.mitigate_collection_relief 实还罚息,
  brprrr.remain_income                              其他收益,
  rr.repay_channel_flow_id                          流水号,
  rc.approach_name                                  还款账户,
  rr.amount                                         账单金额,
  date(ubrp.deadline)                               应还日期,
  ubrp.principle                                    应还本金,
  0                                                 应还利息,
  date(bo.train_cancel_at)                          放款日期
FROM baitiao_repay_plan_repay_record_ref brprrr
  JOIN test_mzh.repay_record_amount rr ON rr.record_id = brprrr.record_id  AND rr.repay_channel = brprrr.repay_channel
  JOIN user_bt_repayment_plan ubrp ON ubrp.id = brprrr.plan_id
  JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = ubrp.ref_id AND bo.is_active = -2 AND bo.funding_corp_id=5 AND bo.train_cancel_at >= '%s' AND bo.train_cancel_at < '%s'
  JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = brprrr.repay_channel
"""
df_bl = pd.read_sql(loan_baoli % (start_time, end_time, start_time, end_time), con=mysql_engine)
df_zt = pd.read_sql(loan_zhitou % (start_time, end_time, start_time, end_time), con=mysql_engine)
df_zt_apli = pd.read_sql(loan_zhitou_apli % (start_time, end_time), con=mysql_engine)
df_loan_repay = pd.concat([df_bl, df_zt, df_zt_apli], ignore_index=True)
sql_cash_loan_repay = """
SELECT
  bo.order_no 唯一编号,
  m.merchant_name           商户名称,
  bo.order_no               产品编号,
  fc.fund_name              资金方,
  bo.contract_term          放款期数,
  1                         当前期数,
  date(rra.repaid_at)       实还时间,
  bcrr.ref_amount           还款总额,
  bcrr.ref_amount           实还本金,
  0                         实还利息,
  0                         实还服务费,
  0                         实还罚息,
  0                         其他收益,
  rra.repay_channel_flow_id 流水号,
  rc.approach_name          还款账户,
  rra.amount                账单金额,
  ''                        应还日期,
  bo.real_loan_amount       应还本金,
  0                         应还利息,
  date(bo.train_cancel_at)  放款日期
FROM baitiao_cash_record_ref bcrr
  JOIN baitiao_cash_repay bcr ON bcrr.repay_id = bcr.id
  JOIN test_mzh.repay_record_amount rra ON rra.record_id = bcrr.record_id  AND rra.repay_channel IN(18,24) -- AND rra.repay_channel = bcrr.repay_channel
  JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.is_active = -2 AND bo.train_cancel_at >= '%s' AND bo.train_cancel_at < '%s'
  JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = bcrr.repay_channel
UNION ALL
SELECT
  bo.order_no               唯一编号,
  m.merchant_name           商户名称,
  bo.order_no               产品编号,
  fc.fund_name              资金方,
  bo.contract_term          放款期数,
  1                         当前期数,
  date(rra.repaid_at)       实还时间,
  bcrr.ref_amount           还款总额,
  bcrr.ref_amount           实还本金,
  0                         实还利息,
  0                         实还服务费,
  0                         实还罚息,
  0                         其他收益,
  rra.repay_channel_flow_id 流水号,
  rc.approach_name          还款账户,
  rra.amount                账单金额,
  ''                        应还日期,
  bo.real_loan_amount       应还本金,
  0                         应还利息,
  date(bo.loan_paid_at)     放款日期
FROM baitiao_cash_record_ref bcrr
  JOIN baitiao_cash_repay bcr ON bcrr.repay_id = bcr.id
  JOIN test_mzh.repay_record_amount rra ON rra.record_id = bcrr.record_id AND rra.amount=bcrr.ref_amount AND rra.repay_channel IN(18,24)  -- AND rra.repay_channel = bcrr.repay_channel
  JOIN baitiao_audit.baitiao_order bo ON bo.ref_id = bcr.ref_id AND bo.is_active <> -2 AND bo.loan_paid_at >= '%s' AND bo.loan_paid_at < '%s'
  JOIN baitiao_audit.merchant m ON m.merchant_id = bo.merchantId
  JOIN baitiao_audit.fund_corp fc ON fc.id = bo.funding_corp_id
  JOIN new_transaction.repay_channel rc ON rc.id = bcrr.repay_channel;
"""
df_cash_loan_repay = pd.read_sql(sql=sql_cash_loan_repay % (start_time, end_time, start_time, end_time),
								 con=mysql_engine)
date_range = pd.date_range(start=start_time, end=end_time, freq='MS')
cnt = 0
for i in xrange(0, len(date_range) - 1):
	tmp = df_loan_repay.loc[
		(df_loan_repay[u'放款日期'] >= date_range[i].date()) & (df_loan_repay[u'放款日期'] < date_range[i + 1].date())]
	cash_tmp = df_cash_loan_repay.loc[(df_cash_loan_repay[u'放款日期'] >= date_range[i].date()) & (
	df_cash_loan_repay[u'放款日期'] < date_range[i + 1].date())]
	if len(cash_tmp) > 0:
		tmp = tmp.append(cash_tmp)
	del tmp[u'放款日期']
	cnt += len(tmp)
	tmp.loc[tmp[[u'唯一编号']].duplicated(), [u'应还本金']] = 0
	tmp.loc[tmp[[u'流水号', u'还款账户', u'账单金额']].duplicated(), [u'账单金额']] = 0
	print date_range[i].year, date_range[i].month, len(tmp), tmp[u'应还本金'].sum()
	tmp[u'应还本息-实还本息'] = np.round(tmp[u'应还本金'] - tmp[u'实还本金'] + tmp[u'应还利息'] - tmp[u'实还利息'], 2)
	tmp[u'还款总额-账单金额'] = np.round(tmp[u'还款总额'] - tmp[u'账单金额'], 2)
	tmp = tmp[
		[u'唯一编号', u'商户名称', u'产品编号', u'资金方', u'放款期数', u'当前期数', u'实还时间', u'还款总额', u'实还本金', u'实还利息', u'实还服务费', u'实还罚息',
		 u'其他收益', u'流水号', u'还款账户', u'账单金额', u'应还日期', u'应还本金', u'应还利息', u'应还本息-实还本息', u'还款总额-账单金额']]
	tmp.to_csv(out_file_path + u'人工控制-普通白条-客户实还表(按放款时间)(%s-%02d).csv' % (date_range[i].year, date_range[i].month),
			   index=None, encoding='gbk')

	all_wb = pyexcelerate.Workbook()
	for i in xrange(0, len(tmp), max_limit):
		temp = tmp[i:i + max_limit]
		temp_list = temp.values.tolist()
		temp_list.insert(0, temp.columns.tolist())
		all_wb.new_sheet(str(int(i / max_limit + 1)), data=temp_list)
	all_wb.save(out_file_path + u'人工控制-普通白条-客户实还表(按放款时间)(%s-%02d).xlsx' % (date_range[i].year, date_range[i].month))

# tmp.to_excel(os.path.join(file_path, '客户实还表（放款时间%s-%02d）.xlsx' % (date_range[i].year, date_range[i].month)), index=None)
print cnt, len(df_loan_repay)