# -*- encoding: utf8 -*-

import logging
import pandas as pd
from sqlalchemy import create_engine
import numpy as np

logging.basicConfig(level=logging.INFO,
                    format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                    datefmt='%a, %d %b %Y %H:%M:%S',
                    filename='log_update_repayment.log',
                    filemode='a+')
logging.getLogger('sqlalchemy.engine').setLevel(logging.INFO)
formatter = logging.Formatter('%(name)-12s: %(levelname)-8s %(message)s')
console = logging.StreamHandler()
console.setFormatter(formatter)
logging.getLogger('sqlalchemy.engine').addHandler(console)

engine_audit = create_engine('mysql+mysqldb://bo.wang:#mn89453YU9io80@172.16.3.201:3306/new_transaction?charset=utf8',
                             echo=True)

'''
注意：1、更新完后，需要校验拆分正确否；
2、注意是否有未使用的红包，如果有，则检查原因
3、如果红包确实不使用，则需要删除 red_packet_detail 中 对应的未使用的红包，注意是该笔有还款且还款状态完成；如果有还款状态未还款，但是有红包，询问审计或财务或玉龙如何处理
'''

# sql_1='''
# select sum(ref_amount) repay_amount,plan_id from xjd_repay_plan_repay_record_ref  where plan_id IN (
# SELECT t2.id  FROM red_packet_detail t1 LEFT JOIN user_repayment_plan t2 ON t1.ref_id=t2.ref_id AND t1.term_no=t2.term_no WHERE xyqb_repaid_at>="2017-06-01" AND xyqb_repaid_at<"2017-07-01"
# ) group by plan_id
# '''
# AND t2.current_repayment = 0
sql_plan_ref = """
SELECT
	sum(ref_amount) repay_amount,
	plan_id
FROM
	xjd_repay_plan_repay_record_ref t1
JOIN user_repayment_plan t2 ON t1.plan_id = t2.id
WHERE

t2.xyqb_repaid_at >= "2017-10-01"
AND t2.xyqb_repaid_at < "2017-11-10"
AND t2.repay_status = 3
GROUP BY
	t1.plan_id
"""
#
# sql_1 = """
#
# SELECT
#  	sum(ref_amount) repay_amount,
#  	plan_id
# FROM
# 	user_repayment_plan t1
# JOIN xjd_repay_plan_repay_record_ref t2 ON t1.id = t2.plan_id
# WHERE
# 	xyqb_repaid_at > "2017-06-01"
# AND xyqb_repaid_at < "2017-07-01"
# AND repay_status = 3
# AND current_repayment = 0
# AND t2.repay_channel in (13)
# GROUP BY
# 	t2.plan_id
# """

# sql_1 = '''
# select sum(ref_amount) repay_amount,plan_id from xjd_repay_plan_repay_record_ref  where plan_id IN (
# SELECT t2.id plan_id FROM red_packet_detail t1 LEFT JOIN user_repayment_plan t2 ON t1.ref_id=t2.ref_id AND t1.term_no=t2.term_no WHERE xyqb_repaid_at>="2017-06-01" AND xyqb_repaid_at<"2017-07-10"
# ) group by plan_id
# '''
# 89647
# 9892093
sql_plan_ref='''
select sum(ref_amount) repay_amount,plan_id from xjd_repay_plan_repay_record_ref  where plan_id in (17939003,18001511,17999693,19348913,17992793,17992907,17990615,17939735,17995541,17917967,17996099,13183085,17818535,14951401,16775621,16793909,18538103,15048301,17317973,16862699,16779713,16947229,16853759,16723967,17356583,16960183,16647695,20435587,16023121,14459209,16135315,18239129,15815947,18478739,18481649) GROUP BY plan_id
'''
# (4775015,13699135,4864585,10403491,14023021,10832639,12008815,10853291,4301879,13287685,11573917,4779607,13742293,10365019,11553475,14580895,12916795,13911511,8994139,11487055,11817439,15644719,4247083,10332679,15760377,11571775,13895353,11606641,15754995,11561665,15606439,13014299,13807459,10282111,12515395,4780291,13902949,4761541,10559023,14415019,10959971,10745407,9378703,14444797,15615711,11220653,13920001,13545217,4683485,10769671,14287729,15828507,9069751,14755609,16963339,10735015,11533387,15840135,12034657,15721821,14555149,14144305,10868297,13308733,14156563,15736779,15742785,14163055,10768735,15735681,10857341,12266897,13606735,11571493,15742479,6206467,14147245,9038713,13380133,15737133,16187587,9077323,17104759,16156489,4843837,16164091,13381843,13379551,13383283,16211215,9112873,13383301,13382461,11043875,8973289,14035141,11016569,10369021,10984583,10655257,12855109,15657103,6206851,11364493,15080977,15628705,13634233,11060357,16474093,14008321,10712905,15617629,10511893,13267477,13839097,13588795,13311103,15749865,15727101,15747999,13909609,14003449,10755181,13932175,13585117,15739185,10731211,13038637,15655039,15760299,15101515,10637431,17040421,9358441,16983085,9125593,15736347,18349033,11246465,15835545,12989767,15613143,16891159,10730821,11557201,15835221,18337705,11456947,18332905,18330301,11657689,15560943,15840597,9078805,11428417,18336817,18319051,18329899,16242301,18330175,18328963,11230439,9080923,11510455,11507503,18327277,13961989,15339693,15338487,15333801,14600089,14599243,14585713,14519131,11649391,14583841,11740909,11759611,14581057,14581435,11852725,11749825,11792365,14477329,11829133,17987269,9207991,11765539,9179101,11742745,15844209,15942117,15863913,15864495,15868065,15923661,14478625,15919335,14528929,11727331,15869787,15866655,11835961,11788261,14528851,15917187,15869685,14526817,14464321,15870609,15862899,14484025,15841887,14583295,11813413,12046555,14344813,14339473,11942425,11953711,12013771,12059689,14163529,14425939,14401057,14394619,14400925,14395297,14381095,11858641,14448967,14392471,14388925,14434507,14451847,11994727,14462455,10247353,14165653,12096001,14436001,14452903,14435929,14300245,11989483,14375929,11941081,14395837,14402641,14394949,12028513,12092737,12077305,14387665,14374897,14254213,14380267,14374801,12056881,12016279,16039467,15991737,16065501,14318995,12022261,16056645,14318845,16044039,14312893,10091581,16051917,16038549,14319841,11924791,16040697,16046283,14445013,11902843,14390497,14163811,16030701,14449345,15970761,11880889,14127847,15785175,14135347,14120623,14123209,15796251,15784791,15792123,12153235,12099055,12112669,14207431,14190289,14184163,18368707,18382999,18369991,18379243,18364357,18320899,18368389,18370969,18367063,18370237,18373267,18382483)
# (17939003,18001511,17999693,19348913,17992793,17992907,17990615,17939735,17995541,17917967,17996099,13183085,17818535,14951401,16775621,16793909,18538103,15048301,17317973,16862699,16779713,16947229,16853759,16723967,17356583,16960183,16647695,20435587,16023121,14459209,16135315,18239129,15815947,18478739,18481649)


sql_user_plan = """select id plan_id,ref_id,term_no, principle, interest, service_fee, should_punish,repay_status from user_repayment_plan where id in %s """

sql_red_package = '''
select ref_id,term_no,amount red_amount from red_packet_detail where ref_id in %s
'''

sql_update = """update user_repayment_plan set real_principle = %s, real_interest = %s, real_service_fee = %s, \
 real_punish = %s, current_repayment = %s, collection_relief = %s, remain = %s, repay_msg = %s,red_package = %s,mitigate_all=%s where id = %s;"""


def cal_msg(x):
    repay_amount = x['repay_amount']
    principle = x['principle']
    interest = x['interest']
    service_fee = x['service_fee']
    should_punish = x['should_punish']
    res_msg = ''
    remain = repay_amount - principle
    remain = round(remain, 2)
    if remain < 0:
        res_msg += '减免本金%s元' % (-remain,)
        if interest > 0:
            res_msg += '，减免利息%s元' % (interest,)
        if service_fee > 0:
            res_msg += '，减免服务费%s元' % (service_fee,)
        if should_punish > 0:
            res_msg += '，减免罚息%s元' % (should_punish,)
        return res_msg + '。'
    remain -= interest
    remain = round(remain, 2)
    if remain < 0:
        res_msg += '减免利息%s元' % (-remain,)
        if service_fee > 0:
            res_msg += '，减免服务费%s元' % (service_fee,)
        if should_punish > 0:
            res_msg += '，减免罚息%s元' % (should_punish,)
        return res_msg + '。'
    remain -= service_fee
    remain = round(remain, 2)
    if remain < 0:
        res_msg += '减免服务费%s元' % (-remain,)
        if should_punish > 0:
            res_msg += '，减免罚息%s元' % (should_punish,)
        return res_msg + '。'
    remain -= should_punish
    remain = round(remain, 2)
    if remain < 0:
        return '减免罚息%s元。' % -remain
    return ''


step = 5000
df1_gen = pd.read_sql(sql=sql_plan_ref, con=engine_audit, chunksize=step)
i = 0
for df1 in df1_gen:
    logging.info('-----------------------------> i: %s <--------------------------' % i)
    i += 1
    logging.info('----------------------------> len(df1): %s  <------------------------------' % len(df1))
    ids = df1['plan_id'].astype(str).tolist()
    df2 = pd.read_sql(sql=sql_user_plan % str(tuple(ids)).replace(',)', ')'), con=engine_audit)
    ref_ids = df2.ref_id.astype(str).tolist()
    df3 = pd.read_sql(sql_red_package % str(tuple(ref_ids)).replace(',)', ')'), engine_audit)
    df2['ref_id'] = df2['ref_id'].astype(int)
    df2['term_no'] = df2['term_no'].astype(int)
    df3['ref_id'] = df3['ref_id'].astype(int)
    df3['term_no'] = df3['term_no'].astype(int)

    df = pd.merge(df1, df2, on='plan_id')
    df = pd.merge(df, df3, on=['ref_id', 'term_no'], how='left')
    df.fillna(0, inplace=True)
    df['repay_amount'] = df['repay_amount'].apply(lambda x: round(x, 2))
    df['principle'] = df['principle'].apply(lambda x: round(x, 2))
    df['interest'] = df['interest'].apply(lambda x: round(x, 2))
    df['service_fee'] = df['service_fee'].apply(lambda x: round(x, 2))
    df['should_punish'] = df['should_punish'].apply(lambda x: np.round(x, 2))
    df['red_package_fee'] = df['red_amount'].apply(lambda x: round(x, 2))
    df.repay_status = df.repay_status.astype(int)
    # repay_status == 3 可以做减免，其他的状态不进行减免
    df.ix[df.repay_status != 3, 'principle'] = df.ix[df.repay_status != 3].apply(
        lambda x: min(x.repay_amount, x.principle), axis=1)
    df.ix[df.repay_status != 3, 'interest'] = df.ix[df.repay_status != 3].apply(
        lambda x: min(x.interest, round(x.repay_amount - x.principle, 2)), axis=1)
    df.ix[df.repay_status != 3, 'service_fee'] = df.ix[df.repay_status != 3].apply(
        lambda x: min(x.service_fee, round(x.repay_amount - x.principle - x.interest, 2)), axis=1)
    df.ix[df.repay_status != 3, 'should_punish'] = df.ix[df.repay_status != 3].apply(
        lambda x: min(x.should_punish, round(x.repay_amount - x.principle - x.interest - x.service_fee, 2)), axis=1)
    # 非还款完成状态不使用红包
    df.ix[df.repay_status != 3, 'red_package_fee'] = 0


    df['remain'] = df['repay_amount'] - df['principle'] - df['interest'] - df['service_fee'] - df['should_punish']
    df['remain'] = df['remain'].apply(lambda x: round(x, 2))

    # remain 小于零 变成减免
    df['msg'] = df.apply(lambda x: cal_msg(x), axis=1)
    df['collection_relife'] = 0
    df.loc[df['remain'] < 0, 'collection_relife'] = -df.loc[df['remain'] < 0, 'remain']
    df.loc[df['remain'] <= 0, 'remain'] = 0
    # 如果有减免 < 红包，不使用红包 collection_relife是总减免
    df.ix[(df.repay_status == 3) & (df.collection_relife < df.red_package_fee),'red_package_fee'] = 0

    # mitigate_all是催收减免
    df['mitigate_all'] = np.round(df['collection_relife'] - df['red_package_fee'], 2)
    df_list = df[
        ['principle', 'interest', 'service_fee', 'should_punish', 'repay_amount', 'collection_relife', 'remain', 'msg',
         'red_package_fee', 'mitigate_all', 'plan_id']].values.tolist()
    logging.info('----------------------------> len(df_list): %s  <------------------------------' % len(df_list))
    engine_audit.execute(sql_update, df_list)

print '-------------------------------------------done-----------------------------------'
