# -*- coding: utf-8 -*-
import sys
import datetime
import itertools
import pandas as pd
from sqlalchemy import create_engine
import multiprocessing as mtp

reload(sys)
sys.setdefaultencoding('utf8')

engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/all_back_0531?charset=utf8',
    echo=True)
sql_fund = '''
select id fund_code,name fund_name from new_transaction.funding_corp
'''
df_fund = pd.read_sql(sql_fund, con=engine_new_transaction)
df_fund.fund_code = df_fund.fund_code.astype(int)

# 客户应还金额---还资金方
sql_plan = '''
SELECT DATE(deadline) day_hk,t1.fund_code,SUM(principle+interest) plan_all FROM  all_back_0531.user_repayment_plan t1 JOIN audit.loan_manifest t2  ON t1.ref_id=t2.ref_id WHERE
t2.is_active in (1,-2) AND
t2.loan_paid_at >='2016-01-01' and t2.loan_paid_at<'2017-01-01' AND
 t1.fund_code != 160
GROUP BY 1,2
'''

# 用户实际还款--加入渠道---repaid_at 使用账单时间
sql_hk_yq = '''
SELECT DATE(t2.repaid_at) day_hk,t3.fund_code,
  sum(t1.principle-t1.mitigate_principle+t1.interest-t1.mitigate_interest) yq_real_principle_interest
FROM all_back_0531.xjd_repay_plan_repay_record_ref t1
JOIN temp.xjd_repay_plan_repay_record_ref_repay_date t2 ON t1.id = t2.xjd_ref_id
JOIN all_back_0531.user_repayment_plan t3 ON t1.plan_id = t3.id and t3.fund_code != 160
JOIN all_back_0531.loan_manifest t4  ON t4.ref_id=t3.ref_id
WHERE  t2.repaid_at < '2017-06-01' and date(t2.repaid_at) > DATE(t3.deadline) AND
 t4.loan_paid_at >='2016-01-01' and t4.loan_paid_at<'2017-01-01'
GROUP by 1,2
'''
sql_hk_zc = '''
SELECT DATE(t2.repaid_at) day_hk,t3.fund_code,
  sum(t1.principle-t1.mitigate_principle+t1.interest-t1.mitigate_interest)  zc_real_principle_interest
FROM all_back_0531.xjd_repay_plan_repay_record_ref t1
JOIN temp.xjd_repay_plan_repay_record_ref_repay_date t2 ON t1.id = t2.xjd_ref_id
JOIN all_back_0531.user_repayment_plan t3 ON t1.plan_id = t3.id and t3.fund_code != 160
JOIN all_back_0531.loan_manifest t4  ON t4.ref_id=t3.ref_id
WHERE  t2.repaid_at < '2017-06-01' and date(t2.repaid_at) = DATE(t3.deadline) AND
 t4.loan_paid_at >='2016-01-01' and t4.loan_paid_at<'2017-01-01'
GROUP by 1,2
'''

sql_hk_tq = '''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,
  sum(t1.principle-t1.mitigate_principle+t1.interest-t1.mitigate_interest) tq_real_principle_interest
FROM all_back_0531.xjd_repay_plan_repay_record_ref t1
JOIN temp.xjd_repay_plan_repay_record_ref_repay_date t2 ON t1.id = t2.xjd_ref_id
JOIN all_back_0531.user_repayment_plan t3 ON t1.plan_id = t3.id and t3.fund_code != 160
JOIN all_back_0531.loan_manifest t4  ON t4.ref_id=t3.ref_id
WHERE  t2.repaid_at < '2017-06-01' and date(t2.repaid_at) < DATE(t3.deadline) AND
 t4.loan_paid_at >='2016-01-01' and t4.loan_paid_at<'2017-01-01'
GROUP by 1,2
'''
sql_fee = '''
SELECT DATE(t2.repaid_at) day_hk,t3.fund_code,
  SUM(t1.service_fee-t1.mitigate_service_fee) real_service_fee,sum(t1.punish-t1.mitigate_collection_relief) real_punish
FROM all_back_0531.xjd_repay_plan_repay_record_ref t1
JOIN temp.xjd_repay_plan_repay_record_ref_repay_date t2 ON t1.id = t2.xjd_ref_id
JOIN all_back_0531.user_repayment_plan t3 ON t1.plan_id = t3.id and t3.fund_code != 160
JOIN all_back_0531.loan_manifest t4  ON t4.ref_id=t3.ref_id
WHERE t2.repaid_at >= '2017-01-01' AND  t2.repaid_at < '2017-06-01' and date(t2.repaid_at) = DATE(t3.deadline) AND
 t4.loan_paid_at >='2016-01-01' and t4.loan_paid_at<'2017-01-01'
GROUP by 1,2
'''


def xms_table():
    # 实还加入新马上
    read_ms_sql = '''
    SELECT '160' as fund_code,deadline,repaid_at,funding_principle+funding_interest+funding_service_fee as prin_inst_total,qg_service_fee real_service_fee ,qg_overdue_fee real_punish
    FROM new_transaction.new_ms_transaction_with_term
    '''
    df_ms = pd.read_sql(read_ms_sql, con=engine_new_transaction)
    df_ms['repaid_at'].fillna('2016-01-01', inplace=True)
    df_ms['repaid_at'] = pd.to_datetime(df_ms['repaid_at']).apply(lambda x: x.date())
    df_ms['deadline'] = pd.to_datetime(df_ms['deadline']).apply(lambda x: x.date())
    # 正常还款，逾期还款，提前还款
    df_zc = df_ms.ix[df_ms['deadline'] == df_ms['repaid_at']]
    df_zc = df_zc.groupby(by=['repaid_at'])['prin_inst_total'].sum()
    df_zc = df_zc.to_frame()
    df_zc.reset_index(inplace=True)
    df_zc.rename(columns={'repaid_at': 'day_hk', 'prin_inst_total': 'zc_prin_inst_total'}, inplace=True)
    df_zc['day_hk'] = pd.to_datetime(df_zc['day_hk']).apply(lambda x: x.date())
    # 提前还款
    df_tq = df_ms.ix[df_ms['deadline'] > df_ms['repaid_at']]
    df_tq = df_tq.groupby(by=['deadline'])['prin_inst_total'].sum()
    df_tq = df_tq.to_frame()
    df_tq.reset_index(inplace=True)
    df_tq['deadline'] = pd.to_datetime(df_tq['deadline']).apply(lambda x: x.date())
    df_tq.rename(columns={'deadline': 'day_hk', 'prin_inst_total': 'tq_prin_inst_total'}, inplace=True)
    df_tq['day_hk'] = pd.to_datetime(df_tq['day_hk']).apply(lambda x: x.date())
    # 逾期还款
    df_yq = df_ms.ix[df_ms['deadline'] < df_ms['repaid_at']]
    df_yq = df_yq.groupby(by=['repaid_at'])['prin_inst_total'].sum()
    df_yq = df_yq.to_frame()
    df_yq.reset_index(inplace=True)
    df_yq.rename(columns={'repaid_at': 'day_hk', 'prin_inst_total': 'yq_prin_inst_total'}, inplace=True)
    df_yq['day_hk'] = pd.to_datetime(df_yq['day_hk']).apply(lambda x: x.date())
    # 服务费
    df_service_fee = df_ms.groupby(by=['repaid_at'])['real_service_fee'].sum()
    df_service_fee = df_service_fee.to_frame()
    df_service_fee.reset_index(inplace=True)
    df_service_fee.rename(columns={'repaid_at': 'day_hk'}, inplace=True)
    df_service_fee['day_hk'] = pd.to_datetime(df_service_fee['day_hk']).apply(lambda x: x.date())
    # 逾期费
    df_deplay_fee = df_ms.groupby(by=['repaid_at'])['real_punish'].sum()
    df_deplay_fee = df_deplay_fee.to_frame()
    df_deplay_fee.reset_index(inplace=True)
    df_deplay_fee.rename(columns={'repaid_at': 'day_hk'}, inplace=True)
    df_deplay_fee['day_hk'] = pd.to_datetime(df_deplay_fee['day_hk']).apply(lambda x: x.date())
    # 时间+资金方生成
    list_date = pd.date_range('20160101', '20170101')
    df_date = pd.DataFrame(list_date)
    df_date.columns = ['day_hk']
    df_date.reset_index(inplace=True)
    df_date['day_hk'] = pd.to_datetime(df_date['day_hk']).apply(lambda x: x.date())
    df_date = pd.DataFrame(list(itertools.product(df_date['day_hk'].values.tolist())),
                           columns=['day_hk'])
    df_date['day_hk'] = pd.to_datetime(df_date['day_hk']).apply(lambda x: x.date())
    # 合并实还本息
    df_out = pd.merge(df_date, df_zc, how='left', on=['day_hk'])
    df_out = pd.merge(df_out, df_tq, how='left', on=['day_hk'])
    df_out = pd.merge(df_out, df_yq, how='left', on=['day_hk'])
    df_out = pd.merge(df_out, df_service_fee, how='left', on=['day_hk'])
    df_out = pd.merge(df_out, df_deplay_fee, how='left', on=['day_hk'])
    df_out.fillna(0, inplace=True)
    df_out['prin_inst_real'] = df_out['zc_prin_inst_total'] + df_out['yq_prin_inst_total'] + df_out[
        'tq_prin_inst_total']
    df_out.fillna(0, inplace=True)
    df_out['day_hk'] = pd.to_datetime(df_out['day_hk']).apply(lambda x: x.date())
    # 客户应还本息
    read_1_sql = '''
    SELECT DATE(deadline) day_hk,sum(principle+interest) prin_inst_plan FROM all_back_0531.user_repayment_plan
    where fund_code = 160
    group by date(deadline)
    '''
    df_plan = pd.read_sql(read_1_sql, con=engine_new_transaction)
    df_plan.fillna(0, inplace=True)
    df_plan['day_hk'] = pd.to_datetime(df_plan['day_hk']).apply(lambda x: x.date())
    # df_plan['day_hk']=df_plan['day_hk'].apply(lambda x:x+datetime.timedelta(days=85))
    df_plan['prin_inst_plan'] = df_plan['prin_inst_plan'].astype(float)
    df_out['day_hk'] = pd.to_datetime(df_out['day_hk']).apply(lambda x: x.date())
    # 合并新马上
    df_out = pd.merge(df_out, df_plan, how='left', on=['day_hk'])
    df_out.fillna(0, inplace=True)
    df_out.rename(columns={'day_hk': u'客户还款日期', 'zc_prin_inst_total': u'客户正常还款本息', 'tq_prin_inst_total': u'客户提前还款本息',
                           'yq_prin_inst_total': u'客户逾期还款本息', 'real_service_fee': u'还款服务费', 'real_punish': u'逾期费',
                           'prin_inst_plan': u'客户应还本息',
                           'prin_inst_real': u'客户实还本息',
                           'fund_amount': u'资金方本息'}, inplace=True)
    df_out.to_excel('E:/xms_peifu_month.xlsx', index=None, columns=df_out.columns, encoding='utf8')


if __name__ == '__main__':
    # 应还
    df_plan = pd.read_sql(sql_plan, engine_new_transaction)
    df_zc = pd.read_sql(sql_hk_zc, engine_new_transaction)
    df_tq = pd.read_sql(sql_hk_tq, engine_new_transaction)
    df_yq = pd.read_sql(sql_hk_yq, engine_new_transaction)
    df_fee = pd.read_sql(sql_fee, engine_new_transaction)

    df_plan.day_hk = pd.to_datetime(df_plan.day_hk).dt.date
    df_zc.day_hk = pd.to_datetime(df_zc.day_hk).dt.date
    df_tq.day_hk = pd.to_datetime(df_tq.day_hk).dt.date
    df_yq.day_hk = pd.to_datetime(df_yq.day_hk).dt.date
    df_fee.day_hk = pd.to_datetime(df_fee.day_hk).dt.date
    df_plan.fund_code = df_plan.fund_code.astype(int)
    df_zc.fund_code = df_zc.fund_code.astype(int)
    df_tq.fund_code = df_tq.fund_code.astype(int)
    df_yq.fund_code = df_yq.fund_code.astype(int)
    df_fee.fund_code = df_fee.fund_code.astype(int)
    df = pd.merge(df_plan, df_zc, on=['day_hk', 'fund_code'], how='outer')
    df = pd.merge(df, df_tq, on=['day_hk', 'fund_code'], how='outer')
    df = pd.merge(df, df_yq, on=['day_hk', 'fund_code'], how='outer')
    df = pd.merge(df, df_fee, on=['day_hk', 'fund_code'], how='outer')
    df.fillna(0, inplace=True)
    df['real_all'] = df['yq_real_principle_interest'] + df['tq_real_principle_interest'] + df[
        'zc_real_principle_interest']
    df.rename(
        columns={'plan_all': '应还资金方本息', 'yq_real_principle_interest': '客户逾期实还', 'tq_real_principle_interest': '客户提前实还',
                 'zc_real_principle_interest': '客户正常实还', 'real_all': '客户实还总额', 'real_service_fee': '客户实还服务费',
                 'real_punish': '客户实还本息'}, inplace=True)
    df.fund_code = df.fund_code.astype(int)
    df = pd.merge(df, df_fund, on='fund_code', how='left')
    df.to_excel('./peifu_0531_2.xlsx', index=None, columns=df.columns, encoding='utf8')
    # xms_table()

print '=====================main done======================'
