# -*- encoding: utf8 -*-

"""
目标：
    现金贷还资金方表按还款月统计汇总
数据库：
    根据不同时段的需求，选取不同阶段的备份数据库
字段名：
    还款年，还款月，资金方，还款账户，当期还款总额，当期还款本金，当期还款利息，提前还款服务费，资金方服务费，逾期罚息
注意：

"""

import os

import datetime
import pandas as pd
import numpy as np
from db_con.db_connect import sql_engine

# ----------------------------------------------
pd.options.mode.chained_assignment = None
step = 10000
max_limit = 900000
file_path = u'E:/审计出表/现金贷'
file_name = u'现金贷还款表-明细表'
if not os.path.exists(file_path):
    os.makedirs(file_path)
mysql = sql_engine('audit', 'temp', False).get_engine()
sql_fund = """
SELECT
  year(t1.repaid_at)                     打款年份,
  month(t1.repaid_at)                    打款月份,
  fc.name                                资金方,
  sum(ifnull(t1.current_repayment, 0))   当期总额,
  sum(ifnull(t1.principle, 0))           当期本金,
  sum(ifnull(t1.interest, 0))            当期利息,
  sum(ifnull(t1.prepay_fee, 0))          提前还款服务费,
  sum(ifnull(t1.funding_service_fee, 0)) 资金方服务费,
  sum(ifnull(t1.punish_fee, 0))          逾期罚息
FROM audit.funding_repayment_record t1
  LEFT JOIN audit.funding_corp fc ON t1.funding_code = fc.funding_code
WHERE t1.repaid_at IS NOT NULL AND t1.funding_code NOT IN (290, 330)
GROUP BY 1, 2, 3;
"""
sql_fund_fenzhang = """
SELECT
  year(t1.repaid_at)                     打款年份,
  month(t1.repaid_at)                    打款月份,
  concat(fc.name, '-易宝分账')             资金方,
  sum(ifnull(t1.current_repayment, 0))   当期总额,
  sum(ifnull(t1.principle, 0))           当期本金,
  sum(ifnull(t1.interest, 0))            当期利息,
  sum(ifnull(t1.prepay_fee, 0))          提前还款服务费,
  sum(ifnull(t1.funding_service_fee, 0)) 资金方服务费,
  sum(ifnull(punish_fee, 0))             逾期罚息
FROM audit.funding_repayment_record t1
  LEFT JOIN audit.funding_corp fc ON t1.funding_code = fc.funding_code
WHERE t1.repaid_at IS NOT NULL AND t1.remark IS NOT NULL AND t1.funding_code IN (290, 330)
GROUP BY 1, 2, 3; 
"""
sql_fund_290 = """
SELECT
  year(t1.repaid_at)                     打款年份,
  month(t1.repaid_at)                    打款月份,
  fc.name                                资金方,
  sum(ifnull(t1.current_repayment, 0))   当期总额,
  sum(ifnull(t1.principle, 0))           当期本金,
  sum(ifnull(t1.interest, 0))            当期利息,
  sum(ifnull(t1.prepay_fee, 0))          提前还款服务费,
  sum(ifnull(t1.funding_service_fee, 0)) 资金方服务费,
  sum(ifnull(punish_fee, 0))             逾期罚息
FROM audit.funding_repayment_record t1
  LEFT JOIN audit.funding_corp fc ON t1.funding_code = fc.funding_code
WHERE t1.repaid_at IS NOT NULL
  AND (t1.remark IS NULL OR t1.remark = '已代偿且分账成功') AND t1.funding_code = 290
GROUP BY 1, 2, 3;
"""
sql_fund_330 = """
SELECT
  year(t1.repaid_at)                     打款年份,
  month(t1.repaid_at)                    打款月份,
  fc.name                                资金方,
  sum(ifnull(t1.current_repayment, 0))   当期总额,
  sum(ifnull(t1.principle, 0))           当期本金,
  sum(ifnull(t1.interest, 0))            当期利息,
  sum(ifnull(t1.prepay_fee, 0))          提前还款服务费,
  sum(ifnull(t1.funding_service_fee, 0)) 资金方服务费,
  sum(ifnull(t1.punish_fee, 0))          逾期罚息
FROM audit.funding_repayment_record t1
  LEFT JOIN audit.funding_corp fc ON t1.funding_code = fc.funding_code
WHERE t1.repaid_at IS NOT NULL AND t1.funding_code = 330 AND t1.remark IS NULL
GROUP BY 1, 2, 3;
"""
# ----------------------------------------------
