# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
import numpy as np
from sqlalchemy import create_engine
from itertools import product
import multiprocessing as mtp
from dateutil.relativedelta import relativedelta

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

path = u'E:/数据汇总/白条/去哪儿/放款/现金流/'
engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/qunaer_new?charset=utf8', echo=False).connect()


# JOIN qunaer_new.repayment_plan_2016 t3 on t1.product_no = t3.product_no and t1.current_stage_no = t3.current_stage_no  ,t3.principle '应还本金',t3.deadline '应还时间',t2.stages '期数'
def hk(year, month):
    start_time = datetime.date(year, month, 1)
    end_time = start_time + relativedelta(months=+1)
    sql_repay = '''
        select t1.product_no '产品编号' ,t1.current_stage_no '当期期数',t1.repay_time '实还时间',t1.repay_amount '实还金额' , t1.repay_principle '实还本金',t1.repay_fee_amount '实还服务费',
        t1.repay_due_amount '实还罚息',t1.remain '其他收益',t1.flow_id '流水号'
        from qunaer_new.repay_detail t1
        JOIN qunaer_new.pay_detail t2 on t1.product_no = t2.product_no and t1.repay_status = 1 AND t2.trans_time >= '%s' AND t2.trans_time < '%s'
    ''' % (start_time, end_time)
    df_repay = pd.read_sql(sql_repay, engine_new_transaction)
    df_repay.to_csv(path + 'qunaer_%d_%d.csv' % (year, month), index=None)


def fk(year, month):
    start_time = datetime.date(year, month, 1)
    end_time = start_time + relativedelta(months=+1)
    sql_1 = '''
        select t3.product_no,t3.loan_amount,sum(t4.refund_amount), (case when t3.is_ptf = 0 then t3.loan_time else t3.trans_time end) as time,t3.stages
        from (select t1.product_no,loan_amount,loan_time,is_ptf,trans_time,stages from
        (SELECT product_no,loan_amount,loan_time,is_ptf,trans_time,stages from pay_detail where
        (case when is_ptf = 0 then loan_time else trans_time end) >= '%s' and (case when is_ptf = 0 then loan_time else trans_time end) < '%s' ) t1
        left join trans_ref t2 on t1.product_no = t2.product_no
        where t2.id is null) t3
        left join refund_detail t4 on t4.product_no = t3.product_no
        group by t3.product_no
    ''' % (start_time, end_time)
    df_fk = pd.read_sql(sql_1, engine_new_transaction)
    df_fk.to_csv(path + 'qunaer_fk_%d_%d.csv' % (year, month), index=None)


sql_plan = '''
  SELECT
    rp_1617.product_no,
    rp_1617.current_stage_no '当前期数',
    rp_1617.deadline         '当前应还款日',
    rp_1617.principle        '当前本金',
    rp_1617.repay_principle  '实还本金'
  from qunaer_new.repayment_plan_2016_201706 rp_1617
  WHERE
    rp_1617.product_no in %s
'''
sql_refund = """
  select t1.product_no,t1.refund_amount '合同放款金额',t1.refund_time loan_time, t2.stages '分期数',
            0 current_stage,'FALSE' as '是否为转分期后订单号' 
  from refund_detail t1
  JOIN pay_detail t2 on t1.product_no=t2.product_no
  where t1.refund_time >= '%s' and t1.refund_time < '%s'"""
sql_loan = """
select product_no,loan_amount '合同放款金额',loan_time, stages '分期数',
        1 current_stage,'FALSE' as '是否为转分期后订单号' 
from pay_detail 
where is_ptf = 0 and loan_time >= '%s' and loan_time < '%s'"""


def xjl(year, month):
    start_time = datetime.date(year, month, 1)
    end_time = start_time + relativedelta(months=+1)
    df_loan = pd.read_sql(sql_loan % (start_time, end_time), engine_new_transaction)
    df_refund = pd.read_sql(sql_refund % (start_time, end_time), engine_new_transaction)
    if len(df_refund) > 0:
        df_xjl = pd.concat([df_loan, df_refund], ignore_index=True)
    else:
        df_xjl = df_loan
    df_xjl['product_no'] = df_xjl['product_no'].astype(str)
    df_xjl['current_stage'] = df_xjl['current_stage'].astype(int)
    df_xjl[u'合同放款金额'] = df_xjl[u'合同放款金额'].apply(lambda x: np.round(x, 2))
    product_no_list = df_xjl['product_no'].tolist()
    df_plan = pd.read_sql(sql_plan % str(tuple(product_no_list)).replace(',)', ')'), engine_new_transaction)
    df_plan['product_no'] = df_plan['product_no'].astype(str)
    df_plan[u'当前期数'] = df_plan[u'当前期数'].astype(int)
    df_out = pd.merge(df_xjl, df_plan, left_on=['product_no', 'current_stage'], right_on=['product_no', u'当前期数'],
                      how='outer')
    df_out.drop(['current_stage'], axis=1, inplace=True)
    df_out.to_csv(path + 'qunaer_xjl_%d_%d.csv' % (year, month), index=None, encoding='gbk')


# xjl(2015, 12)
years = (2015, 2016,)
months = (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
if __name__ == '__main__':
    pool = mtp.Pool(processes=8)
    for year, month in product(years, months):
        print year, month
        if year == 2017 and month > 6:
            continue
        elif year == 2015 and month < 12:
            continue
        else:
            pool.apply_async(xjl, (year, month))
    pool.close()
    pool.join()
