# 注意，信托类有很多退款的放款，需要确认是否要包含这些订单
# 提前还款
SELECT
  lm.funding_code,
  date_format(lm.loan_paid_at, '%Y-%m') loan_paid_at,
  urp.term_no,
  date_format(tmp.repaid_at, '%Y-%m')   repaid_at,
  sum(tmp.repay_prin_inst)              repay_prin_inst
FROM (
       SELECT
         xrprrr.plan_id,
         sum(xrprrr.principle - xrprrr.mitigate_principle + xrprrr.interest - xrprrr.mitigate_interest) repay_prin_inst,
         min(xrprrrrd.repaid_at)                                                                        repaid_at
       FROM all_back_0731.xjd_repay_plan_repay_record_ref xrprrr
         JOIN new_transaction.xjd_repay_plan_repay_record_ref_repay_date xrprrrrd ON xrprrr.id = xrprrrrd.xjd_ref_id
       GROUP BY 1
     ) tmp
  JOIN all_back_0731.user_repayment_plan urp
    ON urp.id = tmp.plan_id AND date_format(urp.deadline, '%Y-%m') > date_format(tmp.repaid_at, '%Y-%m')
  JOIN all_back_0731.loan_manifest lm ON lm.ref_id = urp.ref_id AND lm.funding_code IN (270, 310, 320, 390)
GROUP BY 1, 2, 3, 4;

# 代偿-未还部分
SELECT
  lm.funding_code,
  date_format(lm.loan_paid_at, '%Y-%m') loan_paid_at,
  urp.term_no,
  date_format(urp.deadline, '%Y-%m')    deadline,
  sum(urp.principle + urp.interest)     req_prin_inst
FROM all_back_0731.user_repayment_plan urp
  JOIN all_back_0731.loan_manifest lm ON lm.ref_id = urp.ref_id AND lm.funding_code IN (270, 310, 320, 390)
  LEFT JOIN all_back_0731.xjd_repay_plan_repay_record_ref xrprrr
    ON urp.id = xrprrr.plan_id
WHERE xrprrr.id IS NULL
GROUP BY 1, 2, 3, 4;

# 代偿-逾期部分（催回-应还时间）
SELECT
  lm.funding_code,
  date_format(lm.loan_paid_at, '%Y-%m') loan_paid_at,
  urp.term_no,
  date_format(urp.deadline, '%Y-%m')    deadline,
  sum(tmp.repay_prin_inst)              repay_prin_inst
FROM (
       SELECT
         xrprrr.plan_id,
         sum(xrprrr.principle - xrprrr.mitigate_principle + xrprrr.interest - xrprrr.mitigate_interest) repay_prin_inst,
         min(xrprrrrd.repaid_at)                                                                        repaid_at
       FROM all_back_0731.xjd_repay_plan_repay_record_ref xrprrr
         JOIN new_transaction.xjd_repay_plan_repay_record_ref_repay_date xrprrrrd ON xrprrr.id = xrprrrrd.xjd_ref_id
       GROUP BY 1
     ) tmp
  JOIN all_back_0731.user_repayment_plan urp
    ON urp.id = tmp.plan_id AND date_format(urp.deadline, '%Y-%m') < date_format(tmp.repaid_at, '%Y-%m')
  JOIN all_back_0731.loan_manifest lm ON lm.ref_id = urp.ref_id AND lm.funding_code IN (270, 310, 320, 390)
GROUP BY 1, 2, 3, 4;

# 催回-实还时间
SELECT
  lm.funding_code,
  date_format(lm.loan_paid_at, '%Y-%m') loan_paid_at,
  urp.term_no,
  date_format(tmp.repaid_at, '%Y-%m')   repaid_at,
  sum(tmp.repay_prin_inst)              repay_prin_inst
FROM (
       SELECT
         xrprrr.plan_id,
         sum(xrprrr.principle - xrprrr.mitigate_principle + xrprrr.interest - xrprrr.mitigate_interest) repay_prin_inst,
         min(xrprrrrd.repaid_at)                                                                        repaid_at
       FROM all_back_0731.xjd_repay_plan_repay_record_ref xrprrr
         JOIN new_transaction.xjd_repay_plan_repay_record_ref_repay_date xrprrrrd ON xrprrr.id = xrprrrrd.xjd_ref_id
       GROUP BY 1
     ) tmp
  JOIN all_back_0731.user_repayment_plan urp
    ON urp.id = tmp.plan_id AND date_format(urp.deadline, '%Y-%m') < date_format(tmp.repaid_at, '%Y-%m')
  JOIN all_back_0731.loan_manifest lm ON lm.ref_id = urp.ref_id AND lm.funding_code IN (270, 310, 320, 390)
GROUP BY 1, 2, 3, 4;