# -*- coding:utf-8 -*-
#Author: Perry_Zhu
import datetime
import multiprocessing as mtp
import sys
from itertools import product
import pandas as pd
from dateutil.relativedelta import relativedelta
from sqlalchemy import create_engine
import pyexcelerate

max_limit = 900000
reload(sys)
sys.setdefaultencoding('utf8')

path = u'E:/审计出表/人工控制/非去哪儿-实还表/'
# 注意修改数据源

engine_all_back_0930 = create_engine(
	'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/all_back_0930?charset=utf8',
	echo=True)

read_merchant_sql = '''SELECT merchant_id,merchant_name FROM all_back_0930.merchant'''
df_merchant = pd.read_sql(read_merchant_sql, con=engine_all_back_0930)
df_merchant['merchant_id'] = df_merchant['merchant_id'].astype(int)
read_repay_sql = '''
SELECT id,`approach_name` FROM all_back_0930.repay_channel
'''
df_approach = pd.read_sql(read_repay_sql, engine_all_back_0930)
df_approach['id'] = df_approach['id'].astype(int)

read_fund_sql = '''
SELECT id,fund_name FROM all_back_0930.`fund_corp`
'''
df_fund = pd.read_sql(read_fund_sql, engine_all_back_0930)
df_fund['id'] = df_fund['id'].astype(int)

'''
白条还款汇总
'''


################################################
# 收客户还款汇总
def hk_hz(year,month):
	year,month = 2017,8
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)

	sql_alipay = """
	SELECT
		t8.fund_name 资金方,
		t5.order_no 产品编号,
		t5.contract_term 放款期数,
		t2.term_no 当前期数,
		t6.merchant_name 商户名称,
		date(t3.transfer_time) 实还时间,
		ifnull(t1.ref_amount,0) 还款总额,
		ifnull(t1.principle,0) - ifnull(t1.mitigate_principle,0) 实还本金,
		ifnull(t1.interest,0)-ifnull(t1.mitigate_interest,0) 实还利息,
		ifnull(t1.service_fee,0) - ifnull(t1.mitigate_service_fee,0) 实还服务费,
		ifnull(t1.punish,0) - ifnull(t1.mitigate_collection_relief,0) 实还罚息,
		ifnull(t1.remain_income,0) 其他收益,
		t7.approach_name 还款账户,
		t3.business_flow 流水号,
		t3.income + t3.outcome 账单金额,
		date(t9.deadline) 应还日期,
		t9.principal 应还本金,
		t9.interest 应还利息
	FROM
		all_back_0930.baitiao_repay_plan_repay_record_ref t1
	JOIN all_back_0930.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
	JOIN all_back_0930.offline_alipay_record t3 ON t1.repay_channel = 13 AND t3.id = t1.record_id AND  t3.is_ref=1 AND t3.enable=1
	JOIN all_back_0930.baitiao_order t5 ON t2.ref_id = t5.ref_id
	JOIN all_back_0930.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
	JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
	JOIN all_back_0930.fund_corp t8 ON  t5.funding_corp_id=t8.id
	join all_back_0930.bt_funding_repayment_plan t9 on t9.ref_id = t2.ref_id and t9.term_no = t2.term_no
	where t3.transfer_time>='%s' and t3.transfer_time <'%s' and t5.funding_corp_id = 5
	""" %(start_time,end_time)
	df_alipay_zhitou = pd.read_sql(sql=sql_alipay, con=engine_all_back_0930)

	sql_bank = """
	  SELECT
		t8.fund_name 资金方,
		t5.order_no 产品编号,
		t5.contract_term 放款期数,
		t2.term_no 当前期数,
		t6.merchant_name 商户名称,
		date(t3.transfer_time 实还时间),
		ifnull(t1.ref_amount,0) 还款总额,
		ifnull(t1.principle,0) - ifnull(t1.mitigate_principle,0) 实还本金,
		ifnull(t1.interest,0) - ifnull(t1.mitigate_interest,0) 实还利息,
		ifnull(t1.service_fee,0) - ifnull(t1.mitigate_service_fee,0)  实还服务费,
		ifnull(t1.punish,0) - ifnull(t1.mitigate_collection_relief,0) 实还罚息,
		ifnull(t1.remain_income,0) 其他收益,
		t7.approach_name 还款账户,
		t3.serial_number 流水号,
		t3.transfer_amount 账单金额,
		date(t9.deadline) 应还日期,
		t9.principal 应还本金,
		t9.interest 应还利息
	FROM
		baitiao_repay_plan_repay_record_ref t1
	JOIN user_bt_repayment_plan t2 ON t2.id = t1.plan_id
	JOIN offline_bank_repay_record t3 ON t1.repay_channel IN (14, 15, 16)
	AND t3.id = t1.record_id
	JOIN all_back_0930.baitiao_order t5 ON t2.ref_id = t5.ref_id
	JOIN all_back_0930.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
	JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
	JOIN all_back_0930.fund_corp t8 ON  t5.funding_corp_id=t8.id
	join all_back_0930.bt_funding_repayment_plan t9 on t9.ref_id = t2.ref_id and t9.term_no = t2.term_no
	where t3.transfer_time>='%s' and t3.transfer_time <'%s' and t5.funding_corp_id = 5
	"""%(start_time,end_time)
	df_bank_zhitou = pd.read_sql(sql=sql_bank, con=engine_all_back_0930)

	sql_online = """
		SELECT
			t8.fund_name 资金方,
			t5.order_no 产品编号,
			t5.contract_term 放款期数,
			t2.term_no 当前期数,
			t6.merchant_name 商户名称,
			date(t3.bill_time) 实还时间,
			ifnull(t1.ref_amount,0) 还款总额,
			ifnull(t1.principle,0) - ifnull(t1.mitigate_principle,0) 实还本金,
			ifnull(t1.interest,0) - ifnull(t1.mitigate_interest,0) 实还利息,
			ifnull(t1.service_fee,0) - ifnull(t1.mitigate_service_fee,0)  实还服务费,
			ifnull(t1.punish,0) - ifnull(t1.mitigate_collection_relief,0) 实还罚息,
			ifnull(t1.remain_income,0) 其他收益,
			t7.approach_name 还款账户,
			t3.order_id 流水号,
			t3.amount 账单金额,
			date(t9.deadline) 应还日期,
			t9.principal 应还本金,
			t9.interest 应还利息
			
		FROM
			all_back_0930.baitiao_repay_plan_repay_record_ref t1
		JOIN all_back_0930.repay_record_online t3 ON t1.repay_channel in(1,2,3,4,5,6,7,8,9,10,11,12,22,23,24) AND t3.id = t1.record_id
		JOIN all_back_0930.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
		JOIN all_back_0930.baitiao_order t5 ON t2.ref_id = t5.ref_id
		JOIN all_back_0930.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
		JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
		JOIN all_back_0930.fund_corp t8 ON  t5.funding_corp_id=t8.id
		join all_back_0930.bt_funding_repayment_plan t9 on t9.ref_id = t2.ref_id and t9.term_no = t2.term_no
		WHERE t3.bill_time is not NULL 
		and t3.bill_time>='%s' and t3.bill_time<'%s' and t5.funding_corp_id = 5
	"""%(start_time,end_time)

	df_online_zhitou = pd.read_sql(sql=sql_online, con=engine_all_back_0930)

	sql_alipay = """
	SELECT
		t8.fund_name 资金方,
		t5.order_no 产品编号,
		t5.contract_term 放款期数,
		t2.term_no 当前期数,
		t6.merchant_name 商户名称,
		date(t3.transfer_time) 实还时间,
		ifnull(t1.ref_amount,0) 还款总额,
		ifnull(t1.principle,0) - ifnull(t1.mitigate_principle,0) 实还本金,
		ifnull(t1.interest,0)-ifnull(t1.mitigate_interest,0) 实还利息,
		ifnull(t1.service_fee,0) - ifnull(t1.mitigate_service_fee,0) 实还服务费,
		ifnull(t1.punish,0) - ifnull(t1.mitigate_collection_relief,0) 实还罚息,
		ifnull(t1.remain_income,0) 其他收益,
		t7.approach_name 还款账户,
		t3.business_flow 流水号,
		t3.income + t3.outcome 账单金额,
		date(t2.deadline) 应还日期,
		t2.principle 应还本金,
		t2.interest 应还利息
	FROM
		all_back_0930.baitiao_repay_plan_repay_record_ref t1
	JOIN all_back_0930.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
	JOIN all_back_0930.offline_alipay_record t3 ON t1.repay_channel = 13 AND t3.id = t1.record_id AND  t3.is_ref=1 AND t3.enable=1
	JOIN all_back_0930.baitiao_order t5 ON t2.ref_id = t5.ref_id
	JOIN all_back_0930.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
	JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
	JOIN all_back_0930.fund_corp t8 ON  t5.funding_corp_id=t8.id
	where t3.transfer_time>='%s' and t3.transfer_time <'%s' and t5.funding_corp_id = 1
	""" % (start_time, end_time)
	df_alipay = pd.read_sql(sql=sql_alipay, con=engine_all_back_0930)

	sql_bank = """
	  SELECT
		t8.fund_name 资金方,
		t5.order_no 产品编号,
		t5.contract_term 放款期数,
		t2.term_no 当前期数,
		t6.merchant_name 商户名称,
		date(t3.transfer_time) 实还时间,
		ifnull(t1.ref_amount,0) 还款总额,
		ifnull(t1.principle,0) - ifnull(t1.mitigate_principle,0) 实还本金,
		ifnull(t1.interest,0) - ifnull(t1.mitigate_interest,0) 实还利息,
		ifnull(t1.service_fee,0) - ifnull(t1.mitigate_service_fee,0)  实还服务费,
		ifnull(t1.punish,0) - ifnull(t1.mitigate_collection_relief,0) 实还罚息,
		ifnull(t1.remain_income,0) 其他收益,
		t7.approach_name 还款账户,
		t3.serial_number 流水号,
		t3.transfer_amount 账单金额,
		date(t2.deadline) 应还日期,
		t2.principle 应还本金,
		t2.interest 应还利息
	FROM
		baitiao_repay_plan_repay_record_ref t1
	JOIN user_bt_repayment_plan t2 ON t2.id = t1.plan_id
	JOIN offline_bank_repay_record t3 ON t1.repay_channel IN (14, 15, 16)
	AND t3.id = t1.record_id
	JOIN all_back_0930.baitiao_order t5 ON t2.ref_id = t5.ref_id
	JOIN all_back_0930.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
	JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
	JOIN all_back_0930.fund_corp t8 ON  t5.funding_corp_id=t8.id
	where t3.transfer_time>='%s' and t3.transfer_time <'%s' and t5.funding_corp_id = 1
	""" % (start_time, end_time)
	df_bank = pd.read_sql(sql=sql_bank, con=engine_all_back_0930)

	sql_online = """
		SELECT
			t8.fund_name 资金方,
			t5.order_no 产品编号,
			t5.contract_term 放款期数,
			t2.term_no 当前期数,
			t6.merchant_name 商户名称,
			date(t3.bill_time) 实还时间,
			ifnull(t1.ref_amount,0) 还款总额,
			ifnull(t1.principle,0) - ifnull(t1.mitigate_principle,0) 实还本金,
			ifnull(t1.interest,0) - ifnull(t1.mitigate_interest,0) 实还利息,
			ifnull(t1.service_fee,0) - ifnull(t1.mitigate_service_fee,0)  实还服务费,
			ifnull(t1.punish,0) - ifnull(t1.mitigate_collection_relief,0) 实还罚息,
			ifnull(t1.remain_income,0) 其他收益,
			t7.approach_name 还款账户,
			t3.order_id 流水号,
			t3.amount 账单金额,
			date(t2.deadline) 应还日期,
			t2.principle 应还本金,
			t2.interest 应还利息

		FROM
			all_back_0930.baitiao_repay_plan_repay_record_ref t1
		JOIN all_back_0930.repay_record_online t3 ON t1.repay_channel in(1,2,3,4,5,6,7,8,9,10,11,12,22,23,24) AND t3.id = t1.record_id
		JOIN all_back_0930.user_bt_repayment_plan t2 ON t2.id = t1.plan_id
		JOIN all_back_0930.baitiao_order t5 ON t2.ref_id = t5.ref_id
		JOIN all_back_0930.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
		JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
		JOIN all_back_0930.fund_corp t8 ON  t5.funding_corp_id=t8.id
		WHERE t3.bill_time is not NULL 
		and t3.bill_time>='%s' and t3.bill_time<'%s' and t5.funding_corp_id = 1
	""" % (start_time, end_time)

	df_online = pd.read_sql(sql=sql_online, con=engine_all_back_0930)

	sql_cash_online = """
	SELECT
		t8.fund_name 资金方,
		t5.order_no 产品编号,
		t5.contract_term 放款期数,
		t5.contract_term 当前期数,
		t6.merchant_name 商户名称,
		date(t3.bill_time) 实还时间,
		ifnull(t1.ref_amount,0) 还款总额,
		ifnull(t5.real_loan_amount,0) 实还本金,
		0.0 实还利息,
		0.0 实还服务费,
		0.0 实还罚息,
		0.0 其他收益,
		'白条现金支付' 还款账户,
		0 流水号,
		t5.real_loan_amount 账单金额,
		ifnull(t5.real_loan_amount,0) '应还本金',
		date(t3.bill_time) 应还日期,
		0 应还利息        
	FROM
		(SELECT repay_id,record_id,repay_channel,SUM(ifnull(ref_amount,0))ref_amount FROM 
				baitiao_cash_record_ref WHERE  repay_channel !=13 GROUP BY 1) t1
	JOIN all_back_0930.baitiao_cash_repay t2 ON t2.id = t1.repay_id
	JOIN all_back_0930.repay_record_online t3 ON t3.id = t1.record_id 
	JOIN all_back_0930.baitiao_order t5 ON t2.order_no = t5.order_no AND t2.real_order_amount=t5.real_loan_amount
	JOIN all_back_0930.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
	JOIN all_back_0930.fund_corp t8 ON  t5.funding_corp_id=t8.id
	WHERE t3.bill_time is not NULL 
	and t3.bill_time>='%s' and t3.bill_time<'%s' 
	"""%(start_time,end_time)

	sql_cash_alipay = """
		SELECT
			t8.fund_name 资金方,
			t5.order_no 产品编号,
			t5.contract_term 放款期数,
			t5.contract_term 当前期数,
			t6.merchant_name 商户名称,
			date(t3.transfer_time) 实还时间,
			ifnull(t1.ref_amount,0) 还款总额,
			ifnull(t5.real_loan_amount,0) 实还本金,
			0.0 实还利息,
			0.0 实还服务费,
			0.0 实还罚息,
			0.0 其他收益,
			'支付宝线下还款' 还款账户,
			t3.business_flow 流水号,
			t3.outcome + t3.income 账单金额,
			ifnull(t5.real_loan_amount,0) 应还本金,
			date(t3.transfer_time) 应还日期,
			0 应还利息
		FROM
		   (SELECT repay_id,record_id,repay_channel,SUM(ifnull(ref_amount,0))ref_amount 
			  FROM 
			all_back_0930.baitiao_cash_record_ref 
			GROUP BY 1) t1
		JOIN all_back_0930.baitiao_cash_repay t2 ON t2.id = t1.repay_id
		JOIN offline_alipay_record t3 ON  t3.id = t1.record_id AND t1.repay_channel=13
		JOIN all_back_0930.baitiao_order t5 ON t2.order_no = t5.order_no AND t2.real_order_amount=t5.real_loan_amount
		JOIN all_back_0930.merchant t6 ON t6.`merchant_id` = t5.`merchantId`
		JOIN new_transaction.repay_channel t7 ON t1.repay_channel = t7.id
		JOIN all_back_0930.fund_corp t8 ON  t5.funding_corp_id=t8.id
		where t3.transfer_time>='%s' and t3.transfer_time <'%s'
		"""%(start_time,end_time)

	df_cash_onlie = pd.read_sql(sql=sql_cash_online, con=engine_all_back_0930)
	df_cash_alipay = pd.read_sql(sql=sql_cash_alipay, con=engine_all_back_0930)
	df = pd.concat([df_alipay, df_bank, df_online, df_cash_onlie, df_cash_alipay,df_alipay_zhitou,df_bank_zhitou,df_online_zhitou], ignore_index=True)

	df[u'唯一编号'] = df[u'产品编号'].astype(str) + df[u'当前期数'].astype(str)

	df.loc[(df[u'流水号']!=0) & (df[u'流水号'].duplicated()),u'账单金额'] = 0
	#当遇到流水号为0的情况时，需要特别注意


	df.loc[df[u'资金方'] == u'保理',u'应还利息'] = 0

	df[u'应还本息-实还本息'] = df[u'应还本金'].fillna(0) + df[u'应还利息'].fillna(0) - df[u'实还本金'].fillna(0)- df[u'实还利息'].fillna(0)
	df[u'还款总额-账单金额'] = df[u'还款总额'].fillna(0) - df[u'账单金额'].fillna(0)


	df = df[
			[u'唯一编号',u'商户名称',u'产品编号',u'资金方',u'放款期数',u'当前期数',u'实还时间', u'还款总额', u'实还本金', u'实还利息', u'实还服务费', u'实还罚息',
		 u'其他收益',u'还款账户',u'流水号',u'账单金额',u'应还本金',u'应还日期',u'应还利息',u'应还本息-实还本息',u'还款总额-账单金额']]
	df.fillna(0,inplace=True)

	# df.to_excel(path + u'人工控制-非去哪儿-实还表_V1_%s_%s.xlsx' %(year,month), index=None)

	all_wb = pyexcelerate.Workbook()
	for i in xrange(0, len(df), max_limit):
		temp = df[i:i+max_limit]
		temp_list = temp.values.tolist()
		temp_list.insert(0,temp.columns.tolist())
		all_wb.new_sheet(str(int(i/max_limit + 1)),data=temp_list)
	all_wb.save(path+u'人工控制-非去哪儿-实还表_V4_%s_%s.xlsx' %(start_time.year,start_time.month))



if __name__ == '__main__':
	# 还款汇总
	years = [2017]
	months = [8]
	for year, month in product(years, months):
		print('-----%s--%s') % (year, month)
		hk_hz(year, month)