# -*- encoding: utf8 -*-

"""
目标：
    收入确认表-以loan_id为维度比较风险金及客户实还服务费
数据库：

字段名：
    loan_id，资金方，风险等级，本金债权，放款日期，计提风险金比例，计提风险金，实还服务费（减免后，含一次性服务费），Asset余额，收入确认金额
注意：
    加入一次性服务费，计提风险金比例
    每个时间点用对应时间点的备份库，eg：17年4月30号之前的用430数据库，5月31号之前的用531库。。。
"""
from __future__ import unicode_literals
import os

import datetime
import numpy as np
import pandas as pd

from db_con.db_connect import sql_engine

# ----------------------------------------------
step = 10000
max_limit = 900000
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)
db_names = ['all_back_0430', 'all_back_0531', 'all_back_0630', 'all_back_0731', ]
end_dates = [datetime.date(2017, 5, 1), datetime.date(2017, 6, 1), datetime.date(2017, 7, 1), datetime.date(2017, 8, 1)]
file_path = u'E:/审计出表/现金贷'
file_name = u'现金贷数据'
if not os.path.exists(file_path):
    os.makedirs(file_path)
mysql = sql_engine('audit', 'new_transaction').get_engine()

sql_loan = """SELECT
  lm.loan_id,
  lm.ref_id,
  lc.class                   风险等级,
  lm.funding_code,
  fc.name                    资金方,
  lm.is_active,
  lm.contract_loan_amount    本金债权,
  lm.real_loan_amount        放款金额,
  lm.contract_term           放款总期数,
  lm.qg_one_time_service_fee 一次性服务费,
  date(lm.loan_paid_at)      放款日期,
  year(lm.loan_paid_at)      年,
  month(lm.loan_paid_at)     月,
  lc2.contract_no            合同号
FROM %s.loan_manifest lm
  JOIN basic.loan_class_0912 lc ON lc.ref_id = lm.ref_id
  JOIN basic.funding_corp fc ON fc.funding_code = lm.funding_code
  JOIN basic.loan_contract lc2 ON lc2.ref_id = lc.ref_id
WHERE lm.loan_paid_at < '%s';
"""

sql_plan = """SELECT
  urp.ref_id,
  urp.real_loan_id   loan_id,
  urp.term_no,
  date(urp.deadline) 应还日期,
  urp.principle      应还本金,
  urp.interest       应还利息,
  urp.service_fee    应还服务费
FROM %s.user_repayment_plan urp
  JOIN %s.loan_manifest lm ON lm.ref_id = urp.ref_id AND lm.loan_paid_at < '%s';
"""

sql_ref = """SELECT
  urp.ref_id,
  urp.term_no,
  xrprrr.ref_amount                                 实还总额,
  xrprrr.principle - xrprrr.mitigate_principle      实还本金,
  xrprrr.interest - xrprrr.mitigate_interest        实还利息,
  xrprrr.service_fee - xrprrr.mitigate_service_fee  实还服务费,
  xrprrr.punish - xrprrr.mitigate_collection_relief 实还罚息,
  xrprrr.remain_income                              其他收益,
  DATE(xrprrrrd.repaid_at)                          实还日期,
  xrprrrrd.repay_channel_flow_id                    还款流水号,
  rc.approach_name                                  还款账户
FROM %s.xjd_repay_plan_repay_record_ref xrprrr
  JOIN test_mzh.xjd_repay_plan_repay_record_ref_repay_date_flow xrprrrrd ON xrprrr.id = xrprrrrd.xjd_ref_id
  JOIN %s.user_repayment_plan urp ON urp.id = xrprrr.plan_id
  JOIN new_transaction.repay_channel rc ON rc.id = xrprrr.repay_channel
WHERE xrprrrrd.repaid_at < '%s';"""

sql_ms = """SELECT
  t.loan_id,
  t.term_no,
  t.repay_amt,
  t.repay_principle,
  t.repay_intrest,
  t.qg_service_fee 实还服务费,
  t.late_fee,
  t.penalty_fee,
  date(t.repaid_at) repaid_at
FROM new_mashang.new_ms_transaction_with_term_details t;
"""
sql_yghs = """SELECT
  ref_id,
  actual_qg_service_fee `实还服务费（减免后）`,
  date(repay_date)      repaid_at
FROM new_transaction.yg_huishang_repay_term
"""

# ----------------------------------------------

for i in xrange(0, len(db_names)):
    db_name = db_names[i]
    end_date = end_dates[i]
    # ##############################################
    # 查数据库，并保存文件，时间较长，服务器上在15分钟左右，本机25分钟左右
    df_gen = pd.read_sql(sql=sql_loan % (db_name, end_date,), con=mysql, chunksize=step)
    res = []
    for tmp in df_gen:
        res.append(tmp)
    df_loan = pd.concat(res)
    df_loan['一次性服务费'].fillna(0, inplace=True)
    df_loan.to_csv(os.path.join(file_path, 'all_loan_%s.csv' % db_name), encoding='utf8', index=None)

    df_gen = pd.read_sql(sql=sql_plan % (db_name, db_name, end_date,), con=mysql, chunksize=step)
    res = []
    for tmp in df_gen:
        res.append(tmp)
    df_plan = pd.concat(res)
    df_plan.to_csv(os.path.join(file_path, 'all_plan_%s.csv' % db_name), encoding='utf8', index=None)

    df_gen = pd.read_sql(sql=sql_ref % (db_name, db_name, end_date,), con=mysql, chunksize=step)
    res = []
    for tmp in df_gen:
        res.append(tmp)
    df_ref = pd.concat(res)
    df_ref.to_csv(os.path.join(file_path, 'all_ref_%s.csv' % db_name), encoding='utf8', index=None)

db_name1 = 'audit'
db_name2 = 'new_transaction'
end_date = datetime.date(2017, 9, 1)
df_gen = pd.read_sql(sql=sql_loan % (db_name1, end_date,), con=mysql, chunksize=step)
res = []
for tmp in df_gen:
    res.append(tmp)
df_loan = pd.concat(res)
df_loan['一次性服务费'].fillna(0, inplace=True)
df_loan.to_csv(os.path.join(file_path, 'all_loan_%s.csv' % db_name1), encoding='utf8', index=None)

df_gen = pd.read_sql(sql=sql_plan % (db_name2, db_name1, end_date,), con=mysql, chunksize=step)
res = []
for tmp in df_gen:
    res.append(tmp)
df_plan = pd.concat(res)
df_plan.to_csv(os.path.join(file_path, 'all_plan_%s.csv' % db_name1), encoding='utf8', index=None)

df_gen = pd.read_sql(sql=sql_ref % (db_name2, db_name2, end_date,), con=mysql, chunksize=step)
res = []
for tmp in df_gen:
    res.append(tmp)
df_ref = pd.concat(res)
df_ref.to_csv(os.path.join(file_path, 'all_ref_%s.csv' % db_name1), encoding='utf8', index=None)

# df_ms = pd.read_sql(sql=sql_ms, con=mysql)
# df_ms.to_csv(os.path.join(file_path, 'ms.csv'), encoding='utf8', index=None)
# df_yghs = pd.read_sql(sql=sql_yghs, con=mysql)
# df_yghs.to_csv(os.path.join(file_path, 'yghs.csv'), encoding='utf8', index=None)
