# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
from itertools import product
import os

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None
max_limit = 800000



#
# 表名称：
#	去哪儿-赔付明细
#表字段：
#	product_no 资金方	应还期数	应还资金方本金	应还资金方利息	应还资金方时间	实还本金	实还利息	赔付
# 数据库：
#	qunaer_new
# 注意事项：
#	需要去掉转保理的订单，方式为left join baoli_pay_detail .... where product_no is null
#

file_path = u'E:/审计出表/去哪儿-赔付专区/'
engine_qunaer = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/qunaer_new?charset=utf8',
							  echo=False).connect()



# fund plan
sql_fund_plan='''
select fund_code,product_no,current_stage_no,principle,interest,fee_amount,due_amount,date(deadline) deadline
from qunaer_new.fund_repayment_plan 
'''

sql_del='''
select product_no from qunaer_new.fund_repay_detail where type  IN (5,7)
'''


sql_repay='''
select repay.product_no,current_stage_no,date(repay_time) repay_time,repay_principle,repay_fee_amount,repay_due_amount
from qunaer_new.repay_detail  repay
JOIN qunaer_new.pay_detail pay on repay.product_no = pay.product_no and pay.status = 1
where repay.fund_code !=1
'''

sql_refund='''
select product_no,-sum(refund_principle) refund_principle ,-sum(refund_fee_amount) refund_fee_amount 
from qunaer_new.refund_detail WHERE product_no in %s 
and fund_code != 1
GROUP BY 1
'''

# sql_refund = '''
# select product_no from qunaer_new.refund_detail where fund_code != 1
# '''


def qunaer_peifu(start_time,end_time):
	#year,month = 2017,9

	df_fund_plan=pd.read_sql(sql_fund_plan ,engine_qunaer)

	df_fund_plan.ix[df_fund_plan.deadline >= end_time,'principle']=0
	df_fund_plan.ix[df_fund_plan.deadline < start_time, 'principle'] = 0

	df_fund_plan.ix[df_fund_plan.deadline >= end_time, 'fee_amount'] = 0
	df_fund_plan.ix[df_fund_plan.deadline < start_time, 'fee_amount'] = 0

	df_del = pd.read_sql(sql_del,engine_qunaer)

	df_fund_plan = df_fund_plan.ix[~df_fund_plan.product_no.isin(df_del.product_no)]

	df_repay=pd.read_sql(sql_repay,engine_qunaer)
	df_repay = df_repay.ix[~df_repay.product_no.isin(df_del.product_no)]

	df_fund_plan['product_no'] = df_fund_plan['product_no'].astype(str)
	df_repay['product_no'] = df_repay['product_no'].astype(str)
	df_repay=pd.merge(df_repay,df_fund_plan[['product_no', 'current_stage_no', 'deadline']],how='left')
	df_repay.ix[df_repay.repay_time >=end_time,'repay_principle'] = 0
	df_repay.ix[df_repay.repay_time >= end_time, 'repay_fee_amount'] = 0
	df_repay.ix[df_repay.deadline < start_time,'repay_principle'] = 0
	df_repay.ix[df_repay.deadline < start_time, 'repay_fee_amount'] = 0
	df_repay.ix[df_repay.deadline >= end_time, 'repay_principle'] = 0
	df_repay.ix[df_repay.deadline >= end_time, 'repay_fee_amount'] = 0
	df_repay.ix[(df_repay.repay_time < start_time) & (df_repay.deadline < start_time),'repay_principle'] = 0
	df_repay.ix[(df_repay.repay_time < start_time) & (df_repay.deadline < start_time), 'repay_fee_amount'] = 0

	df_result = pd.merge(df_repay[['product_no', 'current_stage_no', 'repay_time', 'repay_principle','repay_fee_amount']],
						df_fund_plan[['fund_code','product_no', 'current_stage_no', 'deadline', 'principle','fee_amount']],
						on=['product_no', 'current_stage_no'], how='outer')

	df_result = df_result.fillna(0)
	df_result.loc[df_result[['product_no', 'current_stage_no']].duplicated(),'principle'] = 0
	df_result.loc[df_result[['product_no', 'current_stage_no']].duplicated(), 'fee_amount'] = 0
	df_result.deadline=pd.to_datetime(df_result.deadline).dt.date
	df_result=df_result.ix[df_result.deadline < end_time]
	df_result_gp=df_result.groupby(['product_no'])['repay_principle','repay_fee_amount','principle','fee_amount'].sum().reset_index()
	df_refund=pd.read_sql(sql_refund % str(tuple(df_result_gp['product_no'].astype(str).tolist())),engine_qunaer)
	df_result_gp=pd.merge(df_result_gp,df_refund,on='product_no',how='left')
	df_result_gp= df_result_gp.fillna(0)
	df_result_gp[u'peifu'] = df_result_gp['principle'] - df_result_gp['repay_principle']-df_result_gp['refund_principle']

	df_result_gp.rename(columns = {'fund_code':u'资金方','product_no':u'产品编号','current_stage_no':u'当前期数','principle':u'应还本金','interest':u'应还利息', \
								'fee_amount':u'应还服务费','due_amount':u'应还罚息','deadline':u'应还日期','repay_time':u'实还日期','repay_principle':u'实还本金', \
								'repay_fee_amount':u'实还服务费','repay_due_amount':u'实还罚息','peifu':u'赔付','refund_principle':u'退款本金','refund_fee_amount':u'退款服务费'
								} ,inplace=True)

	df_result_gp.to_excel(file_path+u'去哪儿赔付明细_%s.xlsx'%(start_time),index=None)

if __name__ == '__main__':

	print '____main__start'
	start_time = datetime.date(2017, 9, 1)
	end_time = datetime.date(2017, 10, 1)
	qunaer_peifu(start_time,end_time)
	print '____main__end'
