# encoding: utf8
import pandas as pd
from dateutil.relativedelta import relativedelta
import datetime
import numpy as np
from sqlalchemy import create_engine



'''
1、渤海的结算同资金方结算一致
2、支付宝拆分渤海的时候，需要同资金方结算一致。
'''


engine_fs = create_engine(
    'mysql+mysqldb://bowang:in78u6ytgbhj56r@192.168.4.6:8066/financial_system?charset=utf8',
    echo=False)

engine_xyqb = create_engine(
    'mysql+mysqldb://bowang:in78u6ytgbhj56r@192.168.4.6:8066/xyqb?charset=utf8',
    echo=False)

engine_audit = create_engine(
    'mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/new_transaction?charset=utf8',
    echo=False)

year=2017
month = 7

start_time = datetime.datetime(year,month,1,0,0,0)
end_time = start_time + relativedelta(months=+1)
sql_ali='''
select id record_id,income,business_flow 
from offline_alipay_record 
WHERE transfer_time >= '%s' AND transfer_time < '%s' AND enable = 1
''' % (start_time,end_time)
df_ali=pd.read_sql(sql_ali,engine_audit)

sql_fs='''
select a.businessFlow business_flow, r.biz_type, r.biz_loan_no, r.curr_term, r.debt_funding_corp, t.transfer_amount
from repay_offline_record r 
join repay_offline_transfer_record t on r.id = t.repay_offline_record_id AND t.enable = 1 
join off_line_alipay_order a on a.id = t.alipay_orderid AND a.time >= '%s' and a.time < '%s' 
where  r.enable = 1 
  and r.repay_status in (
    'REPAY_BIZ_STATUS_OK',
    'REPAY_FINANCIAL_CONFIRM'
  )
''' % (start_time,end_time)

df_fs=pd.read_sql(sql_fs,engine_fs)
df_fs=pd.merge(df_ali,df_fs,on='business_flow',how='right')
df = df_fs.ix[~df_fs.debt_funding_corp.str.contains(u'渤海')]
df_bohai=df_fs.ix[df_fs.debt_funding_corp.str.contains(u'渤海')]

print '----校验record_id--------',df.ix[df.record_id.isnull()]

df = df.merge(df.groupby(by=['record_id'])['transfer_amount'].agg(['sum']).reset_index().rename(columns={'sum': 'sum_trans_amount'}))
df['diff'] = (df['sum_trans_amount'] - df['income']).apply(lambda x: round(x, 2))


df['ref_amount'] = df['transfer_amount']
df_good = df.ix[df['diff'] == 0]
df_bad = df.ix[df['diff'] != 0]
# 修改正确的ref_amount
gps = df_bad.groupby(by=['record_id'])
for record_id, gp in gps:
    avg = round(gp['diff'].tolist()[0] / len(gp), 2)
    for ix, row in gp.iterrows():
        df_bad.ix[ix, 'ref_amount'] -= avg
        gp.ix[ix,'ref_amount'] -= avg
    df_bad.ix[ix, 'ref_amount'] = row['income'] - sum(gp['ref_amount'].tolist()[:-1])
df = pd.concat([df_good, df_bad])
# 检验
tmp = df_bad.merge(df_bad.groupby(by=['record_id'])['ref_amount'].agg(['sum']).reset_index().rename(columns={'sum': 'sum_ref'}))
tmp['diff'] = tmp['sum_ref'] - tmp['income']
print '-----------校验ref_amount-----------' ,tmp.ix[tmp['diff'] != 0].head()
# 现金贷
df_xjd = df.ix[df.biz_type == 0]
sql_plan = """select real_loan_id loan_id, term_no, id plan_id from new_transaction.user_repayment_plan where real_loan_id in %s """
df_xjd.biz_loan_no = df_xjd.biz_loan_no.astype(str)
loan_id_list = df_xjd.biz_loan_no.tolist()
df_plan = pd.read_sql(sql=sql_plan % (str(tuple(loan_id_list)), ), con=engine_audit)
df_plan.fillna(0, inplace=True)
df_xjd = df_xjd.merge(df_plan, left_on=['biz_loan_no', 'curr_term'], right_on=['loan_id', 'term_no'], how='left')
print '----------未找到还款计划-----------',df_xjd.ix[df_xjd.plan_id.isnull()]
#录入数据
df_xjd = df_xjd[['plan_id', 'record_id', 'ref_amount']]
df_xjd['repay_channel'] = 13
# df_xjd.to_sql('xjd_repay_plan_repay_record_ref', con=engine_audit, if_exists='append', index=None)


# 白条，需要现查找对应的order_no
# 线上白条--查找order_no
df_baitiao_online = df.ix[df.biz_type.isin([1,3])]
sql_order_no = """select id order_id, order_no from baitiao_order where id in %s"""
df_baitiao_online.biz_loan_no = df_baitiao_online.biz_loan_no.astype(str)
order_id_list = df_baitiao_online.biz_loan_no.tolist()
df_order_no = pd.read_sql(sql=sql_order_no % (str(tuple(order_id_list)), ), con=engine_xyqb)
df_order_no.order_id = df_order_no.order_id.astype(str)
df_baitiao_online = pd.merge(df_baitiao_online,df_order_no, left_on='biz_loan_no', right_on='order_id', how='inner')
print '-----------未找到的线上白条-----------',df_baitiao_online.ix[df_baitiao_online.order_no.isnull()]
# 线下白条biz_loan_no = order_no
df_baitiao_offline = df.ix[df.biz_type == 2]
df_baitiao_offline['order_no'] = df_baitiao_offline['biz_loan_no']
df_baitiao = pd.concat([df_baitiao_online, df_baitiao_offline])
# 查找白条的还款计划
sql_plan = """select order_no, term_no, id plan_id from new_transaction.user_bt_repayment_plan where order_no in %s """
df_baitiao.order_no = df_baitiao.order_no.astype(str)
order_no_list = df_baitiao.order_no.tolist()
df_plan = pd.read_sql(sql=sql_plan % (str(tuple(order_no_list)), ), con=engine_audit)
df_plan.fillna(0, inplace=True)
df_baitiao = pd.merge(df_baitiao,df_plan, left_on=['order_no', 'curr_term'], right_on=['order_no', 'term_no'], how='left')
print '-----------白条还款计划------------' ,df_baitiao.ix[df_baitiao.plan_id.isnull()]
df_baitiao=df_baitiao.ix[~df_baitiao.plan_id.isnull()]
df_baitiao = df_baitiao[['plan_id', 'record_id', 'ref_amount']]
df_baitiao['repay_channel'] = 13
# df_baitiao.to_sql('baitiao_repay_plan_repay_record_ref', con=engine_audit, if_exists='append', index=None)

# 渤海全部的还款明细
df_bohai.biz_loan_no = df_bohai.biz_loan_no.astype(str)
loan_id_list = df_bohai.biz_loan_no.tolist()
sql_bohai = """select loan.loan_application_history_id loan_id, plan.term_no,plan.repaid_at, plan.current_repayment 
from repayment_plan plan join loan_application_manifest_history loan 
on loan.loan_application_history_id = plan.loan_application_history_id
where loan.loan_application_history_id in %s """ % (str(tuple(loan_id_list),))
df_bohai_record = pd.read_sql(sql=sql_bohai, con=engine_xyqb)
df_bohai_record.loan_id = df_bohai_record.loan_id.astype(str)
df_bohai_all = pd.merge(df_bohai_record, df_bohai, right_on=['biz_loan_no', 'curr_term'], left_on=['loan_id', 'term_no'], how='left')
df_bohai_all.drop(['biz_loan_no', 'curr_term'], axis=1, inplace=True)
df_bohai_all = df_bohai_all.ix[df_bohai_all.record_id.notnull()]
#还款计划
sql_plan = """select real_loan_id loan_id, term_no, id plan_id,deadline, principle, interest, service_fee, should_punish 
from new_transaction.user_repayment_plan where real_loan_id in %s """
loan_id_list = df_bohai_all.loan_id.tolist()
df_plan = pd.read_sql(sql=sql_plan % (str(tuple(loan_id_list)).replace(',)',')'), ), con=engine_audit)
df_plan.fillna(0, inplace=True)
df_bohai_all = df_bohai_all.merge(df_plan, on=['loan_id', 'term_no'], how='left')
print '------------未找到渤海还款计划-----',df_bohai_all.ix[df_bohai_all.plan_id == 0]
df_bohai_all = df_bohai_all.ix[df_bohai_all.plan_id != 0]
df_bohai_all.deadline=pd.to_datetime(df_bohai_all.deadline).dt.date
df_bohai_all.repaid_at=pd.to_datetime(df_bohai_all.repaid_at).dt.date
df_bohai_all['diff_days']=df_bohai_all.apply(lambda x:(x.deadline-x.repaid_at).days,axis=1)
print '-----------有逾期渤海------',df_bohai_all.ix[df_bohai_all.diff_days < 0]
#使用---current_repayment + income 同时控制
df_bohai_all=df_bohai_all.merge(df_bohai_all.groupby('business_flow')['transfer_amount'].sum().reset_index().rename(columns={'transfer_amount':'sum_transfer_amount'}))
df_bohai_all=df_bohai_all.merge(df_bohai_all.groupby(['loan_id','term_no'])['transfer_amount'].sum().reset_index().rename(columns={'transfer_amount':'sum_current_repayment'}))
df_bohai_all['diff_1']=np.round(df_bohai_all['income']-df_bohai_all['sum_transfer_amount'],2)
df_bohai_all['diff_2']=np.round(df_bohai_all['current_repayment'] -df_bohai_all['sum_current_repayment'],2 )
print '-------需要改动的数据-----------',df_bohai_all.ix[(df_bohai_all['diff_1'] !=0) | (df_bohai_all['diff_2'] != 0)]
df_bohai_all_good=df_bohai_all.ix[(df_bohai_all['diff_1'] ==0) & (df_bohai_all['diff_2'] == 0)]
df_bohai_all_good['ref_amount']=df_bohai_all_good['transfer_amount']
df_bohai_all_good=df_bohai_all_good[['plan_id','record_id','ref_amount']]
df_bohai_all_good['repay_channel'] = 13
df_bohai_all_good.to_sql('xjd_repay_plan_repay_record_ref', con=engine_audit, if_exists='append', index=None)



