# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
from itertools import product
import pyexcelerate
import os
max_limit = 800000

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

def faster_sql_reader(sql):
	cmdstr = 'mysql -h172.16.4.60 -uinternal_r -pArbNgtvlJzZHXsEu -P3306 -e "%s" > %s'
	file_name = 'test.txt'
	path_file = os.path.join(os.getcwd(), file_name)
	exe_sql = cmdstr % (sql.replace('`',''), path_file)
	exe_sql = exe_sql.replace('\t','').replace('\n',' ')
	os.system(exe_sql)
	try:
		df = pd.read_csv(path_file, sep='\t',encoding='utf-8')
	except:
		return pd.DataFrame()
	return df

# @author Han
# 表名称：
#	现金贷-核算-还款表明细（1-6月份）
# 表字段：
# 资金方	loanID	放款期数	当前期数	实还款日	实还金额	本金	利息	服务费	罚息	其他收益	收款渠道	渠道流水号
# 数据库：
#	repay_detail，pay_detail
# 注意事项：
#	还款渠道中：支付宝数据与财务数据有差距，属正常情况，易宝-现金贷 有较小的差距，也属正常
#	在线还款、支付宝线下含有渠道流水号
#	趸交服务费需要添加到这个表里
#
file_path = u'E:/审计出表/11月份开始使用表数据/11月份现金贷出表/'
engine_xjd = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.4.60:3306/audit?charset=utf8',
						   echo=False).connect()
read_fund_sql = '''  
SELECT funding_code fund_corp_id,name fund_name FROM basic.funding_corp
'''
read_repay_sql = '''
SELECT id,`approach_name` FROM new_transaction.`repay_channel`
'''

df_fund = pd.read_sql(read_fund_sql, con=engine_xjd)
df_approach = pd.read_sql(read_repay_sql, engine_xjd)
df_approach['id'] = df_approach['id'].astype(int)

# 在线还款部分
read_detail_online_sql = '''
SELECT t1.fund_code,t2.repay_channel,t1.real_loan_id loan_id,t3.contract_term,date(t3.loan_paid_at),t1.term_no,
t6.bill_time repaid_at,
t2.ref_amount,t2.principle-t2.mitigate_principle real_principle,t2.interest-t2.mitigate_interest real_interest,
ifnull(t2.`service_fee`-t2.mitigate_service_fee,0) real_service_fee,IFNULL(t2.`punish`-t2.mitigate_collection_relief, 0) real_punish,t2.remain_income,t6.order_id AS 'business_flow'
FROM all_back_0731.`xjd_repay_plan_repay_record_ref_0731` t2
JOIN all_back_0731.`user_repayment_plan` t1 ON t1.id=t2.plan_id
JOIN all_back_0731.`loan_manifest` t3 ON t1.ref_id=t3.ref_id
JOIN all_back_0731.repay_record_online t6 ON t2.record_id=t6.id AND t2.repay_channel  = t6.pay_approach
LEFT JOIN new_transaction.xjd_dunjiao_plan xdp ON xdp.loan_id = t1.real_loan_id
WHERE  t6.bill_time >= '%s' AND t6.bill_time < '%s'
'''

# 支付宝线下还款
read_detail_alipay_sql = '''
SELECT t1.fund_code,t2.repay_channel,t1.real_loan_id loan_id,t3.contract_term,date(t3.loan_paid_at),t1.term_no,
t6.transfer_time repaid_at,
t2.ref_amount,t2.principle-t2.mitigate_principle real_principle,t2.interest-t2.mitigate_interest real_interest,
ifnull(t2.`service_fee`-t2.mitigate_service_fee,0) real_service_fee,ifnull(t2.`punish`-t2.mitigate_collection_relief,0) real_punish,t2.remain_income,t6.business_flow
FROM all_back_0731.`xjd_repay_plan_repay_record_ref_0731` t2
JOIN all_back_0731.`user_repayment_plan` t1 ON t1.id=t2.plan_id
JOIN all_back_0731.`loan_manifest` t3 ON t1.ref_id=t3.ref_id
JOIN all_back_0731.`offline_alipay_record` t6 ON t2.record_id=t6.id AND t2.repay_channel = 13
WHERE  t6.transfer_time >= '%s' AND  t6.transfer_time < '%s'
'''

# 银行线下还款部分
read_detail_bank_sql = '''
SELECT t1.fund_code,t2.repay_channel,t1.real_loan_id loan_id,t3.contract_term,date(t3.loan_paid_at),t1.term_no,
t6.transfer_time repaid_at,
t2.ref_amount,t2.principle-t2.mitigate_principle real_principle,t2.interest-t2.mitigate_interest real_interest,
ifnull(t2.`service_fee`-t2.mitigate_service_fee,0) real_service_fee,ifnull(t2.`punish`-t2.mitigate_collection_relief,0) real_punish,t2.remain_income
FROM all_back_0731.`xjd_repay_plan_repay_record_ref_0731` t2
JOIN all_back_0731.`user_repayment_plan` t1 ON t1.id=t2.plan_id
JOIN all_back_0731.`loan_manifest` t3 ON t1.ref_id=t3.ref_id
JOIN all_back_0731.`offline_bank_repay_record` t6 ON t2.record_id=t6.id AND t2.repay_channel IN (14,15,16)
WHERE  t6.transfer_time >=  '%s' AND  t6.transfer_time <  '%s'
'''


def dunjiao(year, month):
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)

	sql_dunjiao = '''
	SELECT
		fc.`name` '资金方',
		dj.loan_id,
		dj.real_qg_one_time_service_fee '实还金额',
		dj.xyqb_repaid_at '实还款日',
		rro.order_id '渠道流水号',
		dj.real_qg_one_time_service_fee '趸交服务费',
		rech.approach_name '还款渠道'
	FROM
		new_transaction.xjd_dunjiao_plan dj
		join all_back_0731.loan_manifest lm on lm.loan_id = dj.loan_id
		join basic.funding_corp fc on fc.funding_code = lm.funding_code
		join new_transaction.xjd_dunjiao_plan_ref xdpr on xdpr.plan_id = dj.id
		join new_transaction.repay_channel rech on rech.id = xdpr.repay_channel
		join all_back_0731.repay_record_online rro on rro.id = xdpr.record_id

	WHERE
		dj.xyqb_repaid_at >= '%s'
	AND dj.xyqb_repaid_at < '%s'
	AND dj.repay_status = 3
	''' % (start_time, end_time)

	df_dunjiao = pd.read_sql(sql_dunjiao, engine_xjd)
	return df_dunjiao

# 还款明细
def handle_hk(year, month):
	#year, month = 2017, 5
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)

	df_online_detail = faster_sql_reader(read_detail_online_sql % (start_time, end_time))
	df_alipay_detail = faster_sql_reader(read_detail_alipay_sql % (start_time, end_time))
	df_bank_detail = faster_sql_reader(read_detail_bank_sql % (start_time, end_time))

	df = pd.concat([df_online_detail, df_alipay_detail, df_bank_detail], axis=0)
	if len(df) > 0:
		df['repay_channel'] = df['repay_channel'].astype(int)
		df['fund_code'] = df['fund_code'].astype(int)
		df = pd.merge(df, df_approach, left_on=['repay_channel'], right_on=['id'], how='left')
		df = pd.merge(df, df_fund, left_on=['fund_code'], right_on=['fund_corp_id'], how='left')
		df.reset_index(inplace=True)
		df = df[['fund_name', 'loan_id', 'contract_term',
				 'term_no', 'repaid_at', 'ref_amount',
				 'real_principle', 'real_interest',
				 'real_service_fee', 'real_punish', 'remain_income', 'approach_name', 'business_flow']]
		df.sort_values(by=['loan_id', 'term_no'], inplace=True)

		df.rename(
			columns={'fund_name': u'资金方',
					 'contract_term': u'放款期数', 'term_no': u'当期期数',
					 'repaid_at': u'实还款日', 'ref_amount': u'实还金额',
					 'real_principle': u'实还本金', 'real_interest': u'实还利息', 'real_service_fee': u'实还服务费',
					 'real_punish': u'实还罚息', 'remain_income': u'其他收益', 'approach_name': u'还款渠道', 'business_flow': u'渠道流水号'}, inplace=True)
		print '-----%s-%s' % (year, month)

		# print(df.groupby('还款渠道')['实还金额'].sum())

		df_dunjiao = dunjiao(year,month)
		df = pd.concat([df,df_dunjiao],axis=0)
		df = df.fillna(0)
		df = df[[u'资金方',u'loan_id',u'放款期数',u'当期期数',u'实还款日',u'实还金额',u'实还本金',u'实还利息',u'实还服务费',u'实还罚息',u'其他收益',u'还款渠道',u'渠道流水号']]

		print '___%s-%s' % (year, month)
		print(u'实还金额：', str(sum(df[u'实还金额'])))

		all_wb = pyexcelerate.Workbook()
		for i in xrange(0, len(df), max_limit):
			temp = df[i:i + max_limit]
			temp_list = temp.values.tolist()
			temp_list.insert(0, temp.columns.tolist())
			all_wb.new_sheet(str(int(i / max_limit + 1)), data=temp_list)
		all_wb.save(file_path + u'给审计-现金贷-还款表-(%d-%02d).xlsx' % (start_time.year, start_time.month))
		df.to_csv(file_path + '给审计-现金贷-还款表-(%d-%02d).csv' % (year, month), index=None, encoding='gb18030')

		# df.to_csv(file_path + '现金贷_还款表_明细_1021_'+str(year) + '_' + str(month) + '.csv', columns=df.columns, index=None,encoding='gb18030')
		# df.to_excel(file_path + '现金贷_还款表_明细_1021_'+str(year) + '_' + str(month) + '.xlsx', columns=df.columns, index=None)


if __name__ == '__main__':
	year = [2017]
	month = range(1, 5, 1)

	for year, month in product(year, month):
		handle_hk(year, month)
