# 应收贷前服务费
SELECT
  date_format(loan_paid_at, '%Y-%m') yearMonth,
  sum(service_fee1)   plan_service_fee1
FROM temp.loan_manifest
WHERE is_active = 1 AND loan_paid_at < '2017-01-01 00:00:00'
GROUP BY 1;

# 应收贷前服务费--abc
SELECT
  date_format(t1.loan_paid_at, '%Y-%m') yearMonth,
  t2.class               class_,
  sum(t1.service_fee1)   plan_service_fee1
FROM temp.loan_manifest t1
  JOIN temp.loan_class t2 ON t1.ref_id = t2.ref_id
WHERE t1.is_active = 1 AND t1.loan_paid_at >= '%s' AND t1.loan_paid_at < '%s'
GROUP BY 1, 2;

#应收贷后
SELECT
  date_format(t1.deadline, '%Y-%m') yearMonth,
  sum(t1.service_fee2) plan_service_fee2
FROM temp.user_repayment_plan t1
  JOIN temp.loan_manifest t2 ON t1.ref_id = t2.ref_id AND t2.is_active = 1
WHERE t2.loan_paid_at >= '%s' AND t2.loan_paid_at < '%s' AND t1.deadline >= '%s' AND t1.deadline < '%s'
GROUP BY 1;

#应收贷后---abc
SELECT
  date_format(t1.deadline, '%Y-%m') yearMonth,
  t3.class             class_,
  sum(t1.service_fee2) plan_service_fee2
FROM temp.user_repayment_plan t1
  JOIN temp.loan_manifest t2 ON t1.ref_id = t2.ref_id AND t2.is_active = 1
  JOIN temp.loan_class t3 ON t2.ref_id = t3.ref_id
WHERE t2.loan_paid_at >= '%s' AND t2.loan_paid_at < '%s' AND t1.deadline >= '%s' AND t1.deadline < '%s'
GROUP BY 1, 2;

#实收服务费
SELECT
  date_format(t2.repaid_at, '%Y-%m') yearMonth,
  sum(t1.service_fee1)          real_service_fee1,
  sum(t5.mitigate_service_fee1) mitigate_service_fee1,
  sum(t1.service_fee2)          real_service_fee2,
  sum(t5.mitigate_service_fee2) mitigate_service_fee2
FROM temp.xjd_repay_plan_repay_record_ref t1
  LEFT JOIN temp.xjd_repay_plan_repay_record_ref_mitigate_service_fee t5 ON t1.id = t5.xjd_ref_id
  JOIN temp.xjd_repay_plan_repay_record_ref_repay_date t2 ON t1.id = t2.xjd_ref_id
  JOIN temp.user_repayment_plan t3 ON t1.plan_id = t3.id AND t3.fund_code != 160
  JOIN temp.loan_manifest t4 ON t4.ref_id = t3.ref_id AND t4.is_active = 1
WHERE t4.loan_paid_at >= '%s' AND t4.loan_paid_at < '%s' AND t2.repaid_at >= '%s' AND t2.repaid_at < '%s'
GROUP BY 1;

#实收服务费---abc
SELECT
  date_format(t2.repaid_at, '%Y-%m') yearMonth,
  t6.class                      class_,
  sum(t1.service_fee1)          real_service_fee1,
  sum(t5.mitigate_service_fee1) mitigate_service_fee1,
  sum(t1.service_fee2)          real_service_fee2,
  sum(t5.mitigate_service_fee2) mitigate_service_fee2
FROM temp.xjd_repay_plan_repay_record_ref t1
  LEFT JOIN temp.xjd_repay_plan_repay_record_ref_mitigate_service_fee t5 ON t1.id = t5.xjd_ref_id
  JOIN temp.xjd_repay_plan_repay_record_ref_repay_date t2 ON t1.id = t2.xjd_ref_id
  JOIN temp.user_repayment_plan t3 ON t1.plan_id = t3.id AND t3.fund_code != 160
  JOIN temp.loan_manifest t4 ON t4.ref_id = t3.ref_id AND t4.is_active = 1
  JOIN temp.loan_class t6 ON t4.ref_id = t6.ref_id
WHERE t4.loan_paid_at >= '%s' AND t4.loan_paid_at < '%s' AND t2.repaid_at >= '%s' AND t2.repaid_at < '%s'
GROUP BY 1, 2;

#新马上实收统计
SELECT
  date_format(t1.repaid_at, '%Y-%m') yearMonth,
  sum(t1.service_fee1) real_service_fee1,
  '0'                  mitigate_service_fee1,
  sum(t1.service_fee2) real_service_fee2,
  '0'                  mitigate_service_fee2
FROM temp.new_ms_transaction_with_term_copy t1
  JOIN temp.loan_manifest t2 ON t1.loan_id = t2.loan_id AND t2.funding_code = 160
WHERE t2.loan_paid_at >= '%s' AND t2.loan_paid_at < '%s' AND t1.repaid_at >= '%s' AND t1.repaid_at < '%s'
GROUP BY 1;

#新马上实收服务费 --- abc
SELECT
  date_format(t1.repaid_at, '%Y-%m') yearMonth,
  t3.class             class_,
  sum(t1.service_fee1) real_service_fee1,
  '0'                  mitigate_service_fee1,
  sum(t1.service_fee2) real_service_fee2,
  '0'                  mitigate_service_fee2
FROM temp.new_ms_transaction_with_term_copy t1
  JOIN temp.loan_manifest t2 ON t1.loan_id = t2.loan_id AND t2.funding_code = 160
  JOIN temp.loan_class t3 ON t2.ref_id = t3.ref_id
WHERE t2.loan_paid_at >= '%s' AND t2.loan_paid_at < '%s' AND t1.repaid_at >= '%s' AND t1.repaid_at < '%s'
GROUP BY 1, 2;

