# -*- encoding: utf8 -*-
import sys
import os
from datetime import *
import numpy as np
import pandas as pd
from sqlalchemy import create_engine

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None
'''
@author wang.linfang
1、当月的放款表
根据账单文件出表
'''

# 去哪儿源文件
path = u'E:/核对账单/去哪儿/去哪儿账单文件/2017'
# 放款表输出路劲
out = u'E:/核对账单/去哪儿/res/'
# 当前月份
this_month = '2017-05'
engine_qunaer = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/qunaer_new?charset=utf8', echo=False).connect()

#当前的放款记录
def convert_pay():
    df=pd.DataFrame()
    for filename in os.listdir(path):
        f = os.path.join(path, filename)
        if os.path.isfile(f) and this_month in f and f.endswith('LIANGHP_payInfo.txt'):
            ff = file(f).readlines()
            while len(ff[-1]) == 0 or ff[-1].startswith('F|'):
                del ff[-1]
            if ff[0].startswith('H|'):
                del ff[0]
            df_tmp=pd.DataFrame(ff,columns=['Line'])
            df_tmp['产品编号']=df_tmp['Line'].apply(lambda x:x.strip().split('|')[2])
            df_tmp['贷款时间']=df_tmp['Line'].apply(lambda x:x.strip().split('|')[3])
            df_tmp['贷款金额'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[4])
            df_tmp['分期数'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[5])
            df_tmp['用户编号'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[7])
            df_tmp['分期费率'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[10])
            df_tmp['应还分期服务费'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[9])
            df=df.append(df_tmp[['产品编号','贷款时间','贷款金额','分期数','用户编号','分期费率','应还分期服务费']])
    #删除重复项
    len1=len(df)
    df.drop_duplicates(subset=['产品编号'], inplace=True, keep='last')
    len2=len(df)
    if len1 != len2 :
        print '------------------有重复放款,检查问题！！！！------------'
    df['贷款金额'] = df['贷款金额'].astype(float)
    df['分期数'] = df['分期数'].astype(int)
    df['用户编号'] = df['用户编号'].astype(long)
    df['贷款时间'] = pd.to_datetime(df['贷款时间'])
    df['分期数'] = df['分期数'].apply(lambda x: np.where(x == 0, x + 1, x))
    df['分期费率'] = df['分期费率'].apply(lambda x: float(str(x).strip('%')) / 100)
    # pay_new['应还分期服务费'] = pay_new['贷款金额'] * pay_new['分期费率'] * pay_new['分期数']
    return df


#当前的退款记录
def convert_refund():
    df=pd.DataFrame()
    for filename in os.listdir(path):
        f = os.path.join(path, filename)
        if os.path.isfile(f) and this_month in f and f.endswith('_LIANGHP_refundInfo.txt'):
            ff = file(f).readlines()
            while len(ff[-1]) == 0 or ff[-1].startswith('F|'):
                del ff[-1]
            if ff[0].startswith('H|'):
                del ff[0]
            df_tmp=pd.DataFrame(ff,columns=['Line'])
            df_tmp['产品编号']=df_tmp['Line'].apply(lambda x:x.strip().split('|')[1])
            df_tmp['退款编号'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[2])
            df_tmp['退款时间']=df_tmp['Line'].apply(lambda x:x.strip().split('|')[3])
            df_tmp['退款总额'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[4])
            df_tmp['已退本金'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[8])
            df_tmp['已退手续费'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[9])
            df_tmp['已退逾期罚息'] = df_tmp['Line'].apply(lambda x: x.strip().split('|')[10])
            df=df.append(df_tmp[['产品编号','退款编号','退款时间','退款总额','已退本金','已退手续费','已退逾期罚息']])
    df.drop_duplicates(subset=['退款编号'], inplace=True)
    return df


#当前的转分期记录
#转分期文件处理
def convert_trans():
    list1=[]
    for filename in os.listdir(path):
        f = os.path.join(path, filename)
        if os.path.isfile(f) and this_month in f and f.endswith('_LIANGHP_transInfo.txt'):
            ff = file(f)
            for line in ff:
                line = line.strip()
                if line.startswith('H|') or line.startswith('F|') or len(line) == 0:
                    continue
                line_split=line.split('|')
                last_info_split = line_split[-1].split(',')
                for old_product_no in last_info_split:
                    list1.append([line_split[2],line_split[3],line_split[4],line_split[6],line_split[7],line_split[11],line_split[12],old_product_no])
    #当前月份的转分期
    df= pd.DataFrame(list1,columns=['新单','贷款时间','转分期时间','贷款金额','分期数','应还分期服务费','分期费率','旧单'])
    df['分期数']=df['分期数'].astype(int)
    df['分期数'] = df['分期数'].apply(lambda x: np.where(x == 0, x + 1, x))
    df['分期费率'] = df['分期费率'].apply(lambda x: float(str(x).strip('%')) / 100)
    return  df





if __name__ == '__main__':
    #当前放款表+转分期表+退款表---统计为 所有的非转分期 放款金额和 - 退款和，转分期订单金额不进行统计
    df_pay=convert_pay()
    df_trans=convert_trans()
    df_refund=convert_refund()
    # 2、转分期订单处理
    df_pay['是否为转分期后订单号']=False
    df_trans['是否为转分期后订单号']=True
    df_refund['是否为转分期后订单号']=False
    #转分期订单存在 新单：旧单=1：n,故需要进行删除重复项
    df_trans.drop_duplicates(subset=['新单'],inplace=True)
    df_new = pd.DataFrame()
    df_new = df_new.append(df_pay[['产品编号','贷款时间','贷款金额','分期数','应还分期服务费','是否为转分期后订单号']])
    df_trans.drop(['贷款时间'],inplace=True,axis=1)
    df_trans.rename(columns={'新单':'产品编号','转分期时间':'贷款时间'},inplace=True)
    df_new = df_new.append(df_trans[['产品编号','贷款时间','贷款金额','分期数','应还分期服务费','是否为转分期后订单号']],ignore_index=True)
    #退款处理，退款 --- 根据所有的
    df_refund['退款总额']=df_refund['退款总额'].astype(float)
    df_refund['已退本金'] = df_refund['已退本金'].astype(float)
    df_refund['已退手续费'] = df_refund['已退手续费'].astype(float)
    df_refund['已退逾期罚息'] = df_refund['已退逾期罚息'].astype(float)
    df_refund['退款总额']=df_refund['退款总额'].apply(lambda x:round(0-x,2))
    df_refund['已退本金']=df_refund['已退本金'].apply(lambda x:round(0-x,2))
    df_refund['已退手续费'] = df_refund['已退手续费'].apply(lambda x: round(0 - x, 2))
    df_refund['已退逾期罚息'] = df_refund['已退逾期罚息'].apply(lambda x: round(0 - x, 2))
    #退款订单号来源--- 当月订单号+当月以前的订单号
    sql_1='''
    select product_no ,stages  from pay_detail where product_no in %s
    '''
    df_1=pd.read_sql(sql_1 % str(tuple(df_refund['产品编号'].astype(str).tolist())).replace(',)',')'),engine_qunaer)
    df_1.rename(columns={'product_no':'产品编号','stages':'分期数'},inplace=True)
    #当月的订单信息
    df_2=(df_new.ix[df_new['产品编号'].isin(df_refund['产品编号'])])[['产品编号','分期数']]
    df_3=pd.concat([df_1,df_2],ignore_index=True,axis=0)
    # df_3 中查找重复的
    df_3=df_3.merge(df_3.groupby(by='产品编号')['产品编号'].agg({'count'}).reset_index().rename(columns={'count':'count_by_product_no'}))
    #有可能有退款,可不用管
    print '---------------重复的产品编号-------',len(df_3.ix[df_3['count_by_product_no'] != 1])
    df_3.drop_duplicates(subset=['产品编号'],inplace=True)
    df_refund=pd.merge(df_refund,df_3,on='产品编号',how='left')
    #如果有数据，则数据有问题或数据查询的不全面
    print '------未找到退款订单的分期数----',df_refund.ix[df_refund['分期数'].isnull()]
    df_refund['应还分期服务费']=0
    df_refund.rename(columns={'退款时间':'贷款时间','退款总额':'贷款金额'},inplace=True)
    df_new['已退本金'] = 0
    df_new['已退手续费'] = 0
    df_new['已退逾期罚息'] = 0
    df_new = df_new.append(df_refund[['产品编号', '贷款时间', '贷款金额', '分期数', '应还分期服务费', '是否为转分期后订单号','已退本金','已退手续费','已退逾期罚息']], ignore_index=True)
    #数据优化
    df_new['分期数']=df_new['分期数'].astype(int)
    df_new['贷款金额']=df_new['贷款金额'].astype(float)
    df_new['应还分期服务费']=df_new['应还分期服务费'].astype(float)
    df_new['应还总金额']=df_new['贷款金额']+df_new['应还分期服务费']
    df_new.to_csv(os.path.join(out,'pay_%s.csv' % this_month))
