# encoding: utf8
import pandas as pd
from sqlalchemy import create_engine

pd.options.mode.chained_assignment = None

engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/audit?charset=utf8', echo=True)
engine_audit_select = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/audit?charset=utf8',
                                    echo=True)
sql_insert = """ 
  insert into funding_loan_manifest
    (funding_code,lending_id,lending_amount,term,loan_paid_at,funding_one_time_service_fee,
      funding_interest_rate,is_assignment_of_debt,ref_id,is_active,loan_id) 
    VALUES (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)"""
sql_select = """
  select funding_code,id,contract_loan_amount,contract_term,loan_paid_at,funding_one_time_service_fee,
      monthly_interest_rate,is_assignment_of_debt,ref_id,is_active,loan_id 
  from loan_manifest 
  WHERE loan_paid_at>='%s' AND  loan_paid_at< '%s'
  """

select_exist = """select id fund_id,ref_id from funding_loan_manifest where ref_id in %s """
sql_update = """ 
  update funding_loan_manifest 
    set funding_code=%s,lending_id=%s,lending_amount=%s,term=%s,
      loan_paid_at=%s,funding_one_time_service_fee=%s,funding_interest_rate=%s,
      is_assignment_of_debt=%s,is_active=%s,loan_id=%s
    WHERE  id=%s """

start_time = '2017-08-01'
end_time = '2017-09-01'


def insert_funding():
    df = pd.read_sql(sql_select % (start_time, engine_audit), con=engine_audit_select, chunksize=10000)
    loop = True
    while loop:
        try:
            df_all = pd.DataFrame()
            df_all = df_all.append(df.next(), ignore_index=True)
            df_all.ref_id = df_all.ref_id.astype(int)
            va = df_all['ref_id'].tolist()
            df_e = pd.read_sql(select_exist % str(tuple(va), ), engine_audit_select)
            if len(df_e) > 0:
                df_e.ref_id = df_e.ref_id.astype(int)
                df_exist = df_all.merge(df_e, how='inner', on='ref_id')
                if len(df_exist):
                    df_all = df_all.ix[~df_all.ref_id.isin(df_exist.ref_id)]
                    update_values = df_exist[['funding_code', 'lending_id', 'lending_amount', 'term', 'loan_paid_at',
                                              'funding_one_time_service_fee', 'funding_interest_rate',
                                              'is_assignment_of_debt', 'is_active', 'loan_id', 'fund_id'
                                              ]].values.tolist()
                    engine_audit.execute(sql_update, update_values)
            if len(df_all) > 0:
                data = df_all.values.tolist()
                engine_audit.execute(sql_insert, data)
        except StopIteration:
            loop = False


insert_funding()
