# -*- coding: utf-8 -*-
import sys
import numpy as np
import pandas as pd
from sqlalchemy import create_engine
import datetime

reload(sys)
sys.setdefaultencoding('utf8')

'''
根据loan_id 展开赔付
注意：首先根据 导出数据_2016.sql 执行将数据导出到对应的文件中
涉及到的文件： loan_{year}.csv  fund_{year}.csv plan_{year}.csv 
repay_online_{year}.csv repay_offline_{year}.csv 
'''

engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/all_back_0630?charset=utf8',
    echo=True)

path = 'E:/peifu/peifu_v2_2015/'

# 放款
loan_year = 2016
# 监控时间点
time = datetime.date(2017, 7, 1)

df_pay = pd.read_csv(path + 'loan.csv')
# 扣除新马上
df_pay = df_pay.ix[df_pay.funding_code != 160]
df_pay.loan_paid_at = pd.to_datetime(df_pay.loan_paid_at).dt.date
df_pay['loan_year'] = df_pay.loan_paid_at.apply(lambda x: x.year)
df_pay = df_pay.ix[df_pay.loan_year == loan_year]
df_pay.ref_id = df_pay.ref_id.astype(int)

df_fund = pd.read_csv(path + 'fund.csv')
print '------df_fund is null----', df_fund.ix[df_fund.funding_code.isnull()]
df_fund = df_fund.ix[~df_fund.funding_code.isnull()]
df_fund.funding_code = df_fund.funding_code.astype(int)
df_fund = df_fund.ix[~df_fund.funding_code.isin([1, 2, 3, 4, 5, 210, 270, 310, 320, 50, 80, 130])]

df_plan = pd.read_csv(path + 'plan.csv')
df_plan.funding_code = df_plan.funding_code.astype(int)
df_plan = df_plan.ix[df_plan.funding_code.isin([1, 2, 3, 4, 5, 210, 270, 310, 320])]

df_acd = pd.read_csv(path + 'ACD.csv')
df_acd.funding_code = df_acd.funding_code.astype(int)
df_acd = df_acd.ix[df_acd.funding_code.isin([50, 80, 130])]
df_fund_all = pd.concat([df_fund, df_plan, df_acd], ignore_index=True)

df_fund_all.ref_id = df_fund_all.ref_id.astype(int)
df_fund_all.fund_deadline = pd.to_datetime(df_fund_all.fund_deadline).dt.date
df_fund_all = df_fund_all.ix[df_fund_all.ref_id.isin(df_pay.ref_id)]
# 计算资金方应还的金额,以loan_id 为基准
df_fund_plan = df_fund_all.ix[df_fund_all.fund_deadline < time]
df_fund_plan = df_fund_plan.groupby(['ref_id'])['fund_prin_inst'].sum().reset_index()
print '-----------1----', df_fund_plan['fund_prin_inst'].sum()

# 客户实还
df_repay_online = pd.read_csv(path + 'repay_online.csv')
df_repay_offline = pd.read_csv(path + 'repay_offline.csv')
df_repay = pd.concat([df_repay_online, df_repay_offline], ignore_index=True)
df_repay.fund_code = df_repay.fund_code.astype(int)
df_repay = df_repay.ix[df_repay.fund_code != 160]
df_repay.term_no = df_repay.term_no.astype(int)
df_repay.ref_id = df_repay.ref_id.astype(int)

# 提取放款时间
df_repay = df_repay.ix[df_repay.ref_id.isin(df_pay.ref_id)]
df_repay_other = df_repay.ix[~df_repay.fund_code.isin([150, 29, 50, 80, 130])]
df_repay_fund_deadline = df_repay.ix[df_repay.fund_code.isin([150, 29, 50, 80, 130])]
df_repay_fund_deadline = pd.merge(df_repay_fund_deadline, df_fund_all[['ref_id', 'term_no', 'fund_deadline']],
                                  on=['ref_id', 'term_no'], how='left')
print '-----------lost fund_deadline-----------', df_repay_fund_deadline.ix[
    df_repay_fund_deadline.fund_deadline.isnull()]
df_repay_fund_deadline.deadline = df_repay_fund_deadline.fund_deadline
df_repay = pd.concat([df_repay_other, df_repay_fund_deadline[df_repay_other.columns]], ignore_index=True)
df_repay.repaid_at = pd.to_datetime(df_repay.repaid_at).dt.date
df_repay.deadline = pd.to_datetime(df_repay.deadline).dt.date
print '-----------------2---------', df_repay['real_prin_inst'].sum()
# 还款在监控时间点的
df_repay = df_repay.ix[df_repay.repaid_at < time]
df_repay = df_repay.ix[df_repay.deadline < time]

df_repay_real = df_repay.groupby('ref_id')['real_prin_inst', 'real_punish', 'real_service_fee'].sum().reset_index()
print '-----------------2---------', df_repay_real['real_prin_inst'].sum()
# 比对数据
df = pd.merge(df_pay, df_fund_plan, on='ref_id', how='left')
df = pd.merge(df, df_repay_real, on='ref_id', how='left')

df.fillna(0, inplace=True)
df['peifu'] = np.round(df.fund_prin_inst - df.real_prin_inst, 2)
df['peifu-punish'] = np.round(df.fund_prin_inst - df.real_prin_inst - df.real_punish, 2)
df['peifu-service_fee'] = np.round(df.fund_prin_inst - df.real_prin_inst - df.real_service_fee, 2)
df['peifu-punish-service_fee'] = np.round(df.fund_prin_inst - df.real_prin_inst - df.real_punish - df.real_service_fee,2)
df_class = pd.read_csv(path + 'loan_class.csv')
df_class.ref_id = df_class.ref_id.astype(int)
# df = df.ix[(df['peifu'] != 0) | (df['peifu-punish'] != 0) | (df['peifu-service_fee'] != 0)]
df = df.ix[(df['peifu'] > 0.5) | (df['peifu'] < -0.5)]
df = df.ix[df['peifu'] > 0]
df.ix[df['peifu-punish'] < 0,'peifu-punish'] = 0
df.ix[df['peifu-punish-service_fee'] < 0,'peifu-punish-service_fee'] = 0
df = pd.merge(df, df_class, on='ref_id', how='left')
df.to_csv(path + 'peifu_punish_%d_v1.csv' % loan_year, index=None)
