# -*- encoding: utf8 -*-

"""
计算截止时间之后客户还款的服务费

Author:
  Ma Zhen(zhen.ma@quantgroup.cn)
"""
import pandas as pd
import numpy as np
from sqlalchemy import create_engine

engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/temp?charset=utf8', echo=True)

sql_select = """
SELECT 
  id,
  ref_id,
  loan_id,
  term_no,
  service_fee1,
  service_fee2,
  deadline,
  real_service_fee1,
  real_service_fee2,
  mitigate_service_fee,
  E,
  F,
  no_repay_fee,
  class
FROM
  temp.service_fee_detail_2016 
"""

sql_repay = """
SELECT 
  t3.ref_id,
  t3.term_no,
  t1.service_fee - t1.mitigate_service_fee service_fee_repay_2017,
  t2.repaid_at ,
  concat(date(t2.repaid_at), '还款服务费', round(t1.service_fee - t1.mitigate_service_fee, 2)) remark
FROM
  new_transaction.xjd_repay_plan_repay_record_ref t1 
  JOIN temp.xjd_repay_plan_repay_record_ref_repay_date t2 
    ON t2.xjd_ref_id = t1.id 
    AND t2.repaid_at >= '2017-01-01 00:00:00'  
  JOIN user_repayment_plan t3 
    ON t3.id = t1.plan_id AND t3.fund_code <> 160
    AND t1.service_fee - t1.mitigate_service_fee > 0
    AND t3.ref_id IN %s ;
"""

sql_ms = """
SELECT 
  t2.ref_id,
  t1.term_no,
  t1.qg_service_fee service_fee_repay_2017,
  t1.repaid_at ,
  concat(date(t1.repaid_at), '还款服务费',  round(t1.qg_service_fee, 2)) remark
FROM
  temp.new_ms_transaction_with_term_copy t1 
  JOIN user_repayment_plan t2 ON t2.real_loan_id = t1.loan_id  AND t1.term_no = t2.term_no
  AND t1.qg_service_fee > 0
  AND t2.fund_code = 160 AND t1.repaid_at >= '2017-01-01 00:00:00'  
"""

path = u'E:/财务/tmp/'
path_out = u'E:/财务/'
step = 10000
df = pd.read_sql(sql=sql_select, con=engine_audit, chunksize=step)
# df_all = pd.read_csv(path + 'all_summary_2016.csv', encoding='utf8')
df_all = pd.DataFrame()
for tmp in df:
    df_all = df_all.append(tmp)
# df_all.to_csv(path + 'service_fee_need_to_handle.csv', index=None, encoding='utf8')
ref_ids = df_all.ref_id.drop_duplicates().astype(str).tolist()
res = []
for i in xrange(0, len(ref_ids), step):
    df = pd.read_sql(sql=sql_repay % (str(tuple(ref_ids[i:i + step])).replace(',)', ')'),), con=engine_audit)
    res.append(df)
df_repay = pd.concat(res)
# df_repay.to_csv(path + 'service_fee_repay_2017.csv', index=None, encoding='utf8')
# df_repay = pd.read_csv(path + 'service_fee_repay_2017.csv', encoding='utf8')
df_ms = pd.read_sql(sql=sql_ms, con=engine_audit)
df_repay = pd.concat([df_repay, df_ms])
gp_repay = pd.pivot_table(df_repay, index=['ref_id', 'term_no'], values=['service_fee_repay_2017', 'remark'],
                          aggfunc={'service_fee_repay_2017': np.sum,
                                   'remark': lambda x: ';'.join(list(x))}).reset_index()

df_all_2017 = pd.merge(df_all, gp_repay, on=['ref_id', 'term_no'], how='left')
df_all_2017.fillna(0, inplace=True)
# print len(df_all), len(df_all_2017), len(df_all_2017.ix[df_all_2017.service_fee_repay_2017])
df_all_2017 = df_all_2017.ix[df_all_2017.no_repay_fee <> 0, ['', '', '']]
df_all_2017.to_csv(path + 'service_fee_handled.csv', index=None, encoding='utf8')
# df_all_2017.to_sql('service_fee_detail_2016_with_2017_repay', con=engine_audit, if_exists='append', index=None)

# pd.pivot_table(df, index=["Manager", "Status"], columns=["Product"], values=["Quantity", "Price"],
#                aggfunc={"Quantity": len, "Price": np.sum}, fill_value=0)
