# -*- encoding: utf8 -*-
import sys
import datetime
import pandas as pd
from sqlalchemy import create_engine
from dateutil.relativedelta import relativedelta
import multiprocessing as mtp
from itertools import product

reload(sys)
sys.setdefaultencoding("utf-8")
pd.options.mode.chained_assignment = None

'''
资金方：不出有退款的订单
保理：按照之前的出
债转后的保理：按照保理出
'''


file_path = u'E:/量化派/去哪儿/人工控制/放款表-期后退款/'
file_name = u'放款表-期后退款-%s-%s.xlsx'
engine_qunaer = create_engine('mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/qunaer_new?charset=utf8',
							  echo=False).connect()
# 债权转让后的保理放款表
def baoli_pay(year, month):
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)
	sql_pay = '''
	select '保理' AS '资金方',
		pay.product_no '产品编号',
		pay.trans_time '订单时间',
		pay.loan_time '放款时间',
		'TRUE' as '是否债转',
		pay.loan_amount '合同放款金额',
		pay.stages '贷款总期数',
		'FALSE' AS  '是否转分期后订单'
	from qunaer_new.baoli_pay_detail pay
	where trans_time >='%s' and trans_time < '%s'
	''' % (start_time, end_time)

	# 属于保理的退款
	sql_refund='''
	select '保理' AS '资金方',
	refund.product_no '产品编号',
	sum(refund.refund_principle) '放款对应退款金额'
	from qunaer_new.refund_detail refund
	JOIN qunaer_new.baoli_pay_detail pay on refund.product_no = pay.product_no and refund.fund_code = 1
	WHERE refund_time >='%s' 
	group by 1,2
	''' % (start_time)
	# 读取sql语句，2分钟左右
	df_pay = pd.read_sql(sql_pay, engine_qunaer)
    # 含有 flow_id 的退款，在还款表中体现。
	df_refund = pd.read_sql(sql_refund, engine_qunaer)
	# 合并退款记录和放款记录
	df = pd.merge(df_pay,df_refund,on=[u'资金方',u'产品编号'],how='left')
	df = df.fillna(0)
	return df

# 资金方放款表
def fund_pay(year,month):
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)
	# 资金方的放款表
	sql_pay = '''
    	select fc.fund_name '资金方',
    		pay.product_no '产品编号',
    		pay.trans_time '订单时间',
    		pay.loan_time '放款时间',
    		'FALSE' as '是否债转',
    		pay.loan_amount '合同放款金额',
    		pay.stages '贷款总期数',
    		'FALSE' as  '是否转分期后订单'
    	from qunaer_new.fund_pay_detail pay
    	join qunaer_new.fund_corp fc on pay.fund_code = fc.fund_code
    	where trans_time >='%s' and trans_time < '%s'
    ''' % (start_time, end_time)

	# 属于资金方的退款
	sql_refund = '''
	select
    	refund.product_no '产品编号'
    	from qunaer_new.refund_detail refund
    	JOIN qunaer_new.fund_pay_detail pay on refund.product_no = pay.product_no and refund.fund_code = pay.fund_code
    	WHERE refund_time >='%s'
    	''' % (start_time)
	# 读取sql语句，2分钟左右
	df_pay = pd.read_sql(sql_pay, engine_qunaer)
	# 含有 flow_id 的退款，在还款表中体现。
	df_refund = pd.read_sql(sql_refund, engine_qunaer)
	# 资金方剔除退款的部分
	df = df_pay.ix[~df_pay[u'产品编号'].isin(df_refund[u'产品编号'])]
	df = df.fillna(0)
	return df

#保理的放款表，注意，非债权转让后的放款表
def user_pay(year,month):
	start_time = datetime.datetime(year, month, 1, 0, 0, 0)
	end_time = start_time + relativedelta(months=+1)
	# 用户的放款表
	sql_pay = '''
        select '保理' AS '资金方',
        	pay.product_no '产品编号',
        	pay.trans_time '订单时间',
        	pay.loan_time '放款时间',
        	'FALSE' as '是否债转',
        	pay.loan_amount '合同放款金额',
        	pay.stages '贷款总期数',
        	if(pay.is_ptf = 0,'FALSE','TRUE') '是否转分期后订单'
        from qunaer_new.pay_detail pay
        where pay.fund_code = 1 and trans_time >='%s' and trans_time < '%s'
    ''' % (start_time, end_time)

	# 属于保理的退款
	sql_refund = '''
        select '保理' AS '资金方',
        refund.product_no '产品编号',
        sum(refund.refund_principle) '放款对应退款金额'
        from qunaer_new.refund_detail refund
        JOIN qunaer_new.pay_detail pay on refund.product_no = pay.product_no and refund.fund_code = pay.fund_code
        WHERE pay.fund_code = 1 and refund_time >='%s'
        group by 1,2
    ''' % (start_time)
	# 读取sql语句，2分钟左右
	df_pay = pd.read_sql(sql_pay, engine_qunaer)
	#
	df_refund = pd.read_sql(sql_refund, engine_qunaer)
	# 合并退款记录和放款记录
	df = pd.merge(df_pay,df_refund,on=[u'资金方',u'产品编号'],how='left')
	df = df.fillna(0)
	return df



if __name__ == '__main__':
	years = [2017]
	months = range(8,9)
	for year, month in product(years, months):
		df_baoli=baoli_pay(year,month)
		df_fund=fund_pay(year,month)
		df_user=user_pay(year,month)
		df_plan=pd.concat([df_baoli,df_fund,df_user],ignore_index=True)
		df_plan.to_excel(file_path+file_name % (year,month),encoding='UTF-8',index=None)


print '-----------------------main done---------------------------------------'