# -*- encoding: utf8 -*-

"""
目标：
	收入确认表-以loan_id为维度比较风险金及客户实还服务费
数据库：

字段名：
	loan_id，资金方，风险等级，本金债权，放款日期，计提风险金比例，计提风险金，实还服务费（减免后，含一次性服务费），Asset余额，收入确认金额
注意：
	加入一次性服务费，计提风险金比例
	阳光徽商（fund_code:430）单独拆出计算服务费
	watch_date_add 为截止日期，本次对应的为2017.06.30
"""

import os

import datetime
import numpy as np
import pandas as pd
from db_con.db_connect import *

step = 10000
max_limit = 900000
pd.options.mode.chained_assignment = None
pd.set_option('display.float_format', lambda x: '%.5f' % x)

file_path = u'E:/审计出表/现金贷'
file_name = u'现金贷-核算-资产减值测算表-按季度展开'
if not os.path.exists(file_path):
	os.makedirs(file_path)
mysql = create_engine(
	'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/audit?charset=utf8',
	echo=True)
loan_col = [u'loan_id', u'ref_id', u'风险等级', u'funding_code', u'资金方', u'is_active', u'本金债权', u'qg_one_time_service_fee',
			u'放款日期', u'计提风险金比例']
res_cols = [u'loan_id', u'风险等级', u'资金方', u'本金债权', u'放款日期', u'计提风险金比例', u'计提风险金',
			u'实还服务费（减免后、含一次性服务费）', u'asset余额', u'收入确认金额',u'截止2017年7月31日实还服务费（减免后、含一次性服务费）',u'截止2017年7月31日asset余额']

sql_loan_plan = '''
SELECT
  lm.loan_id,
  lm.ref_id,
  lc.class				  风险等级,
  lm.funding_code,
  fc.name				  资金方,
  lm.is_active,
  lm.contract_loan_amount 本金债权,
  lm.qg_one_time_service_fee,
  date(lm.loan_paid_at)	  放款日期,
  year(lm.loan_paid_at)	  年,
  month(lm.loan_paid_at)  月
FROM audit.loan_manifest lm
  JOIN basic.loan_class lc ON lc.ref_id = lm.ref_id
  JOIN basic.funding_corp fc ON fc.funding_code = lm.funding_code
WHERE lm.loan_paid_at < '2017-10-01';
'''

sql_ref = """SELECT
  urp.ref_id,
  xrprrr.service_fee - xrprrr.mitigate_service_fee `实还服务费（减免后）`,
  DATE(xrprrrrd.repaid_at)						   `repaid_at`
FROM new_transaction.xjd_repay_plan_repay_record_ref xrprrr
  JOIN new_transaction.xjd_repay_plan_repay_record_ref_repay_date xrprrrrd ON xrprrr.id = xrprrrrd.xjd_ref_id
  JOIN new_transaction.user_repayment_plan urp ON urp.id = xrprrr.plan_id
WHERE xrprrrrd.repaid_at < '2017-10-01';
"""

sql_ms = """SELECT
  nmtwtd.loan_id,
  nmtwtd.qg_service_fee	 `实还服务费（减免后）`,
  DATE(nmtwtd.repaid_at) `repaid_at`
FROM test_8_2.new_ms_transaction_with_term_details nmtwtd
WHERE nmtwtd.repaid_at < '2017-10-01'
"""

#阳光徽商取数值sql
sql_yghs = """SELECT
  ref_id,
  actual_qg_service_fee `实还服务费（减免后）`,
  date(repay_date)      repaid_at
FROM new_transaction.yg_huishang_repay_term
"""

# # 查数据库，并保存文件，时间较长，服务器上在15分钟左右，本机25分钟左右
# # t1 = time.time()
# # t1 = 18.05
# df_gen = pd.read_sql(sql=sql_loan_plan, con=mysql, chunksize=step)
# res = []
# for tmp in df_gen:
#  res.append(tmp)
# df_loan = pd.concat(res)
# df_loan['qg_one_time_service_fee'].fillna(0, inplace=True)
# df_loan.to_csv(os.path.join(file_path, 'all_loan.csv'), encoding='utf8', index=None)
# # t2 = time.time()
# # t2-t1
#
# df_gen = pd.read_sql(sql=sql_ref, con=mysql, chunksize=step)
# res = []
# for tmp in df_gen:
#  res.append(tmp)
# df_ref = pd.concat(res)
# df_ref.to_csv(os.path.join(file_path, 'all_ref_0930.csv'), encoding='utf8', index=None)
#
# df_ms = pd.read_sql(sql=sql_ms, con=mysql)
# df_ms.to_csv(os.path.join(file_path, 'ms.csv'), encoding='utf8', index=None)
#
# # 阳光徽商取数据sql
# df_yghs = pd.read_sql(sql=sql_yghs, con=mysql)
# df_yghs.to_csv(os.path.join(file_path, 'yghs.csv'), encoding='utf8', index=None)
 
 #查文件
df_loan = pd.read_csv(os.path.join(file_path, 'all_loan.csv'), encoding='utf8', low_memory=False)
df_ref = pd.read_csv(os.path.join(file_path, 'all_ref_0930.csv'), encoding='utf8', low_memory=False)
df_ms = pd.read_csv(os.path.join(file_path, 'ms.csv'), encoding='utf8', low_memory=False)
df_yghs = pd.read_csv(os.path.join(file_path, 'yghs.csv'), encoding='utf8', low_memory=False)

df_loan[u'放款日期'] = pd.to_datetime(df_loan[u'放款日期'])
df_ref[u'repaid_at'] = pd.to_datetime(df_ref[u'repaid_at'])
df_ms[u'repaid_at'] = pd.to_datetime(df_ms[u'repaid_at'])
df_yghs[u'repaid_at'] = pd.to_datetime(df_yghs[u'repaid_at'])

df_ms.loan_id = df_ms.loan_id.astype(str)
df_loan.loan_id = df_loan.loan_id.astype(str)

df_ratio = pd.read_excel(u'E:/2017风险金计提比例.xlsx')

df_loan_ratio = pd.merge(df_loan, df_ratio, on=[u'风险等级', u'年', u'月'], how='left')
df_loan_ratio.loc[df_loan_ratio.funding_code.isin([270, 310, 320]), u'计提风险金比例'] = 0


def proc_save(watch_date):
	# 0905需求2，《现金贷-核算-资产减值测算表》按季度展开，季后延展6个月
	watch_date_add = datetime.date(2017, 8 ,1)
	
	loan = df_loan_ratio.loc[df_loan_ratio[u'放款日期'] < watch_date]
	loan.loc[~loan.is_active.isin([1, -2]), u'本金债权'] = 0

	loan_other = loan.loc[~loan[u'funding_code'].isin([160, 340])]

	loan_ms = loan.loc[loan[u'funding_code'] == 160]
	loan_yghs = loan.loc[loan[u'funding_code'] == 340]

	loan_other_unique = loan_other[loan_col]
	loan_ms_unique = loan_ms[loan_col]
	loan_yghs_unique = loan_yghs[loan_col]

	ref = df_ref.loc[df_ref.repaid_at < watch_date]
	gp_other = ref.groupby('ref_id')[u'实还服务费（减免后）'].agg(sum).reset_index()

	#新增一列，作为延期6个月之后的实际收服务费
	ref_add = df_ref.loc[df_ref.repaid_at < watch_date_add]
	gp_other_add = ref_add.groupby('ref_id')[u'实还服务费（减免后）'].agg(sum).reset_index()
	gp_other_add = gp_other_add.rename(columns = {u'实还服务费（减免后）':u'截止2017年7月31日实还服务费（减免后）'})
	
	ms = df_ms.loc[df_ms.repaid_at < watch_date]
	gp_ms = ms.groupby('loan_id')[u'实还服务费（减免后）'].agg(sum).reset_index()
	
	#增加一列，延期6个月之后的实收服务费
	ms_add = df_ms.loc[df_ms.repaid_at < watch_date_add]
	gp_ms_add = ms_add.groupby('loan_id')[u'实还服务费（减免后）'].agg(sum).reset_index()
	gp_ms_add = gp_ms_add.rename(columns = {u'实还服务费（减免后）':u'截止2017年7月31日实还服务费（减免后）'})

	yghs = df_yghs.loc[df_yghs.repaid_at < watch_date]
	gp_yghs = yghs.groupby('ref_id')[u'实还服务费（减免后）'].agg(sum).reset_index()

	yghs_add = df_yghs.loc[df_yghs.repaid_at < watch_date_add]
	gp_yghs_add = yghs_add.groupby('ref_id')[u'实还服务费（减免后）'].agg(sum).reset_index()
	gp_yghs_add = gp_yghs_add.rename(columns = {u'实还服务费（减免后）':u'截止2017年7月31日实还服务费（减免后）'})

	loan_other_result = pd.merge(loan_other_unique, gp_other, how='left')
	loan_other_result.fillna(0, inplace=True)
	
	#增加一列，延期6个月之后的实收服务费
	loan_other_result = pd.merge(loan_other_result, gp_other_add, how='left')
	loan_other_result.fillna(0, inplace=True)
	
	loan_ms_result = pd.merge(loan_ms_unique, gp_ms, how='left')
	loan_ms_result.fillna(0, inplace=True)

	#增加一列，延期6个月之后的实收服务费
	loan_ms_result = pd.merge(loan_ms_result, gp_ms_add, how='left')
	loan_ms_result.fillna(0, inplace=True)

	loan_yghs_result = pd.merge(loan_yghs_unique, gp_yghs, how='left')
	loan_yghs_result.fillna(0, inplace=True)

	#增加一列，延期6个月之后的实收服务费
	loan_yghs_result = pd.merge(loan_yghs_result, gp_yghs_add, how='left')
	loan_yghs_result.fillna(0, inplace=True)
	
	loan_result = pd.concat([loan_other_result, loan_ms_result, loan_yghs_result])

	loan_result[u'计提风险金'] = np.round(loan_result[u'本金债权'] * loan_result[u'计提风险金比例'], 2)
	loan_result.loc[loan_result.funding_code.isin([270, 310, 320]), u'计提风险金'] = 0

	loan_result[u'实还服务费（减免后、含一次性服务费）'] = np.round(loan_result[u'实还服务费（减免后）'] + loan_result[u'qg_one_time_service_fee'],
												  2)
																					  
	loan_result[u'asset余额'] = np.maximum(np.round(loan_result[u'计提风险金'] - loan_result[u'实还服务费（减免后、含一次性服务费）'], 2), 0)
	loan_result[u'收入确认金额'] = np.minimum(np.round(loan_result[u'计提风险金'] - loan_result[u'实还服务费（减免后、含一次性服务费）'], 2), 0)
	
	#计算延期6个月之后的实收服务费，一次性服务费，报告日后是否有提交，存疑
	loan_result[u'截止2017年7月31日实还服务费（减免后、含一次性服务费）'] = np.round(loan_result[u'截止2017年7月31日实还服务费（减免后）'] + loan_result[u'qg_one_time_service_fee'],
												  2)
	loan_result[u'截止2017年7月31日asset余额'] = np.maximum(np.round(loan_result[u'计提风险金'] - loan_result[u'截止2017年7月31日实还服务费（减免后、含一次性服务费）'], 2), 0)
	
	print(loan_result[[u'本金债权', u'实还服务费（减免后）', u'实还服务费（减免后、含一次性服务费）',u'截止2017年7月31日实还服务费（减免后、含一次性服务费）',u'截止2017年7月31日asset余额']].sum())
	
	loan_result = loan_result[res_cols]
	loan_result.to_csv(os.path.join(file_path, '%s(%s-%02d)-1010.csv' % (file_name, watch_date.year, watch_date.month - 1)),
					   index=None, columns =res_cols,encoding='gb18030')
	if len(loan_result) > max_limit:
		for i in xrange(0, len(loan_result), max_limit):
			loan_result[i:i + max_limit].to_csv(os.path.join(file_path, '%s(%s-%02d)-%d-1010.csv' % (
			file_name, watch_date.year, watch_date.month - 1, i / max_limit + 1)), index=None,columns =res_cols,  encoding='gb18030')
	if len(loan_result) > max_limit:
		excel_file = pd.ExcelWriter(
			os.path.join(file_path, '%s(%s-%02d)-1010.xlsx' % (file_name, watch_date.year, watch_date.month - 1)))
		for i in xrange(0, len(loan_result), max_limit):
			loan_result[i:i + max_limit].to_excel(excel_file, str(i / max_limit + 1), columns =res_cols,index=None)
		excel_file.save()
	else:
		loan_result.to_excel(
			os.path.join(file_path, '%s(%s-%02d)-1010.xlsx' % (file_name, watch_date.year, watch_date.month - 1),columns =res_cols,),
			index=None)

date_report_list = [datetime.date(2017,2,1)]
for watch_date in date_report_list:
	print(watch_date + datetime.timedelta(days=-1))
	proc_save(watch_date)

#  date_range = pd.date_range(start='2017-02', end='2017-08', freq='MS')
#  for watch_date in date_range:
# 	 print(watch_date,)
# 	 proc_save(watch_date.date())