# 放款明细
SELECT
  t3.merchant_name '商户',
  t1.order_no '产品编号',
  DATE(loan_paid_at) '放款时间',
  contract_loan_amount '放款金额',
  real_loan_amount '本金债权',
  contract_term '总期数',
  t2.term_no '应还期数',
  DATE(t2.deadline) '客户应还时间',
  t2.principle '客户应还本金'
FROM
  `all_back_0630`.`baitiao_order` t1
  JOIN all_back_0630.user_bt_repayment_plan t2
    ON t1.ref_id = t2.ref_id
  JOIN all_back_0630.merchant t3
    ON t1.merchantId = t3.merchant_id
WHERE is_active = 1
  AND loan_paid_at >= '2016-08-01'
  AND loan_paid_at < '2016-09-01';

-- 非去哪儿 预付方式【高阳迅捷，黑哥科技，武汉福禄】
select date_format(transfer_date,'%Y%m%d') '存值时间',merchant_name '商户',
  transfer_amount '金额',serial_number '流水号'
from test_zyl.merchant_qg_serial_ref
WHERE transfer_type = 0 and transfer_date >= '20160801' and transfer_date <'20160901'
AND merchant_name in ('黑格科技','武汉福禄','高阳捷迅');

-- 去哪儿 商户还款
SELECT date_format(t1.transfer_date,'%Y%m%d') '实还时间',t1.transfer_amount '金额',t1.serial_number '流水号'
FROM basic.merchant_qg_serial_ref t1
JOIN all_back_0630.merchant_to_qg t2 ON t1.transfer_id = t2.id AND t1.transfer_type = 1 AND t2.remark LIKE '%去哪%'
and date_format(t1.transfer_date,'%Y%m%d') > '20160801' AND date_format(t1.transfer_date,'%Y%m%d') <= '20160901';


#商户结算
SELECT t2.merchant_name '商户',t1.order_no '产品编号',DATE(t1.loan_paid_at) '放款日期',
  t1.real_loan_amount '订单金额',t1.serial '流水号',t1.contract_loan_amount '结算金额',DATE_FORMAT(t3.transfer_date,'%Y%m%d') '结算日期'
FROM test_zyl.baitiao_order_balance t1
JOIN all_back_0630.merchant t2 ON t1.merchantId = t2.merchant_id
JOIN basic.merchant_qg_serial_ref t3 ON t1.serial = t3.serial_number
WHERE t1.transfer_id is not null AND t3.transfer_date >= '20160801' AND t3.transfer_date < '20160901';


#去哪儿应还+实还---指定放款时间的实还
SELECT t1.product_no '产品编号',t1.current_stage_no '期数',t1.repay_time '实还时间',t1.repay_amount '实还金额' , t1.repay_principle '实还本金',t1.repay_fee_amount '实还服务费',
t1.repay_due_amount '实还罚息',t1.remain '其他收益',t1.flow_id '流水号',t3.`deadline` '应还时间',t3.`principle` '应还本金',t3.`fee_amount` '应还服务费'
FROM qunaer_new.repay_detail t1
JOIN qunaer_new.pay_detail t2 ON t1.product_no = t2.product_no AND t2.trans_time >= '2016-08-01' AND t2.trans_time < '2016-09-01'
JOIN `repayment_plan_2016` t3 ON t1.`product_no` = t3.`product_no` AND t1.`current_stage_no` = t3.`current_stage_no`;

#去哪儿流水明细--- 2016+2017
SELECT t1.product_no '产品编号',t2.loan_time '放款时间',t1.current_stage_no '期数',t1.repay_time '实还时间',t1.repay_amount '实还金额' , t1.repay_principle '实还本金',t1.repay_fee_amount '实还服务费',
t1.repay_due_amount '实还罚息',t1.remain '其他收益',t1.flow_id '流水号',t3.`deadline` '应还时间',t3.`principle` '应还本金',t3.`fee_amount` '应还服务费'
FROM qunaer_new.repay_detail t1
JOIN qunaer_new.pay_detail t2 ON t1.product_no = t2.product_no AND t1.flow_id is not null
JOIN `repayment_plan_2017` t3 ON t1.`product_no` = t3.`product_no` AND t1.`current_stage_no` = t3.`current_stage_no` ;

SELECT t1.product_no '产品编号',t2.loan_time '放款时间',t1.current_stage_no '期数',t1.repay_time '实还时间',t1.repay_amount '实还金额' , t1.repay_principle '实还本金',t1.repay_fee_amount '实还服务费',
t1.repay_due_amount '实还罚息',t1.remain '其他收益',t1.flow_id '流水号',t3.`deadline` '应还时间',t3.`principle` '应还本金',t3.`fee_amount` '应还服务费'
FROM qunaer_new.repay_detail t1
JOIN qunaer_new.pay_detail t2 ON t1.product_no = t2.product_no AND t1.flow_id is not null
JOIN `repayment_plan_2016` t3 ON t1.`product_no` = t3.`product_no` AND t1.`current_stage_no` = t3.`current_stage_no` ;