# -*- coding: utf-8 -*-
import sys
import pandas as pd
from sqlalchemy import create_engine
reload(sys)
sys.setdefaultencoding('utf8')
import numpy as np
import datetime

'''
@author linfang
实际的每日赔付--缺少新马上
'''


engine_new_transaction = create_engine(
    'mysql+mysqldb://yulong_rw:TouBStYwN8wkdxVt@172.16.3.201:3306/all_back_0430?charset=utf8',
    echo=True)
sql_fund = '''
select id fund_code,name fund_name from new_transaction.funding_corp
'''
df_fund = pd.read_sql(sql_fund, con=engine_new_transaction)
df_fund.fund_code=df_fund.fund_code.astype(int)


#还资金方统计
sql_fund_ACD='''
SELECT DATE(transfer_time) day_hk,
CASE fund_corp
 WHEN '曾思成' THEN 130
  WHEN '李然' THEN 80
  WHEN  '张初阳' THEN 50
  END as fund_code
,sum(transfer_amount) plan_all
FROM audit.lkb_to_fund
WHERE  fund_corp in ('曾思成','李然','张初阳')
GROUP BY 1,2
'''
# 客户还款计划统计(广源+渤海使用还款计划统计)
sql_plan='''
select DATE(deadline) day_hk,fund_code,SUM(principle+interest) plan_all
from user_repayment_plan
where deadline < '2017-01-01' and fund_code  in (270, 310, 320, 210)
GROUP BY 1,2
'''
#应还资金方
sql_fund='''
SELECT DATE(deadline) day_hk,funding_code fund_code,SUM(principle+interest) plan_all
FROM audit.`funding_repayment_record` WHERE  is_active = 1
and deadline < '2017-01-01' and funding_code not in (160,50,80,130,270, 310, 320, 210)
GROUP BY 1,2
'''

df_fund_ACD=pd.read_sql(sql_fund_ACD,engine_new_transaction)
df_plan=pd.read_sql(sql_plan,engine_new_transaction)
df_fund_plan=pd.read_sql(sql_fund,engine_new_transaction)
df_fund_all=pd.concat([df_fund_ACD,df_plan,df_fund_plan],ignore_index=True,axis=0)
df_fund_all=df_fund_all.groupby(['day_hk','fund_code'])['plan_all'].sum().reset_index()
#线上还款-正常还款
sql_hk_online_zc='''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) zc_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code not in (160,150)  and DATE(t3.xyqb_repaid_at) = DATE(t3.deadline)
AND t3.xyqb_repaid_at < '2017-01-01'
GROUP by 1,2
'''
#线上还款-逾期还款
sql_hk_online_yq='''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) yq_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code not in (160,150) and DATE(t3.xyqb_repaid_at) > DATE(t3.deadline)
AND t3.xyqb_repaid_at < '2017-01-01'
GROUP by 1,2
'''
#线上还款-提前还款-
sql_hk_online_tq='''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code not in (160,200,150) and DATE(t3.xyqb_repaid_at) < DATE(t3.deadline)
AND t3.xyqb_repaid_at < '2017-01-01'
GROUP by 1,2
'''

#支付宝还款--正常还款
sql_hk_ali_zc='''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) zc_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
join new_transaction.offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13 and t2.transfer_time < '2017-01-01'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id  and t3.fund_code not in (160,150) and DATE(t2.transfer_time) = DATE(t3.deadline)
GROUP by 1,2
'''
#支付宝还款--逾期还款
sql_hk_ali_yq='''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) yq_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
join new_transaction.offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13 and t2.transfer_time < '2017-01-01'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id  and t3.fund_code not in (160,150) and DATE(t2.transfer_time) > DATE(t3.deadline)
GROUP by 1,2
'''
#支付宝还款--提前还款
sql_hk_ali_tq='''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
join new_transaction.offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13 and t2.transfer_time < '2017-01-01'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id  and t3.fund_code not in (160,200,150) and DATE(t2.transfer_time) < DATE(t3.deadline)
GROUP by 1,2
'''

#银行--正常还款
sql_hk_bank_zc='''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) zc_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
join new_transaction.offline_bank_repay_record t2 on t1.record_id = t2.id and t1.repay_channel in (14,15,16) and t2.transfer_time < '2017-01-01'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id  and t3.fund_code not in (160,150) and DATE(t2.transfer_time) = DATE(t3.deadline)
GROUP by 1,2
'''
#银行--逾期还款
sql_hk_bank_yq='''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) yq_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
join new_transaction.offline_bank_repay_record t2 on t1.record_id = t2.id and t1.repay_channel in (14,15,16) and t2.transfer_time < '2017-01-01'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id  and t3.fund_code not in (160,150) and DATE(t2.transfer_time) > DATE(t3.deadline)
GROUP by 1,2
'''
#银行--提前还款
sql_hk_bank_tq='''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
join new_transaction.offline_bank_repay_record t2 on t1.record_id = t2.id and t1.repay_channel in (14,15,16) and t2.transfer_time < '2017-01-01'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id  and t3.fund_code not in (160,200,150)  and DATE(t2.transfer_time) < DATE(t3.deadline)
GROUP by 1,2
'''

#科易的提前还款--- 在 2016-12.27 前按照还款时间进行结算
sql_ky_online_tq='''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code = 200 and DATE(t3.xyqb_repaid_at) < DATE(t3.deadline)
AND t3.xyqb_repaid_at < '2016-12-27'
GROUP by 1,2
'''
#科易的提前还款--- 在 2016-12.27 前按照还款时间进行结算
sql_ky_ali_tq='''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) tq_real_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
join new_transaction.offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13 and t2.transfer_time < '2016-12-27'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id  and t3.fund_code = 200 and DATE(t2.transfer_time) < DATE(t3.deadline)
GROUP by 1,2
'''

#华融的还款deadline 使用还资金方的deadline
sql_hr_online_zc='''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) zc_real_all
FROM new_transaction.xjd_repay_plan_repay_record_ref t1
JOIN new_transaction.user_repayment_plan t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code = 150 and t3.xyqb_repaid_at < '2017-01-01'
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no and DATE(t3.xyqb_repaid_at) = DATE(t4.deadline)
GROUP by 1,2
'''
#华融线上还款--逾期还款
sql_hr_online_yq='''
SELECT DATE(t3.xyqb_repaid_at) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) yq_real_all
FROM new_transaction.xjd_repay_plan_repay_record_ref t1
JOIN new_transaction.user_repayment_plan t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code = 150 and t3.xyqb_repaid_at < '2017-01-01'
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no and DATE(t3.xyqb_repaid_at) > DATE(t4.deadline)
GROUP by 1,2
'''
#华融线上还款--提前还款
sql_hr_online_tq='''
SELECT DATE(t4.deadline) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) tq_real_all
FROM new_transaction.xjd_repay_plan_repay_record_ref t1
JOIN new_transaction.user_repayment_plan t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code = 150 and t3.xyqb_repaid_at < '2017-01-01'
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no and DATE(t3.xyqb_repaid_at) < DATE(t4.deadline)
GROUP by 1,2
'''
#华融线下还款--正常还款
sql_hr_ali_zc='''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) zc_real_all
FROM new_transaction.xjd_repay_plan_repay_record_ref t1
join new_transaction.offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13 and t2.transfer_time < '2017-01-01'
JOIN new_transaction.user_repayment_plan t3 ON t1.plan_id = t3.id  and t3.fund_code = 150
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no and DATE(t2.transfer_time) = DATE(t4.deadline)
GROUP by 1,2
'''
#华融线下还款--逾期还款
sql_hr_ali_yq='''
SELECT DATE(t2.transfer_time) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) yq_real_all
FROM new_transaction.xjd_repay_plan_repay_record_ref t1
join new_transaction.offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13 and t2.transfer_time < '2017-01-01'
JOIN new_transaction.user_repayment_plan t3 ON t1.plan_id = t3.id  and t3.fund_code = 150
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no and DATE(t2.transfer_time) > DATE(t4.deadline)
GROUP by 1,2
'''
sql_hr_ali_tq='''
SELECT DATE(t4.deadline) day_hk,t3.fund_code,sum(t1.principle+t1.interest-t1.mitigate_principle-t1.mitigate_interest) tq_real_all
FROM new_transaction.xjd_repay_plan_repay_record_ref t1
join new_transaction.offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13 and t2.transfer_time < '2017-01-01'
JOIN new_transaction.user_repayment_plan t3 ON t1.plan_id = t3.id  and t3.fund_code = 150
JOIN audit.funding_repayment_record t4 ON t4.ref_id = t3.ref_id AND t4.term_no = t3.term_no and DATE(t2.transfer_time) < DATE(t4.deadline)
GROUP by 1,2
'''

#增加科易提前应还一列,按照deadline统计
sql_ky_online_tq_plan='''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) ky_tq_plan_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id and t1.repay_channel < 13 and t3.fund_code = 200 and DATE(t3.xyqb_repaid_at) < DATE(t3.deadline)
AND t3.xyqb_repaid_at < '2016-12-27'
GROUP by 1,2
'''
sql_ky_ali_tq_plan='''
SELECT DATE(t3.deadline) day_hk,t3.fund_code,sum(t1.`principle`+t1.`interest`-t1.`mitigate_principle`-t1.`mitigate_interest`) ky_tq_plan_all
FROM new_transaction.`xjd_repay_plan_repay_record_ref` t1
join new_transaction.offline_alipay_record t2 on t1.record_id = t2.id and t1.repay_channel = 13 and t2.transfer_time < '2016-12-27'
JOIN new_transaction.`user_repayment_plan` t3 ON t1.plan_id = t3.id  and t3.fund_code = 200 and DATE(t2.transfer_time) < DATE(t3.deadline)
GROUP by 1,2
'''



#正常还款
df_online_zc=pd.read_sql(sql_hk_online_zc,engine_new_transaction)
df_bank_zc=pd.read_sql(sql_hk_bank_zc,engine_new_transaction)
df_ali_zc=pd.read_sql(sql_hk_ali_zc,engine_new_transaction)
df_hr_online_zc=pd.read_sql(sql_hr_online_zc,engine_new_transaction)
df_hr_ali_zc=pd.read_sql(sql_hr_ali_zc,engine_new_transaction)
df_zc=pd.concat([df_online_zc,df_bank_zc,df_ali_zc,df_hr_online_zc,df_hr_ali_zc],ignore_index=True,axis=0)
df_zc=df_zc.groupby(['day_hk','fund_code'])['zc_real_all'].sum().reset_index()

#逾期还款
df_online_yq=pd.read_sql(sql_hk_online_yq,engine_new_transaction)
df_bank_yq=pd.read_sql(sql_hk_bank_yq,engine_new_transaction)
df_ali_yq=pd.read_sql(sql_hk_ali_yq,engine_new_transaction)
df_hr_online_yq=pd.read_sql(sql_hr_online_yq,engine_new_transaction)
df_hr_ali_yq=pd.read_sql(sql_hr_ali_yq,engine_new_transaction)
df_yq=pd.concat([df_online_yq,df_bank_yq,df_ali_yq,df_hr_online_yq,df_hr_ali_yq],ignore_index=True,axis=0)
df_yq=df_yq.groupby(['day_hk','fund_code'])['yq_real_all'].sum().reset_index()

#提前还款
df_online_tq=pd.read_sql(sql_hk_online_tq,engine_new_transaction)
df_bank_tq=pd.read_sql(sql_hk_bank_tq,engine_new_transaction)
df_ali_tq=pd.read_sql(sql_hk_ali_tq,engine_new_transaction)
#科易
df_ky_online_tq=pd.read_sql(sql_ky_online_tq,engine_new_transaction)
df_ky_ali_tq=pd.read_sql(sql_ky_ali_tq,engine_new_transaction)
#华融
df_hr_online_tq=pd.read_sql(sql_hr_online_tq,engine_new_transaction)
df_hr_ali_tq=pd.read_sql(sql_hr_ali_tq,engine_new_transaction)
df_tq=pd.concat([df_online_tq,df_bank_tq,df_ali_tq,df_ky_online_tq,df_ky_ali_tq,df_hr_online_tq,df_hr_ali_tq],ignore_index=True,axis=0)
df_tq=df_tq.groupby(['day_hk','fund_code'])['tq_real_all'].sum().reset_index()



df_ky_tq_online_plan=pd.read_sql(sql_ky_online_tq_plan,engine_new_transaction)
df_ky_tq_ali_plan=pd.read_sql(sql_ky_ali_tq_plan,engine_new_transaction)
df_ky_tq_plan=pd.concat([df_ky_tq_online_plan,df_ky_tq_ali_plan],ignore_index=True,axis=0)
df_ky_tq_plan=df_ky_tq_plan.groupby(['day_hk','fund_code'])['ky_tq_plan_all'].sum().reset_index()

#数据合并
df_fund_all.day_hk=pd.to_datetime(df_fund_all.day_hk).dt.date
df_fund_all.fund_code=df_fund_all.fund_code.astype(int)

df_zc.day_hk=pd.to_datetime(df_zc.day_hk).dt.date
df_zc.fund_code=df_zc.fund_code.astype(int)

df_yq.day_hk=pd.to_datetime(df_yq.day_hk).dt.date
df_yq.fund_code=df_yq.fund_code.astype(int)

df_tq.day_hk=pd.to_datetime(df_tq.day_hk).dt.date
df_tq.fund_code=df_tq.fund_code.astype(int)

df_ky_tq_plan.day_hk=pd.to_datetime(df_ky_tq_plan.day_hk).dt.date
df_ky_tq_plan.fund_code=df_ky_tq_plan.fund_code.astype(int)

df=pd.merge(df_fund_all,df_ky_tq_plan,on=['day_hk','fund_code'],how='outer')
df=pd.merge(df,df_zc,on=['day_hk','fund_code'],how='outer')
df=pd.merge(df,df_yq,on=['day_hk','fund_code'],how='outer')
df=pd.merge(df,df_tq,on=['day_hk','fund_code'],how='outer')
df.fillna(0,inplace=True)
df.fund_code=df.fund_code.astype(int)
df['real_all']=np.round(df['tq_real_all']+df['zc_real_all']+df['yq_real_all'],2)

df.fund_code=df.fund_code.astype(int)
df.ix[df.fund_code == 200,'plan_all']=np.round(df.ix[df.fund_code == 200]['plan_all']-df.ix[df.fund_code == 200]['ky_tq_plan_all']+df.ix[df.fund_code == 200]['tq_real_all'])
df.fund_code=df.fund_code.astype(int)
df=pd.merge(df,df_fund,on='fund_code',how='left')
df=df.ix[df.day_hk < datetime.date(2017,1,1)]
df=df[['plan_all','real_all','tq_real_all','zc_real_all','yq_real_all','day_hk','fund_name']]
df.rename(columns={'plan_all':'资金方应还本息','real_all':'客户实还总额',
                   'tq_real_all':'提前还款','zc_real_all':'正常还款','yq_real_all':'逾期还款'
                   ,'fund_name':'资金方'},inplace=True)

# df.to_excel('E:/peifu/peifu.xlsx', index=None, columns=df.columns, encoding='utf8')
df.to_excel('/root/peifu/peifu.xlsx', index=None, columns=df.columns, encoding='utf8')



