# -*- coding: utf-8 -*-
import sys
import copy
import pandas as pd
from multiprocessing import Manager
from sqlalchemy import create_engine
import multiprocessing as mtp


reload(sys)
sys.setdefaultencoding('utf8')

engine_audit0531 = create_engine(
    'mysql+mysqldb://internal_r:ArbNgtvlJzZHXsEu@172.16.3.201:3306/all_back_0531?charset=utf8', echo=True)

"""
2017年以前逾期的, 在2017年后每天归还的情况.

  资金方的还款计划表       funding_repayment_record  frr
  用户还款计划表          user_repayment_plan        urp
  用户支付扣款的流水表     repay_record_online / offline_alipay_record / offline_bank_repay_record
  用户支付扣款的流水表拆分 xjd_repay_plan_repay_record_ref  rp_rrr

  输入数据筛选
    金额
    资金方
    资金方计划dealine 在2017年以前的
    实际还款流水 repaid_at  发生 在2017年以后的

  按照资金方, 天   来汇总.

  涉及资金方范围
    40 60,220, 280, 310+ 包括310 不用管
"""


urp_deadline = 'urp.deadline'
frr_deadline = 'frr.deadline'


fund_code = 200
fund_deadline_field = frr_deadline  # 根据资金方的deadline 选取字段不一样
fund_deadline = '2017-01-01 00:00:00'

real_paid_start = '2017-01-01 00:00:00'  ## 有错位
real_paid_end = '2017-06-01 00:00:00'


sql_fund = """
    SELECT
      funding_code   fund_code,
      name fund_name
    FROM funding_corp
    WHERE funding_code NOT IN (40, 60, 220, 280, 310) AND funding_code < 310
    ORDER BY fund_code; 
"""
df_fund = pd.read_sql(sql_fund, con=engine_audit0531)

# 科易和湖北消金
ky_config = {
    'fund_deadline_field': frr_deadline,
    'real_paid_start': '2017-01-01 00:00:00'
}
# 华融
hr_config = {
    'fund_deadline_field': frr_deadline,
    'real_paid_start': '2017-01-11 00:00:00'
}

# 洋钱罐(直投)  160 特别处理

# 其他
ot_kl_config = {
    'fund_deadline_field': urp_deadline,
    'real_paid_start': '2017-01-02 00:00:00'
}
ot_other_config = {
    'fund_deadline_field': urp_deadline,
    'real_paid_start': '2017-01-03 00:00:00'
}
# 默认其他
default_config = {
    'fund_deadline_field': urp_deadline,
    'real_paid_start': '2017-01-01 00:00:00'
}


sql2 = """
  SELECT
    '{fund_name}' fund_name,
    DATE(
        CASE
        WHEN (rp_rrr.repay_channel < 13)
          THEN urp.xyqb_repaid_at
        ELSE trp_rrrrd.repaid_at END
    )                      paid_date,
    SUM(rp_rrr.principle - rp_rrr.mitigate_principle +
       rp_rrr.interest - rp_rrr.mitigate_interest
    ) sum_amount
  FROM
    xjd_repay_plan_repay_record_ref rp_rrr
    JOIN temp.xjd_repay_plan_repay_record_ref_repay_date trp_rrrrd ON trp_rrrrd.xjd_ref_id = rp_rrr.id
    JOIN user_repayment_plan urp ON rp_rrr.plan_id = urp.id
    JOIN funding_repayment_record frr ON frr.loan_id = urp.real_loan_id AND frr.term_no = urp.term_no
  WHERE
    urp.fund_code = {fund_code}
    AND {fund_deadline_field} < '{fund_deadline}'
    AND (
      (rp_rrr.repay_channel IN (13, 14, 15, 16) AND trp_rrrrd.repaid_at BETWEEN '{real_paid_start}' AND '{real_paid_end}') OR
      (rp_rrr.repay_channel < 13 AND urp.xyqb_repaid_at BETWEEN '{real_paid_start}' AND '{real_paid_end}')
    )
  GROUP BY paid_date
  ORDER BY fund_name, paid_date;
"""


sql22 = """
  SELECT
    '{fund_name}' fund_name,
    DATE(
        CASE
        WHEN (rp_rrr.repay_channel < 13)
          THEN urp.xyqb_repaid_at
        ELSE trp_rrrrd.repaid_at END
    )                      paid_date,
    SUM(rp_rrr.principle - rp_rrr.mitigate_principle +
       rp_rrr.interest - rp_rrr.mitigate_interest
    ) sum_amount
  FROM
    xjd_repay_plan_repay_record_ref rp_rrr
    JOIN temp.xjd_repay_plan_repay_record_ref_repay_date trp_rrrrd ON trp_rrrrd.xjd_ref_id = rp_rrr.id
    JOIN user_repayment_plan urp ON rp_rrr.plan_id = urp.id
    JOIN funding_repayment_record frr ON frr.ref_id = urp.ref_id AND frr.term_no = urp.term_no
  WHERE
    urp.fund_code = {fund_code}
    AND {fund_deadline_field} < '{fund_deadline}'
    AND (
      (rp_rrr.repay_channel IN (13, 14, 15, 16) AND trp_rrrrd.repaid_at BETWEEN '{real_paid_start}' AND '{real_paid_end}') OR
      (rp_rrr.repay_channel < 13 AND urp.xyqb_repaid_at BETWEEN '{real_paid_start}' AND '{real_paid_end}')
    )
  GROUP BY paid_date
  ORDER BY fund_name, paid_date;
"""

default_fields = {
    "fund_code": 0,
    "fund_name": '',
    "fund_deadline_field": urp_deadline, # TODO
    "fund_deadline": fund_deadline,
    "real_paid_start": real_paid_start,
    "real_paid_end": real_paid_end
}

sql1 = """
    select 
        '新马上' fund_name,
        date(repay_date) paid_date, 
        sum(`repay_principle` + `repay_intrest`) sum_amount
    from new_ms_transaction 
    where repay_date >= '2017-01-01'
    group by paid_date
    having sum_amount
    ORDER BY paid_date;
"""

manager = Manager()
res_df_dict = manager.dict() #


def get_df(fields_config):
    fc = fields_config['fund_code']

    if fc in (1	, 135	, 2	, 240	, 290	, 3	, 4	, 5):## 有的商户没有ref_id  fuck! 我校验忘了切换current schema
        fund_sql = sql2.format(**fields_config)
    else:
        fund_sql = sql22.format(**fields_config)

    df = pd.read_sql(sql=fund_sql, con=engine_audit0531)
    path_out = u'/Users/xujiazhe/Desktop/data/'
    df.to_excel(path_out + str(fc) + '.xlsx', index=None, encoding='utf8')
    res_df_dict[fc] = df

def get_ms_df(fc = 160):
    df = pd.read_sql(sql=sql1, con=engine_audit0531)
    path_out = u'/Users/xujiazhe/Desktop/data/'
    df.to_excel(path_out + str(fc) + '.xlsx', index=None, encoding='utf8')
    res_df_dict[fc] = df

fc_config = {
    # 科易和湖北消金
    200: ky_config,
    290: ky_config,
    # 华融
    150: hr_config,
    # 新马上 特别处理
    160: {},
    # other 考拉
    170: ot_kl_config,
    140: ot_other_config,
    230: ot_other_config,
    240: ot_other_config,
    250: ot_other_config,

}

pool = mtp.Pool(processes=7)
for index, row in df_fund.iterrows():
    fc = int(row['fund_code'])
    fund_name = row['fund_name']
    print '------begin---', fund_name, fc

    if fc == 160:
        #pool.apply_async(get_ms_df, [])
        results = pool.apply_async(get_ms_df, [])
        #get_ms_df()
        print 'end ', fc , results
        continue

    fields_config = copy.deepcopy(default_fields)
    fields_config.update( fc_config.get(fc, {}) )
    fields_config['fund_name'] = fund_name
    fields_config['fund_code'] = fc

    #get_df(fields_config)
    results = pool.apply_async(get_df, [fields_config])
    print 'end ', fc , results

pool.close()
pool.join()

for key in res_df_dict.keys():
    print key, len(res_df_dict[key])

s = pd.concat([res_df_dict[key] for key in res_df_dict.keys()])
path_out = u'/Users/xujiazhe/Desktop/data/'
s.to_excel(path_out + 'total.xlsx', index=None, encoding='utf8')

