# -*- coding: utf-8 -*-
# author WuKong
import pandas as pd
from sqlalchemy import create_engine
import numpy as np
import openpyxl as px
from os import listdir, sys
from os.path import isfile, join, splitext, basename

sql_query_puinsh_rate = """
SELECT
	t3.ref_id,
	t4.id plan_id,
	SUM(
		t1.punish - t1.mitigate_collection_relief
	) / (
		t3.contract_loan_amount * (
			TO_DAYS(t4.xyqb_repaid_at) - TO_DAYS(t4.deadline)
		)
	) punish_rate,
	(
		TO_DAYS(t4.xyqb_repaid_at) - TO_DAYS(t4.deadline)
	) "day"
FROM
	loan_manifest t3
JOIN user_repayment_plan t4 ON t3.ref_id = t4.ref_id
JOIN xjd_repay_plan_repay_record_ref t1 ON t4.id = t1.plan_id
JOIN xjd_repay_plan_repay_record_ref_repay_date_flow t2 ON t1.id = t2.xjd_ref_id
WHERE
	t3.loan_paid_at < "2017-01-01"
AND t3.is_active IN (1 ,- 2)
AND TO_DAYS(t4.xyqb_repaid_at) > TO_DAYS(t4.deadline)
GROUP BY
	t4.id
"""

path = "./"
engine_audit = create_engine('mysql+mysqldb://yulong:ohVU1nPITynSZwR2@172.16.3.201:3306/all_back_0831?charset=utf8', echo=True)
df_punish_rate = pd.read_sql(sql=sql_query_puinsh_rate,con=engine_audit)
df_punish_rate.punish_rate = df_punish_rate.punish_rate.astype(float)
df_punish_rate.punish_rate = df_punish_rate.punish_rate.apply(lambda x: '%.10f' % x)
df_punish_rate = df_punish_rate.sort(['punish_rate'],ascending=[False])

for i in range(0, len(df_punish_rate), 500000):
    df_punish_rate[i:i + 500000].to_csv(path+"punish_rate_2016_%d.csv" % (i), index=None)